/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.operation.bo.BookLengthFundBo;
import cn.com.yusys.yusp.operation.dao.BookLengthFundDao;
import cn.com.yusys.yusp.operation.domain.entity.BookLengthFundEntity;
import cn.com.yusys.yusp.operation.domain.excel.BookLengthFundExcel;
import cn.com.yusys.yusp.operation.domain.query.BookLengthFundQuery;
import cn.com.yusys.yusp.operation.service.BookLengthFundService;
import cn.com.yusys.yusp.operation.vo.BookLengthFundVo;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookLengthFundServiceImpl
implements BookLengthFundService {
    private static final Logger logger = LoggerFactory.getLogger(BookLengthFundServiceImpl.class);
    @Autowired
    private BookLengthFundDao bookLengthFundDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookLengthFundBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookLengthFundDao bookLengthFundDao = (BookLengthFundDao)session.getMapper(BookLengthFundDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookLengthFundBo -> {
                BookLengthFundEntity entity = (BookLengthFundEntity)BeanUtils.beanCopy((Object)bookLengthFundBo, BookLengthFundEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setDutyMan(request.getTradeHead().getUserId());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookLengthFundDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookLengthFundVo show(BookLengthFundQuery bookLengthFundQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookLengthFundQuery);
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookLengthFundQuery.getTradeId() + " ]");
        }
        BookLengthFundVo vo = (BookLengthFundVo)BeanUtils.beanCopy((Object)list.get(0), BookLengthFundVo.class);
        return vo;
    }

    @MyPageAble(returnVo=BookLengthFundVo.class)
    public List index(BookLengthFundQuery bookLengthFundQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookLengthFundQuery.getEndDate())) {
            bookLengthFundQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookLengthFundQuery.getStartDate())) {
            bookLengthFundQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookLengthFundQuery);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookLengthFundVo> list(QueryModel model) throws Exception {
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookLengthFundVo.class);
        return listVo;
    }

    @Override
    public int update(BookLengthFundBo bookLengthFundBo) throws Exception {
        BookLengthFundEntity bookLengthFundEntity = new BookLengthFundEntity();
        BeanUtils.beanCopy((Object)bookLengthFundBo, (Object)bookLengthFundEntity);
        return this.bookLengthFundDao.updateByPrimaryKey(bookLengthFundEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookLengthFundDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public List<BookLengthFundExcel> download(BookLengthFundQuery query) throws Exception {
        QueryModel model = new QueryModel();
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate("00000000");
        }
        model.setCondition((Object)query);
        List<BookLengthFundExcel> list = this.bookLengthFundDao.download(model);
        return list;
    }
}

