/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookDeviceMaintainBo;
import cn.com.yusys.yusp.operation.dao.BookDeviceMaintainDao;
import cn.com.yusys.yusp.operation.domain.entity.BookDeviceMaintainEntity;
import cn.com.yusys.yusp.operation.domain.excel.BookDeviceMaintainExcel;
import cn.com.yusys.yusp.operation.domain.query.BookDeviceMaintainQuery;
import cn.com.yusys.yusp.operation.service.BookDeviceMaintainService;
import cn.com.yusys.yusp.operation.vo.BookDeviceMaintainVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookDeviceMaintainServiceImpl
implements BookDeviceMaintainService {
    private static final Logger logger = LoggerFactory.getLogger(BookDeviceMaintainServiceImpl.class);
    @Autowired
    private BookDeviceMaintainDao bookDeviceMaintainDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookDeviceMaintainBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookDeviceMaintainDao bookDeviceMaintainDao = (BookDeviceMaintainDao)session.getMapper(BookDeviceMaintainDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookDeviceMaintainBo -> {
                BookDeviceMaintainEntity entity = (BookDeviceMaintainEntity)BeanUtils.beanCopy((Object)bookDeviceMaintainBo, BookDeviceMaintainEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setMaintainDate(request.getTradeHead().getWorkDate());
                bookDeviceMaintainDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookDeviceMaintainVo show(BookDeviceMaintainQuery bookDeviceMaintainQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookDeviceMaintainQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookDeviceMaintainQuery.getTradeId() + " ]");
        }
        return (BookDeviceMaintainVo)list.get(0);
    }

    @MyPageAble(returnVo=BookDeviceMaintainVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookDeviceMaintainEntity> list = this.bookDeviceMaintainDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookDeviceMaintainVo> list(QueryModel model) throws Exception {
        List<BookDeviceMaintainEntity> list = this.bookDeviceMaintainDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookDeviceMaintainVo.class);
        return listVo;
    }

    @Override
    public int update(BookDeviceMaintainBo bookDeviceMaintainBo) throws Exception {
        BookDeviceMaintainEntity bookDeviceMaintainEntity = new BookDeviceMaintainEntity();
        BeanUtils.beanCopy((Object)bookDeviceMaintainBo, (Object)bookDeviceMaintainEntity);
        return this.bookDeviceMaintainDao.updateByPrimaryKey(bookDeviceMaintainEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookDeviceMaintainDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<BookDeviceMaintainEntity> bookDeviceMaintainEntities = this.bookDeviceMaintainDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cMaintainDateTitle = rowTitle.createCell(1);
        cMaintainDateTitle.setCellValue("\u7ef4\u62a4\u65f6\u95f4");
        Cell cDevTypeTitle = rowTitle.createCell(2);
        cDevTypeTitle.setCellValue("\u673a\u5177\u7c7b\u578b");
        Cell cDevNumTitle = rowTitle.createCell(3);
        cDevNumTitle.setCellValue("\u8bbe\u5907\u7f16\u53f7");
        Cell cOmitCounterfeitMoneyNumTitle = rowTitle.createCell(4);
        cOmitCounterfeitMoneyNumTitle.setCellValue("\u6f0f\u68c0\u5047\u5e01\u6570");
        Cell cPercentTitle = rowTitle.createCell(5);
        cPercentTitle.setCellValue("\u5360\u6bd4");
        Cell cIsRightCrownNumTitle = rowTitle.createCell(6);
        cIsRightCrownNumTitle.setCellValue("\u51a0\u5b57\u53f7\u7801\u662f\u5426\u5b8c\u6574\u3001\u51c6\u786e");
        Cell cIsNormalPickDamTitle = rowTitle.createCell(7);
        cIsNormalPickDamTitle.setCellValue("\u6311\u6b8b\u662f\u5426\u6b63\u5e38");
        Cell cIsRightVersionCouponTitle = rowTitle.createCell(8);
        cIsRightVersionCouponTitle.setCellValue("\u7248\u522b\u5238\u522b\u662f\u5426\u51c6\u786e");
        Cell cMaintainOperatorTitle = rowTitle.createCell(9);
        cMaintainOperatorTitle.setCellValue("\u7ef4\u62a4\u4eba");
        Cell cRemarkTitle = rowTitle.createCell(10);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        int num = 1;
        for (BookDeviceMaintainEntity bookDeviceMaintainEntity : bookDeviceMaintainEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookDeviceMaintainEntity.getOrgId());
            Cell cMaintainDate = row.createCell(1);
            cMaintainDate.setCellValue(bookDeviceMaintainEntity.getMaintainDate());
            Cell cDevType = row.createCell(2);
            cDevType.setCellValue(bookDeviceMaintainEntity.getDevType());
            Cell cDevNum = row.createCell(3);
            cDevNum.setCellValue(bookDeviceMaintainEntity.getDevNum());
            Cell cOmitCounterfeitMoneyNum = row.createCell(4);
            cOmitCounterfeitMoneyNum.setCellValue(bookDeviceMaintainEntity.getOmitCounterfeitMoneyNum());
            Cell cPercent = row.createCell(5);
            cPercent.setCellValue(bookDeviceMaintainEntity.getPercent());
            Cell cIsRightCrownNum = row.createCell(6);
            if ("0".equals(bookDeviceMaintainEntity.getIsRightCrownNum())) {
                cIsRightCrownNum.setCellValue("\u662f");
            } else if ("1".equals(bookDeviceMaintainEntity.getIsRightCrownNum())) {
                cIsRightCrownNum.setCellValue("\u5426");
            }
            Cell cIsNormalPickDam = row.createCell(7);
            if ("0".equals(bookDeviceMaintainEntity.getIsNormalPickDam())) {
                cIsNormalPickDam.setCellValue("\u662f");
            } else if ("1".equals(bookDeviceMaintainEntity.getIsNormalPickDam())) {
                cIsNormalPickDam.setCellValue("\u5426");
            }
            Cell cIsRightVersionCoupon = row.createCell(8);
            if ("0".equals(bookDeviceMaintainEntity.getIsRightVersionCoupon())) {
                cIsRightVersionCoupon.setCellValue("\u662f");
            } else if ("1".equals(bookDeviceMaintainEntity.getIsRightVersionCoupon())) {
                cIsRightVersionCoupon.setCellValue("\u5426");
            }
            Cell cMaintainOperator = row.createCell(9);
            cMaintainOperator.setCellValue(bookDeviceMaintainEntity.getMaintainOperator());
            Cell cRemark = row.createCell(10);
            cRemark.setCellValue(bookDeviceMaintainEntity.getRemark());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u673a\u5177\u7ef4\u62a4\u4fdd\u517b\u767b\u8bb0\u7c3f.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @Override
    public List<BookDeviceMaintainExcel> download(QueryModel model) throws Exception {
        List<BookDeviceMaintainExcel> list = this.bookDeviceMaintainDao.download(model);
        return list;
    }
}

