/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookDeviceHandoverBo;
import cn.com.yusys.yusp.operation.dao.BookDeviceHandoverDao;
import cn.com.yusys.yusp.operation.domain.entity.BookDeviceHandoverEntity;
import cn.com.yusys.yusp.operation.domain.excel.BookDeviceHandoverExcel;
import cn.com.yusys.yusp.operation.domain.query.BookDeviceHandoverQuery;
import cn.com.yusys.yusp.operation.service.BookDeviceHandoverService;
import cn.com.yusys.yusp.operation.vo.BookDeviceHandoverVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookDeviceHandoverServiceImpl
implements BookDeviceHandoverService {
    @Autowired
    private BookDeviceHandoverDao bookDeviceHandoverDao;

    @Override
    public int create(BookDeviceHandoverBo bookDeviceHandoverBo) throws Exception {
        bookDeviceHandoverBo.setTradeId(StringUtils.getUUID());
        BookDeviceHandoverEntity bookDeviceHandoverEntity = new BookDeviceHandoverEntity();
        BeanUtils.beanCopy((Object)bookDeviceHandoverBo, (Object)bookDeviceHandoverEntity);
        return this.bookDeviceHandoverDao.insert(bookDeviceHandoverEntity);
    }

    @Override
    public BookDeviceHandoverVo show(BookDeviceHandoverQuery bookDeviceHandoverQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookDeviceHandoverQuery);
        List<BookDeviceHandoverEntity> list = this.bookDeviceHandoverDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookDeviceHandoverQuery.getTradeId() + " ]");
        }
        BookDeviceHandoverVo vo = (BookDeviceHandoverVo)BeanUtils.beanCopy((Object)list.get(0), BookDeviceHandoverVo.class);
        return vo;
    }

    @MyPageAble(returnVo=BookDeviceHandoverVo.class)
    public List index(BookDeviceHandoverQuery bookDeviceHandoverQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookDeviceHandoverQuery.getEndDate())) {
            bookDeviceHandoverQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookDeviceHandoverQuery.getStartDate())) {
            bookDeviceHandoverQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookDeviceHandoverQuery);
        List<BookDeviceHandoverEntity> list = this.bookDeviceHandoverDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookDeviceHandoverVo> list(QueryModel model) throws Exception {
        List<BookDeviceHandoverEntity> list = this.bookDeviceHandoverDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookDeviceHandoverVo.class);
        return listVo;
    }

    @Override
    public int update(BookDeviceHandoverBo bookDeviceHandoverBo) throws Exception {
        BookDeviceHandoverEntity bookDeviceHandoverEntity = new BookDeviceHandoverEntity();
        BeanUtils.beanCopy((Object)bookDeviceHandoverBo, (Object)bookDeviceHandoverEntity);
        return this.bookDeviceHandoverDao.updateByPrimaryKey(bookDeviceHandoverEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookDeviceHandoverDao.deleteByPrimaryKey(tradeId);
    }

    public void save(BookDeviceHandoverQuery bookDeviceHandoverQuery, int page, int size, HttpServletResponse response) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        if (StringUtils.isEmpty((CharSequence)bookDeviceHandoverQuery.getEndDate())) {
            bookDeviceHandoverQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookDeviceHandoverQuery.getStartDate())) {
            bookDeviceHandoverQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookDeviceHandoverQuery);
        List<BookDeviceHandoverEntity> bookDeviceHandoverEntities = this.bookDeviceHandoverDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cHandoverDateTitle = rowTitle.createCell(1);
        cHandoverDateTitle.setCellValue("\u4ea4\u63a5\u65e5\u671f");
        Cell cDevIdTitle = rowTitle.createCell(2);
        cDevIdTitle.setCellValue("\u81ea\u52a9\u8bbe\u5907\u7f16\u53f7");
        Cell cDevTypeTitle = rowTitle.createCell(3);
        cDevTypeTitle.setCellValue("\u4ea4\u63a5\u7c7b\u578b");
        Cell cDevNumTitle = rowTitle.createCell(4);
        cDevNumTitle.setCellValue("\u4ea4\u63a5\u6570\u91cf");
        Cell cTransferorTitle = rowTitle.createCell(5);
        cTransferorTitle.setCellValue("\u79fb\u4ea4\u4eba");
        Cell cRcvrTitle = rowTitle.createCell(6);
        cRcvrTitle.setCellValue("\u63a5\u6536\u4eba");
        Cell cSupervisorTitle = rowTitle.createCell(7);
        cSupervisorTitle.setCellValue("\u76d1\u4ea4\u4eba");
        Cell cRemarkTitle = rowTitle.createCell(8);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        int num = 1;
        for (BookDeviceHandoverEntity bookDeviceHandoverEntity : bookDeviceHandoverEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookDeviceHandoverEntity.getOrgId());
            Cell cHandoverDate = row.createCell(1);
            cHandoverDate.setCellValue(bookDeviceHandoverEntity.getHandoverDate());
            Cell cDevId = row.createCell(2);
            cDevId.setCellValue(bookDeviceHandoverEntity.getDevId());
            Cell cDevType = row.createCell(3);
            cDevType.setCellValue(bookDeviceHandoverEntity.getDevType());
            Cell cDevNum = row.createCell(4);
            cDevNum.setCellValue(bookDeviceHandoverEntity.getDevNum());
            Cell cTransferor = row.createCell(5);
            cTransferor.setCellValue(bookDeviceHandoverEntity.getTransferor());
            Cell cRcvr = row.createCell(6);
            cRcvr.setCellValue(bookDeviceHandoverEntity.getRcvr());
            Cell cSupervisor = row.createCell(7);
            cSupervisor.setCellValue(bookDeviceHandoverEntity.getSupervisor());
            Cell cRemark = row.createCell(8);
            cRemark.setCellValue(bookDeviceHandoverEntity.getRemark());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u81ea\u52a9\u8bbe\u5907\u5de5\u4f5c\u65e5\u5fd7.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @Override
    public List<BookDeviceHandoverExcel> download(BookDeviceHandoverQuery query) throws Exception {
        QueryModel model = new QueryModel();
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate("00000000");
        }
        model.setCondition((Object)query);
        List<BookDeviceHandoverExcel> list = this.bookDeviceHandoverDao.download(model);
        return list;
    }
}

