/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookDamagedExchangeBo;
import cn.com.yusys.yusp.operation.dao.BookDamagedExchangeDao;
import cn.com.yusys.yusp.operation.domain.dto.BookDamagedExchangeDto;
import cn.com.yusys.yusp.operation.domain.entity.BookDamagedExchangeEntity;
import cn.com.yusys.yusp.operation.domain.query.BookDamagedExchangeQuery;
import cn.com.yusys.yusp.operation.service.BookDamagedExchangeService;
import cn.com.yusys.yusp.operation.vo.BookDamagedExchangeVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookDamagedExchangeServiceImpl
implements BookDamagedExchangeService {
    @Autowired
    private BookDamagedExchangeDao bookDamagedExchangeDao;

    @Override
    public int create(IcspRequest<BookDamagedExchangeDto> request) throws Exception {
        List<BookDamagedExchangeBo> list = ((BookDamagedExchangeDto)request.getBody()).getExchangeList();
        int count = 0;
        for (BookDamagedExchangeBo bookDamagedExchangeBo : list) {
            BookDamagedExchangeEntity bookDamagedExchangeEntity = new BookDamagedExchangeEntity();
            BeanUtils.beanCopy((Object)bookDamagedExchangeBo, (Object)bookDamagedExchangeEntity);
            bookDamagedExchangeEntity.setExcDate(request.getTradeHead().getWorkDate());
            bookDamagedExchangeEntity.setOrgId(request.getTradeHead().getOrgId());
            bookDamagedExchangeEntity.setTradeId(StringUtils.getUUID());
            this.bookDamagedExchangeDao.insert(bookDamagedExchangeEntity);
            ++count;
        }
        return count;
    }

    @Override
    public BookDamagedExchangeVo show(BookDamagedExchangeQuery bookDamagedExchangeQuery) throws Exception {
        BookDamagedExchangeEntity bookDamagedExchangeEntity = new BookDamagedExchangeEntity();
        BeanUtils.beanCopy((Object)bookDamagedExchangeQuery, (Object)bookDamagedExchangeEntity);
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookDamagedExchangeEntity);
        List<BookDamagedExchangeEntity> list = this.bookDamagedExchangeDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + bookDamagedExchangeEntity.getTradeId() + " ]");
        }
        BookDamagedExchangeVo vo = (BookDamagedExchangeVo)BeanUtils.beanCopy((Object)list.get(0), BookDamagedExchangeVo.class);
        return vo;
    }

    @MyPageAble(returnVo=BookDamagedExchangeVo.class)
    public List index(IcspRequest<BookDamagedExchangeQuery> request) throws Exception {
        QueryModel model = new QueryModel();
        BookDamagedExchangeQuery bookDamagedExchangeQuery = (BookDamagedExchangeQuery)request.getBody();
        model.setPage(request.getQueryModel().getPage());
        model.setSize(request.getQueryModel().getSize());
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookDamagedExchangeQuery.getEndDate())) {
            bookDamagedExchangeQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookDamagedExchangeQuery.getStartDate())) {
            bookDamagedExchangeQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookDamagedExchangeQuery);
        List<BookDamagedExchangeEntity> list = this.bookDamagedExchangeDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookDamagedExchangeVo> list(QueryModel model) throws Exception {
        List<BookDamagedExchangeEntity> list = this.bookDamagedExchangeDao.selectByModel(model);
        List bookDamagedExchangeVos = (List)BeanUtils.beansCopy(list, BookDamagedExchangeVo.class);
        return bookDamagedExchangeVos;
    }

    @Override
    public int update(BookDamagedExchangeBo bookDamagedExchangeBo) throws Exception {
        BookDamagedExchangeEntity bookDamagedExchangeEntity = new BookDamagedExchangeEntity();
        BeanUtils.beanCopy((Object)bookDamagedExchangeBo, (Object)bookDamagedExchangeEntity);
        return this.bookDamagedExchangeDao.updateByPrimaryKey(bookDamagedExchangeEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookDamagedExchangeDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(IcspRequest<BookDamagedExchangeQuery> request, HttpServletResponse response) throws Exception {
        BookDamagedExchangeQuery bookDamagedExchangeQuery = (BookDamagedExchangeQuery)request.getBody();
        QueryModel model = new QueryModel();
        model.setPage(request.getQueryModel().getPage());
        model.setSize(request.getQueryModel().getSize());
        if (StringUtils.isEmpty((CharSequence)bookDamagedExchangeQuery.getEndDate())) {
            bookDamagedExchangeQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookDamagedExchangeQuery.getStartDate())) {
            bookDamagedExchangeQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookDamagedExchangeQuery);
        List<BookDamagedExchangeEntity> bookDamagedExchangeEntities = this.bookDamagedExchangeDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cExcDateTitle = rowTitle.createCell(0);
        cExcDateTitle.setCellValue("\u4ea4\u6613\u65e5\u671f");
        Cell cOrgIdTitle = rowTitle.createCell(1);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cCouponTypeTitle = rowTitle.createCell(2);
        cCouponTypeTitle.setCellValue("\u5238\u522b");
        Cell cExcNumTitle = rowTitle.createCell(3);
        cExcNumTitle.setCellValue("\u6570\u91cf");
        Cell cIsPartDamagedTitle = rowTitle.createCell(4);
        cIsPartDamagedTitle.setCellValue("\u662f\u5426\u7279\u6b8b\u5e01");
        Cell cTotalAmtTitle = rowTitle.createCell(5);
        cTotalAmtTitle.setCellValue("\u5168\u989d");
        Cell cHalfAmtTitle = rowTitle.createCell(6);
        cHalfAmtTitle.setCellValue("\u534a\u989d");
        Cell cOperatorTitle = rowTitle.createCell(7);
        cOperatorTitle.setCellValue("\u7ecf\u529e\u4eba");
        Cell cCheckerTitle = rowTitle.createCell(8);
        cCheckerTitle.setCellValue("\u590d\u6838\u4eba");
        Cell cBussMgrTitle = rowTitle.createCell(9);
        cBussMgrTitle.setCellValue("\u4e1a\u52a1\u4e3b\u7ba1");
        Cell cRemarkTitle = rowTitle.createCell(10);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        Cell cStsTitle = rowTitle.createCell(11);
        cStsTitle.setCellValue("\u72b6\u6001");
        int num = 1;
        for (BookDamagedExchangeEntity bookDamagedExchangeEntity : bookDamagedExchangeEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cExcDate = row.createCell(0);
            cExcDate.setCellValue(bookDamagedExchangeEntity.getExcDate());
            Cell cOrgId = row.createCell(1);
            cOrgId.setCellValue(bookDamagedExchangeEntity.getOrgId());
            Cell cCouponType = row.createCell(2);
            cCouponType.setCellValue(bookDamagedExchangeEntity.getCouponType());
            Cell cExcNum = row.createCell(3);
            cExcNum.setCellValue(bookDamagedExchangeEntity.getExcNum());
            Cell cIsPartDamaged = row.createCell(4);
            cIsPartDamaged.setCellValue(bookDamagedExchangeEntity.getIsPartDamaged());
            Cell cTotalAmt = row.createCell(5);
            cTotalAmt.setCellValue(bookDamagedExchangeEntity.getTotalAmt());
            Cell cHalfAmt = row.createCell(6);
            cHalfAmt.setCellValue(bookDamagedExchangeEntity.getHalfAmt());
            Cell cOperator = row.createCell(7);
            cOperator.setCellValue(bookDamagedExchangeEntity.getOperator());
            Cell cChecker = row.createCell(8);
            cChecker.setCellValue(bookDamagedExchangeEntity.getChecker());
            Cell cBussMgr = row.createCell(9);
            cBussMgr.setCellValue(bookDamagedExchangeEntity.getBussMgr());
            Cell cRemark = row.createCell(10);
            cRemark.setCellValue(bookDamagedExchangeEntity.getRemark());
            Cell cSts = row.createCell(11);
            cSts.setCellValue(bookDamagedExchangeEntity.getSts());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u91d1\u878d\u673a\u6784\u6c61\u635f\u5e01.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

