/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterPropagandaBo;
import cn.com.yusys.yusp.operation.dao.BookCounterPropagandaDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterPropagandaEntity;
import cn.com.yusys.yusp.operation.domain.query.BookCounterPropagandaQuery;
import cn.com.yusys.yusp.operation.service.BookCounterPropagandaService;
import cn.com.yusys.yusp.operation.vo.BookCounterPropagandaVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterPropagandaServiceImpl
implements BookCounterPropagandaService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterPropagandaServiceImpl.class);
    @Autowired
    private BookCounterPropagandaDao bookCounterPropagandaDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookCounterPropagandaBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookCounterPropagandaDao bookCounterPropagandaDao = (BookCounterPropagandaDao)session.getMapper(BookCounterPropagandaDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookCounterPropagandaBo -> {
                BookCounterPropagandaEntity entity = (BookCounterPropagandaEntity)BeanUtils.beanCopy((Object)bookCounterPropagandaBo, BookCounterPropagandaEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookCounterPropagandaDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookCounterPropagandaVo show(BookCounterPropagandaQuery bookCounterPropagandaQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterPropagandaQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterPropagandaQuery.getTradeId() + " ]");
        }
        return (BookCounterPropagandaVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCounterPropagandaVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterPropagandaVo> list(QueryModel model) throws Exception {
        List<BookCounterPropagandaEntity> list = this.bookCounterPropagandaDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterPropagandaVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterPropagandaBo bookCounterPropagandaBo) throws Exception {
        BookCounterPropagandaEntity bookCounterPropagandaEntity = new BookCounterPropagandaEntity();
        BeanUtils.beanCopy((Object)bookCounterPropagandaBo, (Object)bookCounterPropagandaEntity);
        return this.bookCounterPropagandaDao.updateByPrimaryKey(bookCounterPropagandaEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterPropagandaDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<BookCounterPropagandaEntity> bookCounterPropagandaEntities = this.bookCounterPropagandaDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cTradeDateTitle = rowTitle.createCell(1);
        cTradeDateTitle.setCellValue("\u4ea4\u6613\u65e5\u671f");
        Cell cRecvManTitle = rowTitle.createCell(2);
        cRecvManTitle.setCellValue("\u88ab\u6536\u5151\u5165\u59d3\u540d");
        Cell cRecvTelTitle = rowTitle.createCell(3);
        cRecvTelTitle.setCellValue("\u88ab\u6536\u5151\u5165\u8054\u7cfb\u7535\u8bdd");
        Cell cDemomTitle = rowTitle.createCell(4);
        cDemomTitle.setCellValue("\u9762\u989d");
        Cell cExcNumTitle = rowTitle.createCell(5);
        cExcNumTitle.setCellValue("\u6570\u91cf");
        Cell cExcManTitle = rowTitle.createCell(6);
        cExcManTitle.setCellValue("\u6536\u5151\u4eba");
        Cell cRemarkTitle = rowTitle.createCell(7);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        int num = 1;
        for (BookCounterPropagandaEntity bookCounterPropagandaEntity : bookCounterPropagandaEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookCounterPropagandaEntity.getOrgId());
            Cell cTradeDate = row.createCell(1);
            cTradeDate.setCellValue(bookCounterPropagandaEntity.getTradeDate());
            Cell cRecvMan = row.createCell(2);
            cRecvMan.setCellValue(bookCounterPropagandaEntity.getRecvMan());
            Cell cRecvTel = row.createCell(3);
            cRecvTel.setCellValue(bookCounterPropagandaEntity.getRecvTel());
            Cell cDemom = row.createCell(4);
            cDemom.setCellValue(bookCounterPropagandaEntity.getDemom());
            Cell cExcNum = row.createCell(5);
            cExcNum.setCellValue(bookCounterPropagandaEntity.getExcNum());
            Cell cExcMan = row.createCell(6);
            cExcMan.setCellValue(bookCounterPropagandaEntity.getExcMan());
            Cell cRemark = row.createCell(7);
            cRemark.setCellValue(bookCounterPropagandaEntity.getRemark());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u5047\u5e01\u7ea0\u7eb7\u5904\u7406\u767b\u8bb0\u7c3f";
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString());
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

