/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookMaintenanceLogBo;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogMonitorDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogPatrolDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogRepairDao;
import cn.com.yusys.yusp.operation.dao.BookMaintenanceLogSecDao;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogMonitorEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogPatrolEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogRepairEntity;
import cn.com.yusys.yusp.operation.domain.entity.BookMaintenanceLogSecEntity;
import cn.com.yusys.yusp.operation.domain.query.BookMaintenanceLogQuery;
import cn.com.yusys.yusp.operation.service.BookMaintenanceLogService;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogMonitorVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogPatrolVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogRepairVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogSecVo;
import cn.com.yusys.yusp.operation.vo.BookMaintenanceLogVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookMaintenanceLogServiceImpl
implements BookMaintenanceLogService {
    private static final Logger logger = LoggerFactory.getLogger(BookMaintenanceLogServiceImpl.class);
    @Autowired
    private BookMaintenanceLogDao bookMaintenanceLogDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean create(IcspRequest<BookMaintenanceLogBo> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        BookMaintenanceLogBo bookMaintenanceLogBo = (BookMaintenanceLogBo)request.getBody();
        try {
            BookMaintenanceLogEntity bookMaintenanceLogEntity = new BookMaintenanceLogEntity();
            BeanUtils.beanCopy((Object)bookMaintenanceLogBo, (Object)bookMaintenanceLogEntity);
            bookMaintenanceLogEntity.setWorkLogId(StringUtils.getUUID());
            bookMaintenanceLogEntity.setWorkLogTime(request.getTradeHead().getWorkDate());
            this.bookMaintenanceLogDao.insert(bookMaintenanceLogEntity);
            List patrolBoList = bookMaintenanceLogBo.getPatrolList();
            patrolBoList.forEach(patrolBo -> {
                BookMaintenanceLogPatrolEntity entity = (BookMaintenanceLogPatrolEntity)BeanUtils.beanCopy((Object)patrolBo, BookMaintenanceLogPatrolEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setPatrolId(StringUtils.getUUID());
                patrolDao.insert(entity);
            });
            List secBoList = bookMaintenanceLogBo.getSecList();
            secBoList.forEach(secBo -> {
                BookMaintenanceLogSecEntity entity = (BookMaintenanceLogSecEntity)BeanUtils.beanCopy((Object)secBo, BookMaintenanceLogSecEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setSecId(StringUtils.getUUID());
                secDao.insert(entity);
            });
            List monitorBoList = bookMaintenanceLogBo.getMonitorList();
            monitorBoList.forEach(monitorBo -> {
                BookMaintenanceLogMonitorEntity entity = (BookMaintenanceLogMonitorEntity)BeanUtils.beanCopy((Object)monitorBo, BookMaintenanceLogMonitorEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setMonitorId(StringUtils.getUUID());
                monitorDao.insert(entity);
            });
            List repairBoList = bookMaintenanceLogBo.getRepairList();
            repairBoList.forEach(repairBo -> {
                BookMaintenanceLogRepairEntity entity = (BookMaintenanceLogRepairEntity)BeanUtils.beanCopy((Object)repairBo, BookMaintenanceLogRepairEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setRepairId(StringUtils.getUUID());
                repairDao.insert(entity);
            });
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public BookMaintenanceLogVo show(BookMaintenanceLogQuery bookMaintenanceLogQuery) throws Exception {
        BookMaintenanceLogVo vo = new BookMaintenanceLogVo();
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        try {
            QueryModel logModel = new QueryModel();
            if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getEndDate())) {
                bookMaintenanceLogQuery.setEndDate("9999-99-99");
            }
            if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getStartDate())) {
                bookMaintenanceLogQuery.setStartDate("0000-00-00");
            }
            logModel.setCondition((Object)bookMaintenanceLogQuery);
            List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(logModel);
            if (list == null || list.size() == 0) {
                throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ workLogId=" + bookMaintenanceLogQuery.getWorkLogId() + " ]");
            }
            BeanUtils.beanCopy((Object)list.get(0), (Object)vo);
            QueryModel monitorModel = new QueryModel();
            BookMaintenanceLogMonitorEntity monitorEntity = new BookMaintenanceLogMonitorEntity();
            monitorEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            monitorModel.setCondition((Object)monitorEntity);
            List<BookMaintenanceLogMonitorEntity> monitorEntities = monitorDao.selectByModel(monitorModel);
            List monitorVos = (List)BeanUtils.beansCopy(monitorEntities, BookMaintenanceLogMonitorVo.class);
            vo.setMonitorList(monitorVos);
            QueryModel secModel = new QueryModel();
            BookMaintenanceLogSecEntity secEntity = new BookMaintenanceLogSecEntity();
            secEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            secModel.setCondition((Object)secEntity);
            List<BookMaintenanceLogSecEntity> secEntities = secDao.selectByModel(secModel);
            List secVos = (List)BeanUtils.beansCopy(secEntities, BookMaintenanceLogSecVo.class);
            vo.setSecList(secVos);
            QueryModel repairModel = new QueryModel();
            BookMaintenanceLogRepairEntity repairEntity = new BookMaintenanceLogRepairEntity();
            repairEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            repairModel.setCondition((Object)repairEntity);
            List<BookMaintenanceLogRepairEntity> repairEntities = repairDao.selectByModel(repairModel);
            List repairVos = repairEntities.size() == 0 ? new ArrayList() : (List)BeanUtils.beansCopy(repairEntities, BookMaintenanceLogRepairVo.class);
            vo.setRepairList(repairVos);
            QueryModel patrolModel = new QueryModel();
            BookMaintenanceLogPatrolEntity patrolEntity = new BookMaintenanceLogPatrolEntity();
            patrolEntity.setWorkLogId(bookMaintenanceLogQuery.getWorkLogId());
            patrolModel.setCondition((Object)patrolEntity);
            List<BookMaintenanceLogPatrolEntity> patrolEntities = patrolDao.selectByModel(patrolModel);
            List patrolVos = patrolEntities.size() == 0 ? new ArrayList() : (List)BeanUtils.beansCopy(patrolEntities, BookMaintenanceLogPatrolVo.class);
            vo.setPatrolList(patrolVos);
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return vo;
    }

    @MyPageAble(returnVo=BookMaintenanceLogVo.class)
    public List index(BookMaintenanceLogQuery bookMaintenanceLogQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getEndDate())) {
            bookMaintenanceLogQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getStartDate())) {
            bookMaintenanceLogQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookMaintenanceLogQuery);
        List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookMaintenanceLogVo> list(QueryModel model) throws Exception {
        List<BookMaintenanceLogEntity> list = this.bookMaintenanceLogDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookMaintenanceLogVo.class);
        return listVo;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean update(BookMaintenanceLogBo bookMaintenanceLogBo) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        try {
            BookMaintenanceLogEntity bookMaintenanceLogEntity = new BookMaintenanceLogEntity();
            BeanUtils.beanCopy((Object)bookMaintenanceLogBo, (Object)bookMaintenanceLogEntity);
            this.bookMaintenanceLogDao.updateByPrimaryKey(bookMaintenanceLogEntity);
            patrolDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List patrolBoList = bookMaintenanceLogBo.getPatrolList();
            patrolBoList.forEach(patrolBo -> {
                BookMaintenanceLogPatrolEntity entity = (BookMaintenanceLogPatrolEntity)BeanUtils.beanCopy((Object)patrolBo, BookMaintenanceLogPatrolEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setPatrolId(StringUtils.getUUID());
                patrolDao.insert(entity);
            });
            secDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List secBoList = bookMaintenanceLogBo.getSecList();
            secBoList.forEach(secBo -> {
                BookMaintenanceLogSecEntity entity = (BookMaintenanceLogSecEntity)BeanUtils.beanCopy((Object)secBo, BookMaintenanceLogSecEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setSecId(StringUtils.getUUID());
                secDao.insert(entity);
            });
            monitorDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List monitorBoList = bookMaintenanceLogBo.getMonitorList();
            monitorBoList.forEach(monitorBo -> {
                BookMaintenanceLogMonitorEntity entity = (BookMaintenanceLogMonitorEntity)BeanUtils.beanCopy((Object)monitorBo, BookMaintenanceLogMonitorEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setMonitorId(StringUtils.getUUID());
                monitorDao.insert(entity);
            });
            repairDao.deleteByWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
            List repairBoList = bookMaintenanceLogBo.getRepairList();
            repairBoList.forEach(repairBo -> {
                BookMaintenanceLogRepairEntity entity = (BookMaintenanceLogRepairEntity)BeanUtils.beanCopy((Object)repairBo, BookMaintenanceLogRepairEntity.class);
                entity.setWorkLogId(bookMaintenanceLogEntity.getWorkLogId());
                entity.setRepairId(StringUtils.getUUID());
                repairDao.insert(entity);
            });
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public boolean delete(String workLogId) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookMaintenanceLogMonitorDao monitorDao = (BookMaintenanceLogMonitorDao)session.getMapper(BookMaintenanceLogMonitorDao.class);
        BookMaintenanceLogSecDao secDao = (BookMaintenanceLogSecDao)session.getMapper(BookMaintenanceLogSecDao.class);
        BookMaintenanceLogRepairDao repairDao = (BookMaintenanceLogRepairDao)session.getMapper(BookMaintenanceLogRepairDao.class);
        BookMaintenanceLogPatrolDao patrolDao = (BookMaintenanceLogPatrolDao)session.getMapper(BookMaintenanceLogPatrolDao.class);
        boolean flag = false;
        try {
            monitorDao.deleteByWorkLogId(workLogId);
            secDao.deleteByWorkLogId(workLogId);
            repairDao.deleteByWorkLogId(workLogId);
            patrolDao.deleteByWorkLogId(workLogId);
            this.bookMaintenanceLogDao.deleteByPrimaryKey(workLogId);
            flag = true;
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return flag;
    }

    @Override
    public void save(BookMaintenanceLogQuery bookMaintenanceLogQuery, int page, int size, HttpServletResponse response) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getEndDate())) {
            bookMaintenanceLogQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookMaintenanceLogQuery.getStartDate())) {
            bookMaintenanceLogQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookMaintenanceLogQuery);
        List<BookMaintenanceLogEntity> bookMaintenanceLogEntities = this.bookMaintenanceLogDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cWorkLogTimeTitle = rowTitle.createCell(1);
        cWorkLogTimeTitle.setCellValue("\u5de1\u67e5\u65e5\u671f");
        Cell cDevIdTitle = rowTitle.createCell(2);
        cDevIdTitle.setCellValue("\u81ea\u52a9\u8bbe\u5907\u7f16\u53f7");
        Cell cPatrolNameTitle = rowTitle.createCell(3);
        cPatrolNameTitle.setCellValue("\u5de1\u67e5\u4eba\u5458\uff08\u7b7e\u7ae0\uff09");
        Cell cApprNameTitle = rowTitle.createCell(4);
        cApprNameTitle.setCellValue("\u5ba1\u6279\u4eba");
        Cell cRemarkTitle = rowTitle.createCell(5);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        int num = 1;
        for (BookMaintenanceLogEntity bookMaintenanceLogEntity : bookMaintenanceLogEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookMaintenanceLogEntity.getOrgId());
            Cell cWorkLogTime = row.createCell(1);
            cWorkLogTime.setCellValue(bookMaintenanceLogEntity.getWorkLogTime());
            Cell cDevId = row.createCell(2);
            cDevId.setCellValue(bookMaintenanceLogEntity.getDevId());
            Cell cPatrolName = row.createCell(3);
            cPatrolName.setCellValue(bookMaintenanceLogEntity.getPatrolName());
            Cell cApprName = row.createCell(4);
            cApprName.setCellValue(bookMaintenanceLogEntity.getApprName());
            Cell cRemark = row.createCell(5);
            cRemark.setCellValue(bookMaintenanceLogEntity.getRemark());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u81ea\u52a9\u8bbe\u5907\u5de5\u4f5c\u65e5\u5fd7.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

