/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterfeitSafekeepBo;
import cn.com.yusys.yusp.operation.dao.BookCounterfeitSafekeepDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterfeitSafekeepEntity;
import cn.com.yusys.yusp.operation.domain.query.BookCounterfeitSafekeepQuery;
import cn.com.yusys.yusp.operation.service.BookCounterfeitSafekeepService;
import cn.com.yusys.yusp.operation.vo.BookCounterfeitSafekeepVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterfeitSafekeepServiceImpl
implements BookCounterfeitSafekeepService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterfeitSafekeepServiceImpl.class);
    @Autowired
    private BookCounterfeitSafekeepDao bookCounterfeitSafekeepDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookCounterfeitSafekeepBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookCounterfeitSafekeepDao bookCounterfeitSafekeepDao = (BookCounterfeitSafekeepDao)session.getMapper(BookCounterfeitSafekeepDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookCounterfeitSafekeepBo -> {
                BookCounterfeitSafekeepEntity entity = (BookCounterfeitSafekeepEntity)BeanUtils.beanCopy((Object)bookCounterfeitSafekeepBo, BookCounterfeitSafekeepEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookCounterfeitSafekeepDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookCounterfeitSafekeepVo show(BookCounterfeitSafekeepQuery bookCounterfeitSafekeepQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterfeitSafekeepQuery);
        List<BookCounterfeitSafekeepEntity> entities = this.bookCounterfeitSafekeepDao.selectByModel(model);
        List list = (List)BeanUtils.beansCopy(entities, BookCounterfeitSafekeepVo.class);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterfeitSafekeepQuery.getTradeId() + " ]");
        }
        return (BookCounterfeitSafekeepVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCounterfeitSafekeepVo.class)
    public List index(BookCounterfeitSafekeepQuery bookCounterfeitSafekeepQuery, int page, int size) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getEndDate())) {
            bookCounterfeitSafekeepQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getStartDate())) {
            bookCounterfeitSafekeepQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookCounterfeitSafekeepQuery);
        List<BookCounterfeitSafekeepEntity> list = this.bookCounterfeitSafekeepDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterfeitSafekeepVo> list(QueryModel model) throws Exception {
        List<BookCounterfeitSafekeepEntity> list = this.bookCounterfeitSafekeepDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterfeitSafekeepVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterfeitSafekeepBo bookCounterfeitSafekeepBo) throws Exception {
        BookCounterfeitSafekeepEntity bookCounterfeitSafekeepEntity = new BookCounterfeitSafekeepEntity();
        BeanUtils.beanCopy((Object)bookCounterfeitSafekeepBo, (Object)bookCounterfeitSafekeepEntity);
        return this.bookCounterfeitSafekeepDao.updateByPrimaryKey(bookCounterfeitSafekeepEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterfeitSafekeepDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(BookCounterfeitSafekeepQuery bookCounterfeitSafekeepQuery, int page, int size, HttpServletResponse response) throws Exception {
        QueryModel model = new QueryModel();
        model.setPage(page);
        model.setSize(size);
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getEndDate())) {
            bookCounterfeitSafekeepQuery.setEndDate("99999999");
        }
        if (StringUtils.isEmpty((CharSequence)bookCounterfeitSafekeepQuery.getStartDate())) {
            bookCounterfeitSafekeepQuery.setStartDate("00000000");
        }
        model.setCondition((Object)bookCounterfeitSafekeepQuery);
        List<BookCounterfeitSafekeepEntity> bookCounterfeitSafekeepEntities = this.bookCounterfeitSafekeepDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cTradeDateTitle = rowTitle.createCell(1);
        cTradeDateTitle.setCellValue("\u4ea4\u6613\u65e5\u671f");
        Cell cSummaryTitle = rowTitle.createCell(2);
        cSummaryTitle.setCellValue("\u6458\u8981");
        Cell cHandleTypeTitle = rowTitle.createCell(3);
        cHandleTypeTitle.setCellValue("\u6536\u5165/\u4e0a\u7f34");
        Cell cDemomTitle = rowTitle.createCell(4);
        cDemomTitle.setCellValue("\u9762\u989d");
        Cell cCouponTypeTitle = rowTitle.createCell(5);
        cCouponTypeTitle.setCellValue("\u5238\u522b");
        Cell cVersionTypeTitle = rowTitle.createCell(6);
        cVersionTypeTitle.setCellValue("\u7248\u522b");
        Cell cCounterfeitNumTitle = rowTitle.createCell(7);
        cCounterfeitNumTitle.setCellValue("\u5f20\uff08\u679a\uff09\u6570");
        Cell cAmtTitle = rowTitle.createCell(8);
        cAmtTitle.setCellValue("\u91d1\u989d");
        Cell cCrownNumTitle = rowTitle.createCell(9);
        cCrownNumTitle.setCellValue("\u51a0\u5b57\u53f7\u7801");
        Cell cFeatureTitle = rowTitle.createCell(10);
        cFeatureTitle.setCellValue("\u7279\u5f81");
        Cell cDiscPrcsTitle = rowTitle.createCell(11);
        cDiscPrcsTitle.setCellValue("\u53d1\u73b0\u7ecf\u8fc7");
        Cell cOperatorTitle = rowTitle.createCell(12);
        cOperatorTitle.setCellValue("\u7ecf\u529e\u4eba\u7b7e\u7ae0");
        Cell cSkerTitle = rowTitle.createCell(13);
        cSkerTitle.setCellValue("\u4ee3\u4fdd\u7ba1\u4eba\u7b7e\u7ae0");
        Cell cBalDwnTitle = rowTitle.createCell(14);
        cBalDwnTitle.setCellValue("\u7ed3\u5b58\u4f59\u989d");
        Cell cRemarkTitle = rowTitle.createCell(15);
        cRemarkTitle.setCellValue("\u5907\u6ce8");
        int num = 1;
        for (BookCounterfeitSafekeepEntity bookCounterfeitSafekeepEntity : bookCounterfeitSafekeepEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookCounterfeitSafekeepEntity.getOrgId());
            Cell cTradeDate = row.createCell(1);
            cTradeDate.setCellValue(bookCounterfeitSafekeepEntity.getTradeDate());
            Cell cSummary = row.createCell(2);
            cSummary.setCellValue(bookCounterfeitSafekeepEntity.getSummary());
            Cell cHandleType = row.createCell(3);
            cHandleType.setCellValue(bookCounterfeitSafekeepEntity.getHandleType());
            Cell cDemom = row.createCell(4);
            cDemom.setCellValue(bookCounterfeitSafekeepEntity.getDemom());
            Cell cCouponType = row.createCell(5);
            cCouponType.setCellValue(bookCounterfeitSafekeepEntity.getCouponType());
            Cell cVersionType = row.createCell(6);
            cVersionType.setCellValue(bookCounterfeitSafekeepEntity.getVersionType());
            Cell cCounterfeitNum = row.createCell(7);
            cCounterfeitNum.setCellValue(bookCounterfeitSafekeepEntity.getCounterfeitNum());
            Cell cAmt = row.createCell(8);
            cAmt.setCellValue(bookCounterfeitSafekeepEntity.getAmt());
            Cell cCrownNum = row.createCell(9);
            cCrownNum.setCellValue(bookCounterfeitSafekeepEntity.getCrownNum());
            Cell cFeature = row.createCell(10);
            cFeature.setCellValue(bookCounterfeitSafekeepEntity.getFeature());
            Cell cDiscPrcs = row.createCell(11);
            cDiscPrcs.setCellValue(bookCounterfeitSafekeepEntity.getDiscPrcs());
            Cell cOperator = row.createCell(12);
            cOperator.setCellValue(bookCounterfeitSafekeepEntity.getOperator());
            Cell cSker = row.createCell(13);
            cSker.setCellValue(bookCounterfeitSafekeepEntity.getSker());
            Cell cBalDwn = row.createCell(14);
            cBalDwn.setCellValue(bookCounterfeitSafekeepEntity.getBalDwn());
            Cell cRemark = row.createCell(15);
            cRemark.setCellValue(bookCounterfeitSafekeepEntity.getRemark());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u6cc9\u5dde\u94f6\u884cXX\u652f\u884c\u5047\u5e01\u7ea0\u7eb7\u5904\u7406\u767b\u8bb0\u7c3f";
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString());
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

