/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookLengthFundBo;
import cn.com.yusys.yusp.operation.dao.BookLengthFundDao;
import cn.com.yusys.yusp.operation.domain.entity.BookLengthFundEntity;
import cn.com.yusys.yusp.operation.domain.query.BookLengthFundQuery;
import cn.com.yusys.yusp.operation.service.BookLengthFundService;
import cn.com.yusys.yusp.operation.vo.BookLengthFundVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookLengthFundServiceImpl
implements BookLengthFundService {
    private static final Logger logger = LoggerFactory.getLogger(BookLengthFundServiceImpl.class);
    @Autowired
    private BookLengthFundDao bookLengthFundDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookLengthFundBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookLengthFundDao bookLengthFundDao = (BookLengthFundDao)session.getMapper(BookLengthFundDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookLengthFundBo -> {
                BookLengthFundEntity entity = (BookLengthFundEntity)BeanUtils.beanCopy((Object)bookLengthFundBo, BookLengthFundEntity.class);
                entity.setTradeId(StringUtils.getUUID());
                entity.setDutyMan(request.getTradeHead().getUserId());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookLengthFundDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookLengthFundVo show(BookLengthFundQuery bookLengthFundQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookLengthFundQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookLengthFundQuery.getTradeId() + " ]");
        }
        return (BookLengthFundVo)list.get(0);
    }

    @MyPageAble(returnVo=BookLengthFundVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookLengthFundVo> list(QueryModel model) throws Exception {
        List<BookLengthFundEntity> list = this.bookLengthFundDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookLengthFundVo.class);
        return listVo;
    }

    @Override
    public int update(BookLengthFundBo bookLengthFundBo) throws Exception {
        BookLengthFundEntity bookLengthFundEntity = new BookLengthFundEntity();
        BeanUtils.beanCopy((Object)bookLengthFundBo, (Object)bookLengthFundEntity);
        return this.bookLengthFundDao.updateByPrimaryKey(bookLengthFundEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookLengthFundDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<BookLengthFundEntity> bookLengthFundEntities = this.bookLengthFundDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cTradeDateTitle = rowTitle.createCell(1);
        cTradeDateTitle.setCellValue("\u4ea4\u6613\u65e5\u671f");
        Cell cTypeTitle = rowTitle.createCell(2);
        cTypeTitle.setCellValue("\u5bf9\u516c/\u5bf9\u79c1");
        Cell cCustNameTitle = rowTitle.createCell(3);
        cCustNameTitle.setCellValue("\u5ba2\u6237\u540d\u79f0");
        Cell cAccountNAumTitle = rowTitle.createCell(4);
        cAccountNAumTitle.setCellValue("\u8d26\u53f7");
        Cell cTradeTypeTitle = rowTitle.createCell(5);
        cTradeTypeTitle.setCellValue("\u767b\u8bb0\u7c7b\u578b(1-\u957f\u6b3e;2-\u77ed\u6b3e)");
        Cell cWrongAmtTitle = rowTitle.createCell(6);
        cWrongAmtTitle.setCellValue("\u5dee\u9519\u91d1\u989d");
        Cell cDutyManTitle = rowTitle.createCell(7);
        cDutyManTitle.setCellValue("\u8d23\u4efb\u4eba");
        Cell cPrcsSuggestionTitle = rowTitle.createCell(8);
        cPrcsSuggestionTitle.setCellValue("\u5904\u7406\u610f\u89c1");
        Cell cAfterwardsSupervisorTitle = rowTitle.createCell(9);
        cAfterwardsSupervisorTitle.setCellValue("\u4e8b\u540e\u76d1\u7763");
        Cell cCustSignTitle = rowTitle.createCell(10);
        cCustSignTitle.setCellValue("\u5ba2\u6237\u7b7e\u5b57");
        Cell cCustMobilephoneTitle = rowTitle.createCell(11);
        cCustMobilephoneTitle.setCellValue("\u5ba2\u6237\u8054\u7cfb\u65b9\u5f0f");
        Cell cStsTitle = rowTitle.createCell(12);
        cStsTitle.setCellValue("\u72b6\u6001");
        int num = 1;
        for (BookLengthFundEntity bookLengthFundEntity : bookLengthFundEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookLengthFundEntity.getOrgId());
            Cell cTradeDate = row.createCell(1);
            cTradeDate.setCellValue(bookLengthFundEntity.getTradeDate());
            Cell cType = row.createCell(2);
            cType.setCellValue(bookLengthFundEntity.getType());
            Cell cCustName = row.createCell(3);
            cCustName.setCellValue(bookLengthFundEntity.getCustName());
            Cell cAccountNAum = row.createCell(4);
            cAccountNAum.setCellValue(bookLengthFundEntity.getAccountNum());
            Cell cTradeType = row.createCell(5);
            cTradeType.setCellValue(bookLengthFundEntity.getTradeType());
            Cell cWrongAmt = row.createCell(6);
            cWrongAmt.setCellValue(bookLengthFundEntity.getWrongAmt());
            Cell cDutyMan = row.createCell(7);
            cDutyMan.setCellValue(bookLengthFundEntity.getDutyMan());
            Cell cPrcsSuggestion = row.createCell(8);
            cPrcsSuggestion.setCellValue(bookLengthFundEntity.getPrcsSuggestion());
            Cell cAfterwardsSupervisor = row.createCell(9);
            cAfterwardsSupervisor.setCellValue(bookLengthFundEntity.getAfterwardsSupervisor());
            Cell cCustSign = row.createCell(10);
            cCustSign.setCellValue(bookLengthFundEntity.getCustSign());
            Cell cCustMobilephone = row.createCell(11);
            cCustMobilephone.setCellValue(bookLengthFundEntity.getCustMobilephone());
            Cell cSts = row.createCell(12);
            cSts.setCellValue(bookLengthFundEntity.getSts());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        String fileName = "\u957f\u77ed\u6b3e.xls";
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

