/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.operation.service.impl;

import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.operation.bo.BookCounterfeitMoneyDisputeBo;
import cn.com.yusys.yusp.operation.dao.BookCounterfeitMoneyDisputeDao;
import cn.com.yusys.yusp.operation.domain.entity.BookCounterfeitMoneyDisputeEntity;
import cn.com.yusys.yusp.operation.domain.query.BookCounterfeitMoneyDisputeQuery;
import cn.com.yusys.yusp.operation.service.BookCounterfeitMoneyDisputeService;
import cn.com.yusys.yusp.operation.vo.BookCounterfeitMoneyDisputeVo;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BookCounterfeitMoneyDisputeServiceImpl
implements BookCounterfeitMoneyDisputeService {
    private static final Logger logger = LoggerFactory.getLogger(BookCounterfeitMoneyDisputeServiceImpl.class);
    @Autowired
    private BookCounterfeitMoneyDisputeDao bookCounterfeitMoneyDisputeDao;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int create(IcspRequest<List<BookCounterfeitMoneyDisputeBo>> request) throws Exception {
        SqlSession session = this.sqlSessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        BookCounterfeitMoneyDisputeDao bookCounterfeitMoneyDisputeDao = (BookCounterfeitMoneyDisputeDao)session.getMapper(BookCounterfeitMoneyDisputeDao.class);
        List list = (List)request.getBody();
        int num = 0;
        try {
            list.forEach(bookCounterfeitMoneyDisputeBo -> {
                BookCounterfeitMoneyDisputeEntity entity = (BookCounterfeitMoneyDisputeEntity)BeanUtils.beanCopy((Object)bookCounterfeitMoneyDisputeBo, BookCounterfeitMoneyDisputeEntity.class);
                entity.setBookId(StringUtils.getUUID());
                entity.setTradeDate(request.getTradeHead().getWorkDate());
                bookCounterfeitMoneyDisputeDao.insert(entity);
            });
            session.flushStatements();
        }
        catch (Exception e) {
            logger.error("\u903b\u8f91\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
            throw e;
        }
        return num;
    }

    @Override
    public BookCounterfeitMoneyDisputeVo show(BookCounterfeitMoneyDisputeQuery bookCounterfeitMoneyDisputeQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)bookCounterfeitMoneyDisputeQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ tradeId=" + bookCounterfeitMoneyDisputeQuery.getTradeId() + " ]");
        }
        return (BookCounterfeitMoneyDisputeVo)list.get(0);
    }

    @MyPageAble(returnVo=BookCounterfeitMoneyDisputeVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BookCounterfeitMoneyDisputeEntity> list = this.bookCounterfeitMoneyDisputeDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<BookCounterfeitMoneyDisputeVo> list(QueryModel model) throws Exception {
        List<BookCounterfeitMoneyDisputeEntity> list = this.bookCounterfeitMoneyDisputeDao.selectByModel(model);
        List listVo = (List)BeanUtils.beansCopy(list, BookCounterfeitMoneyDisputeVo.class);
        return listVo;
    }

    @Override
    public int update(BookCounterfeitMoneyDisputeBo bookCounterfeitMoneyDisputeBo) throws Exception {
        BookCounterfeitMoneyDisputeEntity bookCounterfeitMoneyDisputeEntity = new BookCounterfeitMoneyDisputeEntity();
        BeanUtils.beanCopy((Object)bookCounterfeitMoneyDisputeBo, (Object)bookCounterfeitMoneyDisputeEntity);
        return this.bookCounterfeitMoneyDisputeDao.updateByPrimaryKey(bookCounterfeitMoneyDisputeEntity);
    }

    @Override
    public int delete(String tradeId) throws Exception {
        return this.bookCounterfeitMoneyDisputeDao.deleteByPrimaryKey(tradeId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<BookCounterfeitMoneyDisputeEntity> bookCounterfeitMoneyDisputeEntities = this.bookCounterfeitMoneyDisputeDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cTradeDateTitle = rowTitle.createCell(1);
        cTradeDateTitle.setCellValue("\u4ea4\u6613\u65e5\u671f");
        Cell cHolderTitle = rowTitle.createCell(2);
        cHolderTitle.setCellValue("\u6301\u6709\u4eba");
        Cell cIdTypeTitle = rowTitle.createCell(3);
        cIdTypeTitle.setCellValue("\u8bc1\u4ef6\u7c7b\u578b");
        Cell cIdNumTitle = rowTitle.createCell(4);
        cIdNumTitle.setCellValue("\u8bc1\u4ef6\u53f7\u7801");
        Cell cProveStuffTitle = rowTitle.createCell(5);
        cProveStuffTitle.setCellValue("\u8bc1\u660e\u6750\u6599");
        Cell cCrownNumTitle = rowTitle.createCell(6);
        cCrownNumTitle.setCellValue("\u51a0\u5b57\u53f7\u7801");
        Cell cAuthRsltTitle = rowTitle.createCell(7);
        cAuthRsltTitle.setCellValue("\u9274\u5b9a\u7ed3\u679c");
        Cell cPrcsRsltTitle = rowTitle.createCell(8);
        cPrcsRsltTitle.setCellValue("\u5904\u7406\u65b9\u5f0f");
        int num = 1;
        for (BookCounterfeitMoneyDisputeEntity bookCounterfeitMoneyDisputeEntity : bookCounterfeitMoneyDisputeEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(bookCounterfeitMoneyDisputeEntity.getOrgId());
            Cell cTradeDate = row.createCell(1);
            cTradeDate.setCellValue(bookCounterfeitMoneyDisputeEntity.getTradeDate());
            Cell cHolder = row.createCell(2);
            cHolder.setCellValue(bookCounterfeitMoneyDisputeEntity.getHolder());
            Cell cIdType = row.createCell(3);
            cIdType.setCellValue(bookCounterfeitMoneyDisputeEntity.getIdType());
            Cell cIdNum = row.createCell(4);
            cIdNum.setCellValue(bookCounterfeitMoneyDisputeEntity.getIdNum());
            Cell cProveStuff = row.createCell(5);
            cProveStuff.setCellValue(bookCounterfeitMoneyDisputeEntity.getProveStuff());
            Cell cCrownNum = row.createCell(6);
            cCrownNum.setCellValue(bookCounterfeitMoneyDisputeEntity.getCrownNum());
            Cell cAuthRslt = row.createCell(7);
            cAuthRslt.setCellValue(bookCounterfeitMoneyDisputeEntity.getAuthRslt());
            Cell cPrcsRslt = row.createCell(8);
            cPrcsRslt.setCellValue(bookCounterfeitMoneyDisputeEntity.getPrcsRslt());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"BookCounterfeitMoneyDispute_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

