/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.auth.service.Impl;

import cn.com.yusys.yusp.auth.bo.AuthParamOrgSwitchBo;
import cn.com.yusys.yusp.auth.dao.AuthParamOrgSwitchDao;
import cn.com.yusys.yusp.auth.domain.dto.OrgSwitchDto;
import cn.com.yusys.yusp.auth.domain.entity.AuthParamOrgSwitchEntity;
import cn.com.yusys.yusp.auth.service.AuthParamOrgSwitchService;
import cn.com.yusys.yusp.auth.vo.AuthParamOrgSwitchVo;
import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AuthParamOrgSwitchServiceImpl
implements AuthParamOrgSwitchService {
    private static final Logger logger = LoggerFactory.getLogger(AuthParamOrgSwitchServiceImpl.class);
    @Autowired
    private AuthParamOrgSwitchDao authParamOrgSwitchDao;

    @Override
    public int create(AuthParamOrgSwitchBo authParamOrgSwitchBo) throws Exception {
        QueryModel model = new QueryModel();
        AuthParamOrgSwitchEntity entity = new AuthParamOrgSwitchEntity();
        entity.setOrgId(authParamOrgSwitchBo.getOrgId());
        model.setCondition((Object)entity);
        List<OrgSwitchDto> dtoList = this.authParamOrgSwitchDao.selectByModel(model);
        if (dtoList.size() == 1) {
            throw new IcspException("500", "\u8be5\u673a\u6784\u5df2\u914d\u7f6e");
        }
        BeanUtils.beanCopy((Object)authParamOrgSwitchBo, (Object)entity);
        entity.setParamId(StringUtils.getUUID());
        entity.setLastChgUser(SessionUtils.getUserId());
        entity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamOrgSwitchDao.insert(entity);
    }

    @Override
    public OrgSwitchDto show(String orgId) throws Exception {
        OrgSwitchDto orgSwitchDto = this.authParamOrgSwitchDao.show(orgId);
        if (orgSwitchDto == null) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] orgId=" + orgId + " ]");
        }
        return orgSwitchDto;
    }

    @MyPageAble(returnVo=OrgSwitchDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<OrgSwitchDto> list = this.authParamOrgSwitchDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<AuthParamOrgSwitchVo> list(QueryModel model) throws Exception {
        List<OrgSwitchDto> list = this.authParamOrgSwitchDao.selectByModel(model);
        List authParamOrgSwitchVos = (List)BeanUtils.beansCopy(list, AuthParamOrgSwitchVo.class);
        return authParamOrgSwitchVos;
    }

    @Override
    public int update(AuthParamOrgSwitchBo authParamOrgSwitchBo) throws Exception {
        AuthParamOrgSwitchEntity authParamOrgSwitchEntity = new AuthParamOrgSwitchEntity();
        if ("0000".equals(authParamOrgSwitchBo.getOrgId())) {
            QueryModel model = new QueryModel();
            authParamOrgSwitchEntity.setOrgId("0000");
            model.setCondition((Object)authParamOrgSwitchEntity);
            List<AuthParamOrgSwitchEntity> authParamOrgSwitchEntities = this.authParamOrgSwitchDao.selectAll(model);
            if (authParamOrgSwitchEntities.size() == 0) {
                authParamOrgSwitchEntity.setAuthType(authParamOrgSwitchBo.getAuthType());
                authParamOrgSwitchEntity.setParamId(StringUtils.getUUID());
                authParamOrgSwitchEntity.setLastChgUser(SessionUtils.getUserId());
                authParamOrgSwitchEntity.setLastChgDt(DateUtils.formatDateByDef());
                return this.authParamOrgSwitchDao.insert(authParamOrgSwitchEntity);
            }
            authParamOrgSwitchEntity.setParamId(authParamOrgSwitchEntities.get(0).getParamId());
            authParamOrgSwitchEntity.setAuthType(authParamOrgSwitchBo.getAuthType());
            authParamOrgSwitchEntity.setLastChgUser(SessionUtils.getUserId());
            authParamOrgSwitchEntity.setLastChgDt(DateUtils.formatDateByDef());
            return this.authParamOrgSwitchDao.updateByPrimaryKey(authParamOrgSwitchEntity);
        }
        BeanUtils.beanCopy((Object)authParamOrgSwitchBo, (Object)authParamOrgSwitchEntity);
        authParamOrgSwitchEntity.setLastChgUser(SessionUtils.getUserId());
        authParamOrgSwitchEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamOrgSwitchDao.updateByPrimaryKey(authParamOrgSwitchEntity);
    }

    @Override
    public int delete(String paramId) throws Exception {
        return this.authParamOrgSwitchDao.deleteByPrimaryKey(paramId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<OrgSwitchDto> orgSwitchDtoList = this.authParamOrgSwitchDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cOrgNameTitle = rowTitle.createCell(1);
        cOrgNameTitle.setCellValue("\u673a\u6784\u540d");
        Cell cAuthTypeTitle = rowTitle.createCell(2);
        cAuthTypeTitle.setCellValue("\u6388\u6743\u7c7b\u578b(1-\u672c\u5730\u6388\u6743\uff0c3-\u96c6\u4e2d\u6388\u6743)");
        int num = 1;
        for (OrgSwitchDto orgSwitchDto : orgSwitchDtoList) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(orgSwitchDto.getOrgId());
            Cell cOrgName = row.createCell(1);
            cOrgName.setCellValue(orgSwitchDto.getOrgName());
            Cell cAuthType = row.createCell(2);
            if ("3".equals(orgSwitchDto.getAuthType())) {
                cAuthType.setCellValue("\u96c6\u4e2d\u6388\u6743");
                continue;
            }
            if (!"1".equals(orgSwitchDto.getAuthType())) continue;
            cAuthType.setCellValue("\u672c\u5730\u6388\u6743");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"OrgSwitch_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @Override
    public void upload(MultipartFile file) throws Exception {
        String sheetName = "Sheet0";
        FileInputStream fileInputStream = (FileInputStream)file.getInputStream();
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fileInputStream);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        ArrayList<AuthParamOrgSwitchEntity> entities = new ArrayList<AuthParamOrgSwitchEntity>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            AuthParamOrgSwitchEntity entity = new AuthParamOrgSwitchEntity();
            entity.setOrgId(sheet.getRow(i).getCell(0).toString());
            QueryModel model = new QueryModel();
            model.setCondition((Object)entity);
            List<OrgSwitchDto> dtoList = this.authParamOrgSwitchDao.selectByModel(model);
            String authType = "";
            logger.info(sheet.getRow(i).getCell(2).toString());
            if ("\u96c6\u4e2d\u6388\u6743".equals(sheet.getRow(i).getCell(2).toString())) {
                authType = "3";
            } else if ("\u672c\u5730\u6388\u6743".equals(sheet.getRow(i).getCell(2).toString())) {
                authType = "1";
            }
            if (dtoList.size() == 1) {
                entity.setAuthType(authType);
                entity.setParamId(dtoList.get(0).getParamId());
                this.authParamOrgSwitchDao.updateByPrimaryKey(entity);
                continue;
            }
            entity.setAuthType(authType);
            entity.setParamId(StringUtils.getUUID());
            entity.setLastChgUser(SessionUtils.getUserId());
            entity.setLastChgDt(DateUtils.formatDateByDef());
            entities.add(entity);
        }
        int count = 0;
        for (AuthParamOrgSwitchEntity entity : entities) {
            this.authParamOrgSwitchDao.insert(entity);
            ++count;
        }
    }
}

