/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.auth.service.Impl;

import cn.com.yusys.yusp.auth.bo.AuthParamLoseBookBo;
import cn.com.yusys.yusp.auth.dao.AuthParamLoseBookDao;
import cn.com.yusys.yusp.auth.domain.entity.AuthParamLoseBookEntity;
import cn.com.yusys.yusp.auth.domain.query.AuthParamLoseBookQuery;
import cn.com.yusys.yusp.auth.service.AuthParamLoseBookService;
import cn.com.yusys.yusp.auth.vo.AuthParamLoseBookVo;
import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthParamLoseBookServiceImpl
implements AuthParamLoseBookService {
    @Autowired
    private AuthParamLoseBookDao authParamLoseBookDao;

    @Override
    public int create(AuthParamLoseBookBo authParamLoseBookBo) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamLoseBookBo);
        List<AuthParamLoseBookEntity> authParamLoseBookEntities = this.authParamLoseBookDao.selectByModel(model);
        if (authParamLoseBookEntities.size() != 0) {
            throw new IcspException("500", "\u8be5\u8bb0\u5f55\u5df2\u5b58\u5728");
        }
        AuthParamLoseBookEntity authParamLoseBookEntity = new AuthParamLoseBookEntity();
        BeanUtils.beanCopy((Object)authParamLoseBookBo, (Object)authParamLoseBookEntity);
        authParamLoseBookEntity.setParamId(StringUtils.getUUID());
        authParamLoseBookEntity.setLastChgUser(SessionUtils.getUserId());
        authParamLoseBookEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamLoseBookDao.insert(authParamLoseBookEntity);
    }

    @Override
    public AuthParamLoseBookVo show(AuthParamLoseBookQuery authParamLoseBookQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamLoseBookQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + authParamLoseBookQuery.getParamId() + " ]");
        }
        return (AuthParamLoseBookVo)list.get(0);
    }

    @MyPageAble(returnVo=AuthParamLoseBookVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<AuthParamLoseBookEntity> list = this.authParamLoseBookDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<AuthParamLoseBookVo> list(QueryModel model) throws Exception {
        List<AuthParamLoseBookEntity> list = this.authParamLoseBookDao.selectByModel(model);
        List authParamLoseBookVos = (List)BeanUtils.beansCopy(list, AuthParamLoseBookVo.class);
        return authParamLoseBookVos;
    }

    @Override
    public int update(AuthParamLoseBookBo authParamLoseBook) throws Exception {
        AuthParamLoseBookEntity authParamLoseBookEntity = new AuthParamLoseBookEntity();
        BeanUtils.beanCopy((Object)authParamLoseBook, (Object)authParamLoseBookEntity);
        authParamLoseBookEntity.setLastChgUser(SessionUtils.getUserId());
        authParamLoseBookEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamLoseBookDao.updateByPrimaryKey(authParamLoseBookEntity);
    }

    @Override
    public int delete(String paramId) throws Exception {
        return this.authParamLoseBookDao.deleteByPrimaryKey(paramId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<AuthParamLoseBookEntity> paramLoseBookEntities = this.authParamLoseBookDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cMenuCodeTitle = rowTitle.createCell(0);
        cMenuCodeTitle.setCellValue("\u4ea4\u6613\u4ee3\u7801");
        Cell cBookTypeTitle = rowTitle.createCell(1);
        cBookTypeTitle.setCellValue("\u8d44\u6599\u7c7b\u578b");
        Cell cBookNameTitle = rowTitle.createCell(2);
        cBookNameTitle.setCellValue("\u8d44\u6599\u540d\u79f0");
        Cell cOrderNumTitle = rowTitle.createCell(3);
        cOrderNumTitle.setCellValue("\u6392\u5e8f");
        int num = 1;
        for (AuthParamLoseBookEntity paramLoseBookEntity : paramLoseBookEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cMenuCode = row.createCell(0);
            cMenuCode.setCellValue(paramLoseBookEntity.getMenuCode());
            Cell cBookType = row.createCell(1);
            cBookType.setCellValue(paramLoseBookEntity.getBookType());
            Cell cBook = row.createCell(2);
            cBook.setCellValue(paramLoseBookEntity.getBook());
            Cell cOrderNum = row.createCell(3);
            cOrderNum.setCellValue((double)paramLoseBookEntity.getOrderNum().intValue());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"LoseBook_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

