/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.auth.service.Impl;

import cn.com.yusys.yusp.auth.bo.AuthParamConfigBo;
import cn.com.yusys.yusp.auth.dao.AuthParamConfigDao;
import cn.com.yusys.yusp.auth.domain.entity.AuthParamConfigEntity;
import cn.com.yusys.yusp.auth.domain.query.AuthParamConfigQuery;
import cn.com.yusys.yusp.auth.service.AuthParamConfigService;
import cn.com.yusys.yusp.auth.vo.AuthParamConfigVo;
import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthParamConfigServiceImpl
implements AuthParamConfigService {
    @Autowired
    private AuthParamConfigDao authParamConfigDao;

    @Override
    public int create(AuthParamConfigBo authParamConfigBo) throws Exception {
        AuthParamConfigEntity authParamConfigEntity = new AuthParamConfigEntity();
        BeanUtils.beanCopy((Object)authParamConfigBo, (Object)authParamConfigEntity);
        authParamConfigEntity.setParamId(StringUtils.getUUID());
        authParamConfigEntity.setLastChgUser(SessionUtils.getUserId());
        authParamConfigEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamConfigDao.insert(authParamConfigEntity);
    }

    @Override
    public AuthParamConfigVo show(AuthParamConfigQuery authParamConfigQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamConfigQuery);
        List list = this.index(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + authParamConfigQuery.getParamId() + " ]");
        }
        return (AuthParamConfigVo)list.get(0);
    }

    @MyPageAble(returnVo=AuthParamConfigVo.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<AuthParamConfigEntity> list = this.authParamConfigDao.selectByModel(model);
        PageHelper.clearPage();
        return list;
    }

    @Override
    public List<AuthParamConfigVo> list(QueryModel model) throws Exception {
        List<AuthParamConfigEntity> list = this.authParamConfigDao.selectByModel(model);
        List authParamConfigVos = (List)BeanUtils.beansCopy(list, AuthParamConfigVo.class);
        return authParamConfigVos;
    }

    @Override
    public int update(AuthParamConfigBo authParamConfigBo) throws Exception {
        AuthParamConfigEntity authParamConfigEntity = new AuthParamConfigEntity();
        BeanUtils.beanCopy((Object)authParamConfigBo, (Object)authParamConfigEntity);
        authParamConfigEntity.setLastChgUser(SessionUtils.getUserId());
        authParamConfigEntity.setLastChgDt(DateUtils.formatDateByDef());
        return this.authParamConfigDao.updateByPrimaryKey(authParamConfigEntity);
    }

    @Override
    public int delete(String paramId) throws Exception {
        return this.authParamConfigDao.deleteByPrimaryKey(paramId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<AuthParamConfigEntity> paramConfigEntities = this.authParamConfigDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cMenuCodeTitle = rowTitle.createCell(0);
        cMenuCodeTitle.setCellValue("\u9002\u7528\u4ea4\u6613");
        Cell cBookTypeTitle = rowTitle.createCell(1);
        cBookTypeTitle.setCellValue("\u4e1a\u52a1\u7c7b\u578b");
        Cell cBackFlagTitle = rowTitle.createCell(2);
        cBackFlagTitle.setCellValue("\u662f\u5426\u56de\u9000");
        int num = 1;
        for (AuthParamConfigEntity paramConfigEntity : paramConfigEntities) {
            HSSFRow row = sheet.createRow(num++);
            Cell cMenuCode = row.createCell(0);
            cMenuCode.setCellValue(paramConfigEntity.getMenuCode());
            Cell cParamCode = row.createCell(1);
            if ("1".equals(paramConfigEntity.getParamCode())) {
                cParamCode.setCellValue("\u73b0\u91d1\u4e1a\u52a1");
            } else if ("2".equals(paramConfigEntity.getParamCode())) {
                cParamCode.setCellValue("\u975e\u73b0\u91d1\u4e1a\u52a1");
            } else if ("3".equals(paramConfigEntity.getParamCode())) {
                cParamCode.setCellValue("\u5bf9\u516c\u5f00\u6237");
            } else if ("4".equals(paramConfigEntity.getParamCode())) {
                cParamCode.setCellValue("\u7406\u8d22\u4e1a\u52a1");
            } else if ("5".equals(paramConfigEntity.getParamCode())) {
                cParamCode.setCellValue("\u7f34\u8d39");
            }
            Cell cParamValue = row.createCell(2);
            if ("Y".equals(paramConfigEntity.getParamValue())) {
                cParamValue.setCellValue("\u662f");
                continue;
            }
            if (!"N".equals(paramConfigEntity.getParamValue())) continue;
            cParamValue.setCellValue("\u5426");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"Back_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }
}

