/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.auth.service.Impl;

import cn.com.yusys.yusp.auth.bo.AuthParamBusiHoursBo;
import cn.com.yusys.yusp.auth.dao.AuthParamBusiHoursDao;
import cn.com.yusys.yusp.auth.domain.dto.BusiHoursDto;
import cn.com.yusys.yusp.auth.domain.entity.AuthParamBusiHoursEntity;
import cn.com.yusys.yusp.auth.domain.query.AuthParamBusiHoursQuery;
import cn.com.yusys.yusp.auth.service.AuthParamBusiHoursService;
import cn.com.yusys.yusp.auth.vo.AuthParamBusiHoursVo;
import cn.com.yusys.yusp.common.annotation.MyPageAble;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AuthParamBusiHoursServiceImpl
implements AuthParamBusiHoursService {
    private static final Logger logger = LoggerFactory.getLogger(AuthParamBusiHoursServiceImpl.class);
    @Autowired
    private AuthParamBusiHoursDao authParamBusiHoursDao;

    @Override
    public int create(AuthParamBusiHoursBo authParamBusiHoursBo) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamBusiHoursBo);
        List<BusiHoursDto> dtoList = this.authParamBusiHoursDao.selectByModel(model);
        if (dtoList.size() == 0) {
            AuthParamBusiHoursEntity authParamBusiHoursEntity = new AuthParamBusiHoursEntity();
            BeanUtils.beanCopy((Object)authParamBusiHoursBo, (Object)authParamBusiHoursEntity);
            authParamBusiHoursEntity.setParamId(StringUtils.getUUID());
            authParamBusiHoursEntity.setLastChgUser(SessionUtils.getUserId());
            authParamBusiHoursEntity.setLastChgDt(DateUtils.formatDateByDef());
            return this.authParamBusiHoursDao.insert(authParamBusiHoursEntity);
        }
        throw new IcspException("500", "\u8be5\u8bb0\u5f55\u5df2\u5b58\u5728");
    }

    @Override
    public BusiHoursDto show(AuthParamBusiHoursQuery authParamBusiHoursQuery) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamBusiHoursQuery);
        List<BusiHoursDto> list = this.authParamBusiHoursDao.selectByModel(model);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[ ] logId=" + authParamBusiHoursQuery.getParamId() + " ]");
        }
        return list.get(0);
    }

    @MyPageAble(returnVo=BusiHoursDto.class)
    public List index(QueryModel model) throws Exception {
        PageHelper.startPage((int)model.getPage(), (int)model.getSize());
        List<BusiHoursDto> dtoList = this.authParamBusiHoursDao.selectByModel(model);
        PageHelper.clearPage();
        return dtoList;
    }

    @Override
    public List<AuthParamBusiHoursVo> list(QueryModel model) throws Exception {
        List<BusiHoursDto> list = this.authParamBusiHoursDao.selectByModel(model);
        List authParamBusiHoursVos = (List)BeanUtils.beansCopy(list, AuthParamBusiHoursVo.class);
        return authParamBusiHoursVos;
    }

    @Override
    public int update(AuthParamBusiHoursBo authParamBusiHoursBo) throws Exception {
        QueryModel model = new QueryModel();
        model.setCondition((Object)authParamBusiHoursBo);
        List<BusiHoursDto> dtoList = this.authParamBusiHoursDao.selectByModel(model);
        if (dtoList.size() == 0) {
            AuthParamBusiHoursEntity authParamBusiHoursEntity = new AuthParamBusiHoursEntity();
            BeanUtils.beanCopy((Object)authParamBusiHoursBo, (Object)authParamBusiHoursEntity);
            authParamBusiHoursEntity.setLastChgUser(SessionUtils.getUserId());
            authParamBusiHoursEntity.setLastChgDt(DateUtils.formatDateByDef());
            return this.authParamBusiHoursDao.updateByPrimaryKey(authParamBusiHoursEntity);
        }
        throw new IcspException("500", "\u8be5\u8bb0\u5f55\u5df2\u5b58\u5728");
    }

    @Override
    public int delete(String paramId) throws Exception {
        return this.authParamBusiHoursDao.deleteByPrimaryKey(paramId);
    }

    @Override
    public void save(QueryModel model, HttpServletResponse response) throws Exception {
        List<BusiHoursDto> busiHoursDtoList = this.authParamBusiHoursDao.selectByModel(model);
        HSSFWorkbook wk = new HSSFWorkbook();
        HSSFSheet sheet = wk.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        Cell cOrgIdTitle = rowTitle.createCell(0);
        cOrgIdTitle.setCellValue("\u673a\u6784\u53f7");
        Cell cOrgNameTitle = rowTitle.createCell(1);
        cOrgNameTitle.setCellValue("\u673a\u6784\u540d\u79f0");
        Cell cDateTypeTitle = rowTitle.createCell(2);
        cDateTypeTitle.setCellValue("\u65e5\u671f\u7c7b\u578b");
        Cell cStartDateTitle = rowTitle.createCell(3);
        cStartDateTitle.setCellValue("\u5f00\u59cb\u65e5\u671f");
        Cell cEndDateTitle = rowTitle.createCell(4);
        cEndDateTitle.setCellValue("\u7ed3\u675f\u65e5\u671f");
        Cell cStartTimeTitle = rowTitle.createCell(5);
        cStartTimeTitle.setCellValue("\u5f00\u59cb\u65f6\u95f4");
        Cell cEndTimeTitle = rowTitle.createCell(6);
        cEndTimeTitle.setCellValue("\u7ed3\u675f\u65f6\u95f4");
        Cell cBusiDeadlineTitle = rowTitle.createCell(7);
        cBusiDeadlineTitle.setCellValue("\u7ed3\u675f\u65f6\u95f4");
        int num = 1;
        for (BusiHoursDto busiHoursDto : busiHoursDtoList) {
            HSSFRow row = sheet.createRow(num++);
            Cell cOrgId = row.createCell(0);
            cOrgId.setCellValue(busiHoursDto.getOrgId());
            Cell cOrgName = row.createCell(1);
            cOrgName.setCellValue(busiHoursDto.getOrgName());
            Cell cDateType = row.createCell(2);
            cDateType.setCellValue(busiHoursDto.getDateType());
            Cell cStartDate = row.createCell(3);
            cStartDate.setCellValue(busiHoursDto.getStartDate());
            Cell cEndDate = row.createCell(4);
            cEndDate.setCellValue(busiHoursDto.getEndDate());
            Cell cStartTime = row.createCell(5);
            cStartTime.setCellValue(busiHoursDto.getStartTime());
            Cell cEndTime = row.createCell(6);
            cEndTime.setCellValue(busiHoursDto.getEndTime());
            Cell cBusiDeadline = row.createCell(7);
            cBusiDeadline.setCellValue(busiHoursDto.getBusiDeadline());
        }
        String date = DateUtils.formatDateTimeByDef();
        date = date.replace(" ", "").replace(":", "").replace("-", "");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wk.write((OutputStream)outputStream);
        byte[] bytes = outputStream.toByteArray();
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=\"BusiHours_" + date + ".xls\"");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Length", "" + bytes.length);
        response.setContentType("application/msexcel; charset=UTF-8");
        IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
    }

    @Override
    public void upload(MultipartFile file) throws Exception {
        String sheetName = "Sheet0";
        FileInputStream fileInputStream = (FileInputStream)file.getInputStream();
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fileInputStream);
        HSSFSheet sheet = workbook.getSheet(sheetName);
        ArrayList<AuthParamBusiHoursEntity> entities = new ArrayList<AuthParamBusiHoursEntity>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            AuthParamBusiHoursEntity entity = new AuthParamBusiHoursEntity();
            entity.setParamId(StringUtils.getUUID());
            entity.setOrgId(sheet.getRow(i).getCell(0).toString());
            entity.setDateType(sheet.getRow(i).getCell(2).toString());
            entity.setStartDate(sheet.getRow(i).getCell(3).toString());
            entity.setEndDate(sheet.getRow(i).getCell(4).toString());
            entity.setStartTime(sheet.getRow(i).getCell(5).toString());
            entity.setEndTime(sheet.getRow(i).getCell(6).toString());
            entity.setBusiDeadline(sheet.getRow(i).getCell(7).toString());
            QueryModel model = new QueryModel();
            model.setCondition((Object)entity);
            List<BusiHoursDto> dtoList = this.authParamBusiHoursDao.selectByModel(model);
            if (dtoList.size() == 1) continue;
            entity.setLastChgUser(SessionUtils.getUserId());
            entity.setLastChgDt(DateUtils.formatDateByDef());
            entities.add(entity);
        }
        for (AuthParamBusiHoursEntity entity : entities) {
            this.authParamBusiHoursDao.insert(entity);
        }
    }
}

