/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.thread;

import cn.com.yusys.fox.server.thread.FXThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class FXThreadFactory
implements ThreadFactory {
    public static final String THREAD_NAME = "phoenix-main";
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;

    public FXThreadFactory() {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "phoenix-main-" + poolNumber.getAndIncrement() + "-service-thread-";
    }

    public FXThreadFactory(String prefix) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = prefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        FXThread t = new FXThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

