/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.filter;

import cn.com.yusys.fox.server.FilterChain;
import cn.com.yusys.fox.server.IMessageDispatchFilter;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.Session;
import cn.com.yusys.fox.server.Settings;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteFilter
implements IMessageDispatchFilter,
ProtocolConstants {
    private static final String CLUSTER_ADDRESS = "clusterAddress";
    private static final String CLUSTER_ADDRESS_SPLITOR = ",";
    private static final String CLUSTER_SERVER = "clusterServer";
    private static final String PROXY_ADDRESS = "proxyAddress";
    private static final String SERVER = "server";
    private static Logger logger = LoggerFactory.getLogger(RouteFilter.class);
    private static final char ADDRESS_SPLITOR = '/';
    private static final char PORT_SPLITOR = ':';
    private MessageDispatcher dispatcher;
    private Map<String, Long> faultClusterAddressMap = new ConcurrentHashMap<String, Long>();
    private long faultClusterRetryInterval = 10000L;
    private List<String> localIpList = null;
    private Lock lock = new ReentrantLock();
    private List<String> proxyAddressList = new ArrayList<String>();
    private List<String> clusterAddressList = new ArrayList<String>();

    @Override
    public void init(MessageDispatcher messageDispatcher) {
        this.dispatcher = messageDispatcher;
        Settings settings = Settings.getInstance();
        this.clusterAddressList = settings.getClusterAddress();
        this.faultClusterRetryInterval = settings.getLong(SERVER, "faultClusterRetryInterval", 600000L);
        this.proxyAddressList = settings.getProxyAddress();
    }

    @Override
    public void destroy(MessageDispatcher messageDispatcher) {
    }

    @Override
    public void messageReceived(FilterChain filterChain, Session session, Object message) {
        Message msg = (Message)message;
        String destination = msg.getHeader("des");
        int endIndex = destination.indexOf(47);
        String address = endIndex != -1 ? destination.substring(0, endIndex) : destination;
        if ("*".equals(address)) {
            String module = "";
            if (endIndex == -1) {
                module = destination.substring(endIndex);
            }
            try {
                this.broadcast(module, filterChain, session, msg, false);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String source = this.dispatcher.getLocalAddress();
                this.handleException(filterChain, session, source, e, msg);
            }
            return;
        }
        if ("+".equals(address)) {
            String module = "";
            if (endIndex == -1) {
                module = destination.substring(endIndex);
            }
            try {
                this.broadcast(module, filterChain, session, msg, true);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String source = this.dispatcher.getLocalAddress();
                this.handleException(filterChain, session, source, e, msg);
            }
            return;
        }
        if ("-".equals(address)) {
            String module = "";
            if (endIndex == -1) {
                module = destination.substring(endIndex);
            }
            try {
                this.broadcast2Server(module, filterChain, session, msg);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String source = this.dispatcher.getLocalAddress();
                this.handleException(filterChain, session, source, e, msg);
            }
            return;
        }
        int splitIndex = address.indexOf(124);
        if (splitIndex == -1) {
            if ("~".equals(address)) {
                filterChain.messageReceived(session, message);
                return;
            }
            endIndex = address.indexOf(58);
            String ip = address.substring(0, endIndex);
            String port = address.substring(endIndex + 1);
            String localAddress = this.dispatcher.getLocalAddress();
            if (ip.equals("127.0.0.1")) {
                endIndex = localAddress.indexOf(58);
                ip = localAddress.substring(0, endIndex);
                address = ip + ':' + port;
            }
            String localPort = localAddress.substring(localAddress.indexOf(58) + 1);
            if (localAddress.equals(address) || this.isLocalIP(ip) && port.equals(localPort) || this.isProxyAddress(address)) {
                filterChain.messageReceived(session, message);
            } else {
                boolean isConnected = this.dispatcher.getMessageChannel().isConnected(address);
                try {
                    if (isConnected) {
                        session.setAddress(address);
                        this.send(filterChain, session, msg);
                    } else {
                        String sourceType = msg.getHeader("srcType");
                        if (!CLUSTER_SERVER.equals(sourceType)) {
                            this.retransmission(null, null, filterChain, session, msg);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    String source = session.getAddress();
                    this.handleException(filterChain, session, source, e, msg);
                }
            }
        } else {
            String topAddress = address.substring(0, splitIndex);
            String bottomAddress = address.substring(splitIndex + 1);
            if ("~".equals(topAddress)) {
                try {
                    session.setAddress(bottomAddress);
                    filterChain.messageReceived(session, msg);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    String source = session.getAddress();
                    this.handleException(filterChain, session, source, e, msg);
                }
                return;
            }
            endIndex = topAddress.indexOf(58);
            String ip = topAddress.substring(0, endIndex);
            String port = topAddress.substring(endIndex + 1);
            String localAddress = this.dispatcher.getLocalAddress();
            if (ip.equals("127.0.0.1")) {
                endIndex = localAddress.indexOf(58);
                ip = localAddress.substring(0, endIndex);
                topAddress = ip + ':' + port;
            }
            String localPort = localAddress.substring(localAddress.indexOf(58) + 1);
            try {
                if (topAddress.equals(localAddress) || this.isLocalIP(ip) && port.equals(localPort) || this.isProxyAddress(address)) {
                    session.setAddress(bottomAddress);
                    filterChain.messageReceived(session, msg);
                } else {
                    this.retransmission(topAddress, address, filterChain, session, msg);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String source = session.getAddress();
                this.handleException(filterChain, session, source, e, msg);
            }
        }
    }

    @Override
    public void messageSent(FilterChain filterChain, Session session, Object message) throws Exception {
        Message msg = (Message)message;
        String destination = msg.getHeader("des");
        int index = destination.indexOf(47);
        String address = index != -1 ? destination.substring(0, index) : destination;
        if ("*".equals(address)) {
            String module = "";
            if (index != -1) {
                module = destination.substring(index);
            }
            this.broadcast(module, filterChain, session, msg, false);
        } else if ("+".equals(address)) {
            String module = "";
            if (index != -1) {
                module = destination.substring(index);
            }
            this.broadcast(module, filterChain, session, msg, true);
        } else if ("-".equals(address)) {
            String module = "";
            if (index != -1) {
                module = destination.substring(index);
            }
            this.broadcast2Server(module, filterChain, session, msg);
        } else if (!address.startsWith("H_")) {
            index = address.indexOf(124);
            if (index != -1) {
                String localAddress;
                String topAddress = address.substring(0, index);
                String bottomAddress = address.substring(index + 1);
                int endIndex = topAddress.indexOf(58);
                String ip = topAddress.substring(0, endIndex);
                String port = topAddress.substring(endIndex + 1);
                if (ip.equals("127.0.0.1")) {
                    localAddress = this.dispatcher.getLocalAddress();
                    endIndex = localAddress.indexOf(58);
                    ip = localAddress.substring(0, endIndex);
                    topAddress = ip + ':' + port;
                }
                localAddress = this.dispatcher.getLocalAddress();
                String localPort = localAddress.substring(localAddress.lastIndexOf(58) + 1);
                if (localAddress.equals(topAddress) || this.isLocalIP(ip) && port.equals(localPort) || this.isProxyAddress(topAddress)) {
                    session.setAddress(bottomAddress);
                    this.send(filterChain, session, msg);
                } else {
                    this.retransmission(topAddress, address, filterChain, session, msg);
                }
            } else {
                boolean isConnected = this.dispatcher.getMessageChannel().isConnected(address);
                if (isConnected) {
                    this.send(filterChain, session, msg);
                } else {
                    this.retransmission(null, address, filterChain, session, msg);
                }
            }
        }
    }

    private void send(FilterChain filterChain, Session session, Message message) throws Exception {
        filterChain.messageSent(session, message);
    }

    private void broadcast2Server(String module, FilterChain filterChain, Session session, Message message) throws Exception {
        int size = this.clusterAddressList.size();
        for (int i = 0; i < size; ++i) {
            String address = this.clusterAddressList.get(i);
            FilterChain cloneChain = filterChain.clone();
            String target = String.format("%s/%s", address, module);
            Session cloneSession = session.clone();
            cloneSession.setAddress(target);
            Message cloneMsg = message.clone();
            cloneMsg.setHeader("des", target);
            cloneMsg.setHeader("srcType", SERVER);
            try {
                this.send(cloneChain, cloneSession, cloneMsg);
                continue;
            }
            catch (Exception e) {
                logger.error("\u5e7f\u64ad(for server)\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u76ee\u6807\u5730\u5740[" + target + "],\u539f\u56e0[" + e.getMessage() + "]", (Throwable)e);
            }
        }
    }

    private void broadcast(String module, FilterChain filterChain, Session session, Message message, boolean innerBroadcast) throws Exception {
        String[] remoteAddress;
        for (String address : remoteAddress = this.dispatcher.getRemoteAddress()) {
            FilterChain cloneChain = filterChain.clone();
            StringBuilder sb = new StringBuilder();
            sb.append(address);
            sb.append(module);
            String target = sb.toString();
            Session cloneSession = session.clone();
            cloneSession.setAddress(target);
            Message cloneMsg = message.clone();
            cloneMsg.setHeader("des", target);
            cloneMsg.setHeader("srcType", SERVER);
            try {
                this.send(cloneChain, cloneSession, cloneMsg);
            }
            catch (Exception e) {
                logger.error("\u5e7f\u64ad\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u76ee\u6807\u5730\u5740[" + target + "],\u539f\u56e0[" + e.getMessage() + "]", (Throwable)e);
            }
        }
        String sourceType = message.getHeader("srcType");
        if (!innerBroadcast && !CLUSTER_SERVER.equals(sourceType)) {
            this.retransmission(null, null, filterChain, session, message);
        }
    }

    private void retransmission(String transmitTarget, String targetAddress, FilterChain filterChain, Session session, Message message) throws Exception {
        boolean found;
        int size = this.clusterAddressList.size();
        if (size == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u96c6\u7fa4\u8f6c\u5931\u8d25\uff0c\u96c6\u7fa4\u5730\u5740\u4e3a\u7a7a\uff0c\u6765\u6e90\u5730\u5740[");
            sb.append(message.getHeader("src"));
            sb.append("],\u76ee\u6807\u5730\u5740[");
            sb.append(message.getHeader("des"));
            sb.append("]");
            logger.warn(sb.toString());
            return;
        }
        boolean broadcast = false;
        if (transmitTarget == null) {
            found = this.isClusterAddress(targetAddress);
            if (found) {
                transmitTarget = targetAddress;
            } else {
                broadcast = true;
            }
        } else {
            found = this.isClusterAddress(transmitTarget);
            if (!found) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u7cbe\u786e\u65b9\u5f0f\u96c6\u7fa4\u8f6c\u5931\u8d25\uff0c\u76ee\u6807\u5730\u5740\u4e0d\u5728\u96c6\u7fa4\u5730\u5740\u5217\u8868\u4e2d\uff0c\u6765\u6e90\u5730\u5740[");
                sb.append(message.getHeader("src"));
                sb.append("],\u76ee\u6807\u5730\u5740[");
                sb.append(message.getHeader("des"));
                sb.append("]");
                throw new Exception(sb.toString());
            }
        }
        String localAddress = this.dispatcher.getLocalAddress();
        String localPort = localAddress.substring(localAddress.indexOf(58) + 1);
        long currentTime = System.currentTimeMillis();
        if (broadcast) {
            for (int i = 0; i < size; ++i) {
                long interval;
                String target = this.clusterAddressList.get(i);
                Long time = this.faultClusterAddressMap.get(target);
                if (time != null && (interval = currentTime - time) <= this.faultClusterRetryInterval) {
                    if (!logger.isDebugEnabled()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("\u5e7f\u64ad\u65b9\u5f0f\u96c6\u7fa4\u8f6c\u53d1\u6d88\u606f\uff0c\u8f6c\u6362\u53d1\u5740[");
                    sb.append(target);
                    sb.append("]\u6545\u969c\uff0c\u8bf7\u5728\u95f4\u9694\u65f6\u95f4\u8d85\u8fc7[");
                    sb.append(this.faultClusterRetryInterval);
                    sb.append("]\u6beb\u79d2\u540e\u91cd\u8bd5");
                    logger.debug(sb.toString());
                    continue;
                }
                try {
                    if (target.equals(localAddress)) continue;
                    int splitIndex = target.indexOf(58);
                    String targetIp = target.substring(0, splitIndex);
                    String targetPort = target.substring(splitIndex + 1);
                    if (this.isLocalIP(targetIp) && localPort.equals(targetPort)) continue;
                    Session cloneSession = session.clone();
                    cloneSession.setAddress(target);
                    FilterChain cloneFilter = filterChain.clone();
                    Message cloneMsg = message.clone();
                    cloneMsg.setHeader("srcType", CLUSTER_SERVER);
                    this.send(cloneFilter, cloneSession, cloneMsg);
                    if (time != null) {
                        this.faultClusterAddressMap.remove(target);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("\u5e7f\u64ad\u65b9\u5f0f\u96c6\u7fa4\u8f6c\u53d1\u6d88\u606f\uff0c\u6765\u6e90\u5730\u5740[");
                    sb.append(message.getHeader("src"));
                    sb.append("],\u76ee\u6807\u5730\u5740[");
                    sb.append(message.getHeader("des"));
                    sb.append("],\u8f6c\u6362\u53d1\u5740[");
                    sb.append(target);
                    sb.append("]");
                    logger.debug(sb.toString());
                    continue;
                }
                catch (Throwable cause) {
                    this.faultClusterAddressMap.put(target, currentTime);
                    logger.error(cause.getMessage(), cause);
                }
            }
        } else {
            Session cloneSession = session.clone();
            cloneSession.setAddress(transmitTarget);
            FilterChain cloneFilter = filterChain.clone();
            Message cloneMsg = message.clone();
            cloneMsg.setHeader("srcType", CLUSTER_SERVER);
            this.send(cloneFilter, cloneSession, cloneMsg);
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u7cbe\u786e\u65b9\u5f0f\u96c6\u7fa4\u8f6c\u53d1\u6d88\u606f\uff0c\u6765\u6e90\u5730\u5740[");
                sb.append(message.getHeader("src"));
                sb.append("],\u76ee\u6807\u5730\u5740[");
                sb.append(message.getHeader("des"));
                sb.append("],\u8f6c\u6362\u53d1\u5740[");
                sb.append(transmitTarget);
                sb.append("]");
                logger.debug(sb.toString());
            }
        }
    }

    private boolean isClusterAddress(String address) {
        if (address == null) {
            return false;
        }
        String localAddress = this.dispatcher.getLocalAddress();
        String localPort = localAddress.substring(localAddress.indexOf(58) + 1);
        ArrayList clusterAddressList = new ArrayList();
        boolean found = false;
        int size = clusterAddressList.size();
        for (int i = 0; i < size; ++i) {
            String target = (String)clusterAddressList.get(i);
            if (target.equals(localAddress)) continue;
            int splitIndex = target.indexOf(58);
            String targetIp = target.substring(0, splitIndex);
            String targetPort = target.substring(splitIndex + 1);
            if (this.isLocalIP(targetIp) && localPort.equals(targetPort) || !target.equals(address)) continue;
            found = true;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLocalIPList() {
        if (this.localIpList == null) {
            this.lock.lock();
            try {
                if (this.localIpList == null) {
                    Enumeration<NetworkInterface> netInterfaces = null;
                    try {
                        netInterfaces = NetworkInterface.getNetworkInterfaces();
                        this.localIpList = new ArrayList<String>();
                        while (netInterfaces.hasMoreElements()) {
                            NetworkInterface ni = netInterfaces.nextElement();
                            Enumeration<InetAddress> address = ni.getInetAddresses();
                            while (address.hasMoreElements()) {
                                InetAddress ia = address.nextElement();
                                if (ia.isLoopbackAddress() || ia.getHostAddress().indexOf(":") != -1) continue;
                                this.localIpList.add(ia.getHostAddress());
                            }
                        }
                        logger.debug("Detect IP : ipList=" + this.localIpList);
                    }
                    catch (SocketException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.localIpList;
    }

    private boolean isLocalIP(String ip) {
        List<String> localIpList = this.getLocalIPList();
        if (localIpList == null) {
            return false;
        }
        logger.error("local IP=" + ip);
        return localIpList.contains(ip);
    }

    private void handleException(FilterChain filterChain, Session session, String destination, Exception e, Message srcMsg) {
        String messageId = srcMsg.getHeader("id");
        if (messageId == null) {
            return;
        }
        Message exceptionMsg = new Message();
        exceptionMsg.setHeader("msgType", MessageType.Response.value());
        exceptionMsg.setHeader("statusCode", "400");
        exceptionMsg.setHeader("des", srcMsg.getHeader("src"));
        exceptionMsg.setHeader("id", messageId);
        exceptionMsg.setHeader("type", ContentType.String_UTF8.value());
        String errorMsg = e.getMessage();
        exceptionMsg.setData(errorMsg);
        session.setAddress(destination);
        try {
            this.send(filterChain, session, exceptionMsg);
        }
        catch (Exception ex) {
            String exMsg = String.format("send message error, destination=%s", destination);
            logger.error(exMsg, (Throwable)e);
        }
    }

    private boolean isProxyAddress(String address) {
        logger.info("\u68c0\u67e5address:" + address + ", proxyAddressList Size:" + this.proxyAddressList.size());
        int size = this.proxyAddressList.size();
        for (int i = 0; i < size; ++i) {
            logger.info("proxyAddress:" + this.proxyAddressList.get(i).toString());
        }
        boolean isProxy = this.proxyAddressList.contains(address);
        return isProxy;
    }
}

