/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.filter;

import cn.com.yusys.fox.server.FilterChain;
import cn.com.yusys.fox.server.IMessageDispatchFilter;
import cn.com.yusys.fox.server.IMsgContentParser;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.Session;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import cn.com.yusys.fox.server.parser.BinaryArrayParser;
import cn.com.yusys.fox.server.parser.StringUTF8Parser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParserFilter
implements IMessageDispatchFilter,
ProtocolConstants {
    private static Logger logger = LoggerFactory.getLogger(MessageParserFilter.class);
    private static final char CR_MARK = '\r';
    private static final char LF_MARK = '\n';
    private static final char SPACE_MARK = ' ';
    private static final char COLON_MARK = ':';
    private static final String HEADER_CHARSET_NAME = "UTF-8";
    protected Map<String, IMsgContentParser> msgContentParserMap = new HashMap<String, IMsgContentParser>();
    protected int compressThreshold = 1000;

    private byte[] zip(byte[] content, int pos, int len) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(len);
        GZIPOutputStream zipOut = new GZIPOutputStream(byteOut);
        zipOut.write(content, pos, len);
        zipOut.close();
        byte[] res = byteOut.toByteArray();
        return res;
    }

    private byte[] unzip(byte[] content, int pos, int len) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(content, pos, len);
        GZIPInputStream zipIn = new GZIPInputStream(byteIn);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(len);
        byte[] buff = new byte[1024];
        int length = 0;
        while ((length = zipIn.read(buff)) != -1) {
            byteOut.write(buff, 0, length);
        }
        zipIn.close();
        byte[] res = byteOut.toByteArray();
        return res;
    }

    public byte[] encodeMessage(Message message) throws Exception {
        Map<String, String> headers = message.getHeaders();
        String contentType = headers.get("type");
        IMsgContentParser parser = this.getMessageContentParser(contentType);
        if (parser == null) {
            throw new Exception("\u4e0d\u652f\u6301\u6d88\u606f\u5185\u5bb9\u7c7b\u578b[" + contentType + "]");
        }
        byte[] content = parser.encode(message.getData(), contentType);
        if (this.compressThreshold != -1 && content.length > this.compressThreshold) {
            content = this.zip(content, 0, content.length);
            headers.put("encoding", "zip");
        } else {
            headers.put("encoding", "none");
        }
        headers.put("length", String.valueOf(content.length));
        StringBuilder sb = new StringBuilder();
        String messageType = headers.remove("msgType");
        if (MessageType.Response.value().equals(messageType)) {
            String statusCode = headers.remove("statusCode");
            sb.append(MessageType.Response.value());
            sb.append(' ');
            sb.append(statusCode);
            sb.append(' ');
            sb.append("3.0");
            sb.append("\r\n");
        } else {
            sb.append(MessageType.Request.value());
            sb.append(' ');
            sb.append("3.0");
            sb.append("\r\n");
            sb.append("msgType");
            sb.append(':');
            sb.append(messageType);
            sb.append("\r\n");
        }
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            sb.append(key);
            sb.append(':');
            sb.append(value);
            sb.append("\r\n");
        }
        sb.append("date");
        sb.append(':');
        sb.append(String.valueOf(System.currentTimeMillis()));
        sb.append("\r\n");
        sb.append("\r\n");
        byte[] headerByteArray = sb.toString().getBytes(HEADER_CHARSET_NAME);
        byte[] res = new byte[headerByteArray.length + content.length];
        System.arraycopy(headerByteArray, 0, res, 0, headerByteArray.length);
        System.arraycopy(content, 0, res, headerByteArray.length, content.length);
        return res;
    }

    public Message decodeMessage(byte[] content) throws Exception {
        Message message = new Message();
        int sIndex = 0;
        int eIndex = 0;
        int index = 0;
        eIndex = this.gotoSpace(content, index);
        String messageType = new String(content, sIndex, eIndex - sIndex, HEADER_CHARSET_NAME);
        if (MessageType.Request.value().equals(messageType)) {
            index = this.skipSpace(content, eIndex + 1);
        } else if (MessageType.Response.value().equals(messageType)) {
            sIndex = index = this.skipSpace(content, eIndex + 1);
            eIndex = this.gotoSpace(content, index + 1);
            String statusCode = new String(content, sIndex, eIndex - sIndex, HEADER_CHARSET_NAME);
            message.setHeader("statusCode", statusCode);
            index = this.skipSpace(content, eIndex + 1);
        } else {
            throw new Exception("\u8bf7\u6c42\u6d88\u606f\u683c\u5f0f\u9519\u8bef");
        }
        sIndex = index;
        eIndex = this.gotoCR(content, index + 1);
        index = eIndex + 2;
        String version = new String(content, sIndex, eIndex - sIndex, HEADER_CHARSET_NAME);
        message.setHeader("version", version);
        message.setHeader("msgType", messageType);
        while (index < content.length) {
            sIndex = index;
            eIndex = this.gotoColon(content, index + 1);
            String key = new String(content, sIndex, eIndex - sIndex, HEADER_CHARSET_NAME);
            sIndex = this.skipSpace(content, eIndex + 1);
            eIndex = this.gotoCR(content, sIndex + 1);
            String value = new String(content, sIndex, eIndex - sIndex, HEADER_CHARSET_NAME);
            message.setHeader(key, value);
            index = eIndex + 2;
            if (13 != content[index] || 10 != content[index + 1]) continue;
            index += 2;
            break;
        }
        Object data = null;
        Integer contentLen = 0;
        String s = message.getHeader("length");
        if (s != null) {
            contentLen = Integer.parseInt(s);
        }
        if (contentLen > 0) {
            String contentType = message.getHeader("type");
            IMsgContentParser parser = this.getMessageContentParser(contentType);
            if (parser == null) {
                throw new Exception("\u4e0d\u652f\u6301\u6d88\u606f\u5185\u5bb9\u7c7b\u578b[" + contentType + "]");
            }
            String contentEncoding = message.getHeader("encoding");
            if ("zip".equals(contentEncoding)) {
                byte[] buffer = this.unzip(content, index, contentLen);
                data = parser.decode(buffer, 0, buffer.length, contentType);
            } else {
                data = parser.decode(content, index, contentLen, contentType);
            }
        }
        message.setData(data);
        return message;
    }

    private IMsgContentParser getMessageContentParser(String contentType) {
        IMsgContentParser parser = this.msgContentParserMap.get(contentType);
        if (parser == null) {
            String[] types = contentType.split("/");
            for (int i = types.length - 2; i >= 0 && (parser = this.msgContentParserMap.get(types[i])) == null; --i) {
            }
        }
        return parser;
    }

    private int skipSpace(byte[] content, int index) {
        char c;
        while (index < content.length && (c = (char)content[index]) == ' ') {
            ++index;
        }
        return index;
    }

    private int gotoSpace(byte[] content, int index) {
        while (index < content.length) {
            char c = (char)content[index];
            if (c == ' ') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int gotoCR(byte[] content, int index) {
        while (index < content.length) {
            char c = (char)content[index];
            if (c == '\r') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int gotoColon(byte[] content, int index) {
        while (index < content.length) {
            char c = (char)content[index];
            if (c == ':') {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void init(MessageDispatcher messageDispatcher) {
        this.loadConfig();
        try {
            this.loadMsgContentParser();
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u6d88\u606f\u5185\u5bb9\u89e3\u6790\u5668\u5931\u8d25", e.getCause());
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    protected void loadConfig() {
        this.compressThreshold = 1000;
    }

    protected void loadMsgContentParser() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("init message content parser");
        }
        this.msgContentParserMap.put("text/utf8", new StringUTF8Parser());
        this.msgContentParserMap.put("binary/array", new BinaryArrayParser());
    }

    @Override
    public void destroy(MessageDispatcher messageDispatcher) {
    }

    @Override
    public void messageReceived(FilterChain filterChain, Session session, Object message) {
        String source = null;
        try {
            Message msg = this.decodeMessage((byte[])message);
            filterChain.messageReceived(session, msg);
        }
        catch (Exception e) {
            String errorMsg = String.format("decode message eror, source=%s", source);
            logger.error(errorMsg, (Throwable)e);
            this.handleException(filterChain, session, source, e);
        }
    }

    @Override
    public void messageSent(FilterChain filterChain, Session session, Object message) throws Exception {
        byte[] content = this.encodeMessage((Message)message);
        filterChain.messageSent(session, content);
    }

    private void handleException(FilterChain filterChain, Session session, String destination, Exception e) {
        Message exceptionMsg = new Message();
        exceptionMsg.setHeader("msgType", MessageType.Response.value());
        exceptionMsg.setHeader("statusCode", "400");
        exceptionMsg.setHeader("des", destination);
        exceptionMsg.setHeader("type", ContentType.String_UTF8.value());
        String errorMsg = e.getMessage();
        exceptionMsg.setData(errorMsg);
        try {
            this.messageSent(filterChain, session, exceptionMsg);
        }
        catch (Exception ex) {
            String exMsg = String.format("send message error, destination:%s", destination);
            logger.error(exMsg, (Throwable)e);
        }
    }
}

