/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.SettingsKey;
import cn.com.yusys.fox.server.utils.NetworkUtil;
import cn.com.yusys.fox.server.utils.ObjectConvert;
import cn.com.yusys.fox.server.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Settings
implements SettingsKey {
    private static final String LINE_SPLITOR = "\r\n";
    private static final String ENCODING = "UTF-8";
    private Map<String, Map<String, Object>> allMap = new HashMap<String, Map<String, Object>>();
    private volatile Object mutexDoNotUseDirectly;
    private static Settings instance = new Settings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            Settings settings = this;
            synchronized (settings) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return mutex;
    }

    public static Settings getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void to(OutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        Object object = this.mutex();
        synchronized (object) {
            for (String mark : this.allMap.keySet()) {
                Map<String, Object> map = this.allMap.get(mark);
                if (map == null) continue;
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    sb.append(mark);
                    sb.append("/");
                    sb.append(key);
                    sb.append("=");
                    try {
                        sb.append(ObjectConvert.object2Str(value));
                    }
                    catch (Exception e) {
                        sb.append(value);
                    }
                    sb.append(LINE_SPLITOR);
                }
            }
        }
        int end = sb.length() - LINE_SPLITOR.length();
        if (end > 0) {
            String content = sb.substring(0, end);
            byte[] bytes = content.getBytes(ENCODING);
            out.write(bytes);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void from(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, ENCODING));
        Object object = this.mutex();
        synchronized (object) {
            String line;
            while ((line = reader.readLine()) != null) {
                int index;
                char c;
                if ((line = line.trim()).length() == 0 || (c = line.charAt(0)) == '#' || (index = line.indexOf("=")) == -1) continue;
                String prePart = line.substring(0, index).trim();
                String postPart = line.substring(index + 1).trim();
                index = prePart.indexOf("/");
                if (index == -1) continue;
                String mark = prePart.substring(0, index).trim();
                String key = prePart.substring(index + 1).trim();
                String value = postPart.trim();
                System.out.println(String.format("%s,%s,%s", mark, key, value));
                Map<String, Object> map = this.allMap.get(mark);
                if (map == null) {
                    map = new HashMap<String, Object>();
                    this.allMap.put(mark, map);
                }
                map.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String mark) {
        Object object = this.mutex();
        synchronized (object) {
            return this.allMap.containsKey(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String mark, String key) {
        Object object = this.mutex();
        synchronized (object) {
            Map<String, Object> appMap = this.allMap.get(mark);
            if (appMap == null) {
                return false;
            }
            return appMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String mark, String key, Object value) {
        Object object = this.mutex();
        synchronized (object) {
            Map<String, Object> appMap = this.allMap.get(mark);
            if (appMap == null) {
                appMap = new HashMap<String, Object>();
                this.allMap.put(mark, appMap);
            }
            appMap.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String mark, String key, Object defaultValue) {
        Object object = this.mutex();
        synchronized (object) {
            Map<String, Object> appMap = this.allMap.get(mark);
            Object value = null;
            if (appMap != null) {
                value = appMap.get(key);
            }
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
    }

    public String getString(String mark, String key, String defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                String res = ObjectConvert.convert(value, String.class);
                return res;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String mark, String key, boolean defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                Boolean res = ObjectConvert.convert(value, Boolean.class);
                return res;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getInt(String mark, String key, int defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                Integer res = ObjectConvert.convert(value, Integer.class);
                return res;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long getLong(String mark, String key, long defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                Long res = ObjectConvert.convert(value, Long.class);
                return res;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public float getFloat(String mark, String key, float defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                Float res = ObjectConvert.convert(value, Float.class);
                return res.floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public double getDouble(String mark, String key, double defaultValue) {
        Object value = this.get(mark, key, null);
        if (value != null) {
            try {
                Double res = ObjectConvert.convert(value, Double.class);
                return res;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setHost(String host) {
        this.put("server", "host", host);
    }

    public String getHost() {
        String host = this.getString("server", "host", "");
        if (StringUtil.isEmpty(host)) {
            try {
                host = NetworkUtil.getLocalIP();
            }
            catch (Exception e) {
                host = "127.0.0.1";
            }
            this.put("server", "host", host);
        }
        return host;
    }

    public void setPort(int port) {
        this.put("server", "port", port);
    }

    public int getPort() {
        int port = this.getInt("server", "port", 9100);
        return port;
    }

    public void setAutoDisconnectTimeout(int autoDisconnectTimeout) {
        this.put("server", "autoDisconnectTimeout", autoDisconnectTimeout);
    }

    public int getAutoDisconnectTimeout() {
        return this.getInt("server", "autoDisconnectTimeout", 60000);
    }

    public void setPingTimeout(int pingTimeout) {
        this.put("server", "pingTimeout", pingTimeout);
    }

    public int getPingTimeout() {
        return this.getInt("server", "pingTimeout", 300);
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.put("server", "securityPolicy", securityPolicy);
    }

    public String getSecurityPolicy() {
        return this.getString("server", "securityPolicy", "none");
    }

    public void setClusterAddress(List<String> list) {
        String s = (String)list.stream().reduce((acc, item) -> {
            acc = String.format("%s, %s", acc, item);
            return acc;
        }).get();
        this.put("server", "clusterAddress", s);
    }

    public List<String> getClusterAddress() {
        ArrayList<String> list = new ArrayList<String>();
        String s = this.getString("server", "clusterAddress", "");
        if (StringUtil.isEmpty(s)) {
            return list;
        }
        String[] ss = StringUtil.split(s, ",");
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }

    public void setProxyAddress(List<String> list) {
        String s = (String)list.stream().reduce((acc, item) -> {
            acc = String.format("%s, %s", acc, item);
            return acc;
        }).get();
        this.put("server", "proxyAddress", s);
    }

    public List<String> getProxyAddress() {
        ArrayList<String> list = new ArrayList<String>();
        String s = this.getString("server", "proxyAddress", "");
        if (StringUtil.isEmpty(s)) {
            return list;
        }
        String[] ss = StringUtil.split(s, ",");
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.put("server", "corePoolSize", corePoolSize);
    }

    public int getCorePoolSize() {
        return this.getInt("server", "corePoolSize", 50);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.put("server", "maxPoolSize", maxPoolSize);
    }

    public int getMaxPoolSize() {
        return this.getInt("server", "maxPoolSize", 100);
    }

    public int getKeepAliveTime() {
        return this.getInt("server", "keepAliveTime", 30);
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.put("server", "keepAliveTime", keepAliveTime);
    }

    public int getQueueSize() {
        return this.getInt("server", "queueSize", 100);
    }

    public void setQueueSize(int queueSize) {
        this.put("server", "queueSize", queueSize);
    }
}

