/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.CallbackContext;
import cn.com.yusys.fox.server.IMessageCallback;
import cn.com.yusys.fox.server.IMessageHandler;
import cn.com.yusys.fox.server.IMessageService;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler
implements IMessageHandler,
ProtocolConstants {
    private static Logger logger = LoggerFactory.getLogger(MessageHandler.class);
    public static final String SPLIT = "><";
    private static final int EXCEPTION_STACK_LEVEL = 15;
    private String name;
    private Map<String, IMessageService> messageServiceMap = new ConcurrentHashMap<String, IMessageService>();
    private MessageDispatcher messageDispatcher;
    private AtomicLong messageIdSeed = new AtomicLong(0L);
    private Map<String, CallbackRecord> msgCallbackMap = new HashMap<String, CallbackRecord>();
    private volatile Object mutexDoNotUseDirectly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            MessageHandler messageHandler = this;
            synchronized (messageHandler) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return mutex;
    }

    MessageHandler(String name, MessageDispatcher messageDispatcher) {
        this.name = name;
        this.messageDispatcher = messageDispatcher;
    }

    public String getName() {
        return this.name;
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    private String generateMessageId() {
        long id = this.messageIdSeed.incrementAndGet();
        String msgId = String.valueOf(id);
        return msgId;
    }

    private boolean isNeedResponse(String requestType) {
        boolean res = !MessageType.Notify.value().equals(requestType);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MessageType requestType, String destination, String desModule, String desService, Message message, IMessageCallback callback) throws Exception {
        String target = String.format("%s/%s/%s", destination, desModule, desService);
        message.setHeader("des", target);
        String src = String.format("%s/%s", this.getLocalAddress(), this.getName());
        message.setHeader("src", src);
        message.setHeader("msgType", requestType.value());
        String messageId = null;
        if (callback != null && this.isNeedResponse(requestType.value())) {
            messageId = this.generateMessageId();
            message.setHeader("id", messageId);
            CallbackRecord record = new CallbackRecord(callback);
            Object object = this.mutex();
            synchronized (object) {
                this.msgCallbackMap.put(messageId, record);
            }
        }
        try {
            this.messageDispatcher.sendMessage(target, message);
        }
        catch (Exception e) {
            if (messageId != null) {
                this.msgCallbackMap.remove(messageId);
            }
            throw e;
        }
    }

    @Override
    public void send(MessageType requestType, String destination, String desModule, String desService, Map<String, String> headers, Object data, ContentType contentType, IMessageCallback callback) throws Exception {
        Message message = new Message();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                message.setHeader(entry.getKey(), entry.getValue());
            }
        }
        message.setHeader("type", contentType.value());
        message.setData(data);
        this.send(requestType, destination, desModule, desService, message, callback);
    }

    @Override
    public void notify(String destination, String desModule, String desService, Map<String, String> headers, Object data, ContentType contentType) throws Exception {
        this.send(MessageType.Notify, destination, desModule, desService, headers, data, contentType, null);
    }

    void handleMessage(String address, Message message) {
        String messageType = message.getHeader("msgType");
        String src = message.getHeader("src");
        if (src == null) {
            src = address;
        }
        if (MessageType.Request.value().equals(messageType)) {
            this.handleRequest(src, message);
        } else if (MessageType.Redirect.value().equals(messageType)) {
            this.handleNotify(src, message);
        } else if (MessageType.Notify.value().equals(messageType)) {
            this.handleNotify(src, message);
        } else if (MessageType.Response.value().equals(messageType)) {
            String statusCode = message.getHeader("statusCode");
            if (statusCode.charAt(0) == '2') {
                this.handleResponse(src, statusCode, message);
            } else if (statusCode.charAt(0) == '1') {
                this.handleReport(src, statusCode, message);
            } else {
                this.handleException(src, statusCode, message);
            }
        } else {
            String errorMsg = String.format("illegal message type[%s] from %s", messageType, src);
            logger.error(errorMsg);
            this.responseException(src, null, "500", new Exception(errorMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(String source, Throwable exception) {
        ArrayList<CallbackRecord> recList = new ArrayList<CallbackRecord>();
        Object object = this.mutex();
        synchronized (object) {
            recList.addAll(this.msgCallbackMap.values());
        }
        String statusCode = "400";
        String errMsg = exception.getMessage();
        if (errMsg == null) {
            errMsg = exception.toString();
        }
        int size = recList.size();
        for (int i = 0; i < size; ++i) {
            CallbackRecord rec = (CallbackRecord)recList.get(i);
            try {
                Message message = new Message();
                message.setHeader("type", ContentType.String_UTF8.value());
                message.setData(errMsg);
                rec.callback.onException(source, statusCode, message);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleRequest(String source, Message message) {
        String serviceName;
        IMessageService messageService;
        int index;
        int sIndex;
        String destination = message.getHeader("des");
        int eIndex = destination.indexOf(47, sIndex = destination.indexOf(47, (index = destination.indexOf(47)) + 1) + 1);
        if (eIndex == -1) {
            eIndex = destination.length();
        }
        if ((messageService = this.messageServiceMap.get(serviceName = destination.substring(sIndex, eIndex))) != null) {
            String messageId = message.getHeader("id");
            try {
                CallbackContext callbackContext = new CallbackContext(source, destination, messageId, this.messageDispatcher);
                callbackContext.report("connected", ContentType.String_UTF8);
                messageService.run(source, message, callbackContext);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                this.responseException(source, messageId, "500", e);
                return;
            }
        } else {
            String errorMsg = String.format("message service[%s] is not exist", serviceName);
            logger.error(errorMsg);
            Exception e = new Exception(errorMsg);
            String messageId = message.getHeader("id");
            this.responseException(source, messageId, "400", e);
        }
    }

    private void handleNotify(String source, Message message) {
        String serviceName;
        IMessageService messageService;
        int index;
        int sIndex;
        String destination = message.getHeader("des");
        int eIndex = destination.indexOf(47, sIndex = destination.indexOf(47, (index = destination.indexOf(47)) + 1) + 1);
        if (eIndex == -1) {
            eIndex = destination.length();
        }
        if ((messageService = this.messageServiceMap.get(serviceName = destination.substring(sIndex, eIndex))) != null) {
            String messageId = message.getHeader("id");
            try {
                CallbackContext callbackContext = new CallbackContext(source, destination, messageId, this.messageDispatcher);
                messageService.run(source, message, callbackContext);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                return;
            }
        } else {
            String errorMsg = String.format("message service[%s] is not exist", serviceName);
            logger.error(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReport(String source, String statusCode, Message message) {
        CallbackRecord rec;
        String messageId = message.getHeader("id");
        if (messageId == null) {
            return;
        }
        Object object = this.mutex();
        synchronized (object) {
            rec = this.msgCallbackMap.get(messageId);
        }
        if (rec == null) {
            return;
        }
        try {
            rec.callback.onReport(source, statusCode, message);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(String source, String statusCode, Message message) {
        CallbackRecord rec;
        String messageId = message.getHeader("id");
        if (messageId == null) {
            return;
        }
        Object object = this.mutex();
        synchronized (object) {
            rec = this.msgCallbackMap.remove(messageId);
        }
        if (rec == null) {
            return;
        }
        try {
            rec.callback.onMessage(source, statusCode, message);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(String source, String statusCode, Message message) {
        CallbackRecord rec;
        String messageId = message.getHeader("id");
        if (messageId == null) {
            return;
        }
        Object object = this.mutex();
        synchronized (object) {
            rec = this.msgCallbackMap.remove(messageId);
        }
        if (rec == null) {
            return;
        }
        try {
            rec.callback.onException(source, statusCode, message);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void responseException(String destination, String messageId, String statusCode, Throwable e) {
        Message message = new Message();
        message.setHeader("msgType", MessageType.Response.value());
        message.setHeader("des", destination);
        String src = String.format("%s/%s", this.getLocalAddress(), this.getName());
        message.setHeader("src", src);
        message.setHeader("statusCode", statusCode);
        if (messageId != null) {
            message.setHeader("id", messageId);
        }
        message.setHeader("type", ContentType.String_UTF8.value());
        String errorMsg = e.getMessage();
        if (errorMsg == null) {
            errorMsg = e.toString();
        }
        errorMsg = errorMsg + this.getStackTrace(e);
        message.setHeader("type", ContentType.String_UTF8.value());
        message.setData(errorMsg);
        try {
            this.messageDispatcher.sendMessage(destination, message);
        }
        catch (Exception ex) {
            logger.error(e.getMessage(), e);
        }
    }

    private String getStackTrace(Throwable e) {
        if (e == null || e.getStackTrace() == null) {
            return "";
        }
        StackTraceElement[] stes = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(SPLIT);
        int size = Math.min(15, stes.length);
        for (int i = 0; i < size; ++i) {
            sb.append(stes[i].toString()).append("\n\t");
        }
        return sb.toString();
    }

    @Override
    public void addMessageService(String serviceName, IMessageService messageService) {
        this.messageServiceMap.remove(serviceName);
        this.messageServiceMap.put(serviceName, messageService);
    }

    @Override
    public IMessageService removeMessageService(String serviceName) {
        return this.messageServiceMap.remove(serviceName);
    }

    @Override
    public IMessageService getMessageService(String serviceName) {
        IMessageService msgService = this.messageServiceMap.get(serviceName);
        return msgService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessageCallback(IMessageCallback callback) {
        Object object = this.mutex();
        synchronized (object) {
            String id = null;
            for (Map.Entry<String, CallbackRecord> en : this.msgCallbackMap.entrySet()) {
                if (en.getValue().callback != callback) continue;
                id = en.getKey();
                break;
            }
            if (id != null) {
                CallbackRecord rec = this.msgCallbackMap.remove(id);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLocalAddress() {
        return this.messageDispatcher.getLocalAddress();
    }

    @Override
    public String[] getRemoteAddress() {
        return this.messageDispatcher.getRemoteAddress();
    }

    private class CallbackRecord {
        public IMessageCallback callback;

        public CallbackRecord(IMessageCallback callback) {
            this.callback = callback;
        }
    }
}

