/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.FilterChain;
import cn.com.yusys.fox.server.IMessageChannel;
import cn.com.yusys.fox.server.IMessageDispatchFilter;
import cn.com.yusys.fox.server.IMessageHandler;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageHandler;
import cn.com.yusys.fox.server.Session;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements ProtocolConstants {
    private static Logger logger = LoggerFactory.getLogger(MessageDispatcher.class);
    static final int IN = 0;
    static final int OUT = 1;
    private List<IMessageDispatchFilter> messageDispatchFilters = new ArrayList<IMessageDispatchFilter>();
    private Map<String, IMessageHandler> messageHandlerMap = new ConcurrentHashMap<String, IMessageHandler>();
    private IMessageChannel messageChannel;

    public void init(IMessageChannel messageChannel, List<IMessageDispatchFilter> filters) {
        this.messageChannel = messageChannel;
        this.messageDispatchFilters = filters;
        this.messageDispatchFilters.forEach(filter -> filter.init(this));
    }

    public void destroy() {
        this.messageDispatchFilters.forEach(filter -> filter.destroy(this));
    }

    public IMessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void addMessageHandler(String name, IMessageHandler messageHandler) {
        this.messageHandlerMap.put(name, messageHandler);
    }

    public IMessageHandler getMessageHandler(String name) {
        return this.messageHandlerMap.get(name);
    }

    public IMessageHandler removeMessageHandler(String name) {
        return this.messageHandlerMap.remove(name);
    }

    public void sendMessage(String destination, Message message) throws Exception {
        FilterChain chain = new FilterChain(this.messageDispatchFilters.size(), this.messageDispatchFilters, this);
        Session session = new Session(destination);
        chain.messageSent(session, message);
    }

    public void handleMessage(String source, byte[] message) {
        FilterChain chain = new FilterChain(-1, this.messageDispatchFilters, this);
        Session session = new Session(source);
        chain.messageReceived(session, message);
    }

    public void handleException(String source, Throwable exception) {
        if (exception instanceof IOException) {
            for (String name : this.messageHandlerMap.keySet()) {
                MessageHandler messageHandler = (MessageHandler)this.messageHandlerMap.get(name);
                messageHandler.handleException(source, exception);
            }
        }
    }

    public String getLocalAddress() {
        return this.messageChannel.getLocalAddress();
    }

    public String[] getRemoteAddress() {
        return this.messageChannel.getRemoteAddress();
    }

    void dispatch(String address, Object message, int direction) throws Exception {
        if (direction == 0) {
            MessageHandler messageHandler = null;
            Message msg = (Message)message;
            String target = msg.getHeader("des");
            String module = null;
            int sIndex = target.indexOf(47) + 1;
            if (sIndex > 0) {
                int eIndex = target.indexOf(47, sIndex);
                if (eIndex == -1) {
                    eIndex = target.length();
                }
                module = target.substring(sIndex, eIndex);
                messageHandler = (MessageHandler)this.messageHandlerMap.get(module);
            }
            if (messageHandler != null) {
                messageHandler.handleMessage(address, (Message)message);
            } else {
                String errorMsg = String.format("module[%s] not exist", module);
                String messageId = msg.getHeader("id");
                Message exceptionMsg = new Message();
                exceptionMsg.setHeader("msgType", MessageType.Response.value());
                exceptionMsg.setHeader("des", address);
                exceptionMsg.setHeader("src", this.getLocalAddress());
                exceptionMsg.setHeader("statusCode", "400");
                exceptionMsg.setHeader("id", messageId);
                exceptionMsg.setHeader("type", ContentType.String_UTF8.value());
                exceptionMsg.setData(errorMsg);
                try {
                    this.sendMessage(address, exceptionMsg);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), ex.getCause());
                }
            }
        } else if (direction == 1) {
            String target = address;
            int index = address.indexOf(47);
            if (index != -1) {
                target = address.substring(0, index);
            }
            this.messageChannel.send(target, (byte[])message);
        }
    }
}

