/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.IMessageDispatchFilter;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.Session;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain {
    private static Logger logger = LoggerFactory.getLogger(FilterChain.class);
    private int index = 0;
    private List<IMessageDispatchFilter> filterList;
    private MessageDispatcher dispatcher;

    public FilterChain(int index, List<IMessageDispatchFilter> filterList, MessageDispatcher dispatcher) {
        this.index = index;
        this.filterList = filterList;
        this.dispatcher = dispatcher;
    }

    public void messageReceived(Session session, Object message) {
        if (this.index < this.filterList.size() - 1) {
            IMessageDispatchFilter filter = this.filterList.get(++this.index);
            filter.messageReceived(this, session, message);
        } else {
            try {
                this.dispatcher.dispatch(session.getAddress(), message, 0);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void messageSent(Session session, Object message) throws Exception {
        if (this.index > 0) {
            IMessageDispatchFilter filter = this.filterList.get(--this.index);
            filter.messageSent(this, session, message);
        } else {
            this.dispatcher.dispatch(session.getAddress(), message, 1);
        }
    }

    public FilterChain clone() {
        FilterChain chain = new FilterChain(this.index, this.filterList, this.dispatcher);
        return chain;
    }
}

