/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.IAcceptListener;
import cn.com.yusys.fox.server.IConnectionStateListener;
import cn.com.yusys.fox.server.IMessageCallback;
import cn.com.yusys.fox.server.IMessageChannel;
import cn.com.yusys.fox.server.IMessageDispatchFilter;
import cn.com.yusys.fox.server.IMessageHandler;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.MessageHandler;
import cn.com.yusys.fox.server.Settings;
import cn.com.yusys.fox.server.acceptor.MinaServerMsgChannel;
import cn.com.yusys.fox.server.constant.ConnectionState;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.filter.MessageParserFilter;
import cn.com.yusys.fox.server.filter.RouteFilter;
import cn.com.yusys.fox.server.thread.FXExecutorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommController {
    private static Logger logger = LoggerFactory.getLogger(CommController.class);
    private static CommController instance = new CommController();
    private boolean started;
    private IMessageChannel messageChannel;
    private MessageDispatcher messageDispatcher;
    private ExecutorService executorService;

    public static CommController getInstance() {
        return instance;
    }

    public Settings getSettings() {
        return Settings.getInstance();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            this.executorService = FXExecutorFactory.getDefaultCachedThreadPool();
            this.loadMessageChannel();
            this.loadMessageDispatcher();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.started = true;
    }

    private List<IMessageDispatchFilter> loadMessageDispatcherFilters() {
        ArrayList<IMessageDispatchFilter> filters = new ArrayList<IMessageDispatchFilter>();
        filters.add(new MessageParserFilter());
        filters.add(new RouteFilter());
        return filters;
    }

    private void loadMessageDispatcher() throws Exception {
        this.messageDispatcher = new MessageDispatcher();
        List<IMessageDispatchFilter> filters = this.loadMessageDispatcherFilters();
        this.messageDispatcher.init(this.messageChannel, filters);
    }

    private void unLoadMessageDispatcher() {
        if (this.messageDispatcher != null) {
            this.messageDispatcher.destroy();
        }
    }

    private void loadMessageChannel() throws Exception {
        this.messageChannel = new MinaServerMsgChannel();
        this.messageChannel.start();
        this.messageChannel.setAcceptListener(new AcceptListener(this.executorService));
        this.messageChannel.addConnectionStateListener(new ExceptionListener());
    }

    public void addConnectionStateListener(IConnectionStateListener iConnectionStateListener) {
        this.messageChannel.addConnectionStateListener(iConnectionStateListener);
    }

    public void send(MessageType requestType, String clientId, String strMessage, IMessageCallback callback) throws Exception {
        Message message = new Message();
        message.setData(strMessage.getBytes());
        message.setHeader("type", ContentType.Binary_Array.value());
        CommController.getInstance().getMessageHandler("proxy").send(requestType, clientId, "client", "message", message, callback);
    }

    private void unLoadMessageChannel() {
        if (this.messageChannel != null) {
            this.messageChannel.stop();
            this.messageChannel = null;
        }
    }

    public void stop() {
        if (logger.isInfoEnabled()) {
            logger.info("stop communication controller");
        }
        try {
            this.unLoadMessageDispatcher();
            this.unLoadMessageChannel();
            this.executorService.shutdown();
            this.started = false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("stop communication controller finished");
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public IMessageHandler getMessageHandler(String name) {
        IMessageHandler messageHandler = this.messageDispatcher.getMessageHandler(name);
        if (messageHandler == null) {
            messageHandler = new MessageHandler(name, this.messageDispatcher);
            this.messageDispatcher.addMessageHandler(name, messageHandler);
        }
        return messageHandler;
    }

    public void destroyMessageHandler(String name) {
        this.messageDispatcher.removeMessageHandler(name);
    }

    public class ExceptionListener
    implements IConnectionStateListener {
        @Override
        public void onMessage(ConnectionState state, String remoteAddress, Object data) {
            if (ConnectionState.EXCEPTION.equals((Object)state)) {
                StringBuilder sb = new StringBuilder();
                sb.append("connection[");
                sb.append(remoteAddress);
                sb.append("]\u5f02\u5e38");
                if (data instanceof Throwable) {
                    Throwable cause = (Throwable)data;
                    sb.append(",\u5f02\u5e38\u4fe1\u606f[");
                    sb.append(cause.getMessage());
                    sb.append("]");
                    logger.error(sb.toString(), cause);
                    CommController.this.messageDispatcher.handleException(remoteAddress, cause);
                } else {
                    String errorMsg = sb.toString();
                    logger.error(errorMsg);
                    CommController.this.messageDispatcher.handleException(remoteAddress, new Exception(errorMsg));
                }
            }
        }
    }

    public class AcceptListener
    implements IAcceptListener {
        private ExecutorService executorService;
        private long count = 0L;

        public AcceptListener(ExecutorService executorService) {
            this.executorService = executorService;
        }

        private void printThreadPoolInfo() {
            ++this.count;
            long n = this.count % 2000L;
            if (n == 0L && this.executorService instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExec = (ThreadPoolExecutor)this.executorService;
                int corePoolSize = threadPoolExec.getCorePoolSize();
                int maxPoolSize = threadPoolExec.getMaximumPoolSize();
                int poolSize = threadPoolExec.getPoolSize();
                int queueSize = threadPoolExec.getQueue().size();
                StringBuilder sb = new StringBuilder();
                sb.append("\u7ebf\u7a0b\u6c60\u4fe1\u606f:\r\n");
                sb.append("corePoolSize:");
                sb.append(corePoolSize);
                sb.append("\r\n");
                sb.append("maxPoolSize:");
                sb.append(maxPoolSize);
                sb.append("\r\n");
                sb.append("poolSize:");
                sb.append(poolSize);
                sb.append("\r\n");
                sb.append("queueSize:");
                sb.append(queueSize);
                sb.append("\r\n");
                logger.error(sb.toString());
            }
        }

        @Override
        public void accept(final String address, final byte[] message) throws Exception {
            this.printThreadPoolInfo();
            try {
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        CommController.this.messageDispatcher.handleMessage(address, message);
                    }
                });
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                if (this.executorService instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor threadPoolExec = (ThreadPoolExecutor)this.executorService;
                    int corePoolSize = threadPoolExec.getCorePoolSize();
                    int maxPoolSize = threadPoolExec.getMaximumPoolSize();
                    int poolSize = threadPoolExec.getPoolSize();
                    int queueSize = threadPoolExec.getQueue().size();
                    StringBuilder sb = new StringBuilder();
                    sb.append("\u7ebf\u7a0b\u6c60\u4fe1\u606f:\r\n");
                    sb.append("corePoolSize:");
                    sb.append(corePoolSize);
                    sb.append("\r\n");
                    sb.append("maxPoolSize:");
                    sb.append(maxPoolSize);
                    sb.append("\r\n");
                    sb.append("poolSize:");
                    sb.append(poolSize);
                    sb.append("\r\n");
                    sb.append("queueSize:");
                    sb.append(queueSize);
                    sb.append("\r\n");
                    logger.error(sb.toString());
                }
                throw new Exception(e);
            }
        }
    }
}

