/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.MessageDispatcher;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.MessageType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import java.util.Map;

public class CallbackContext
implements ProtocolConstants {
    private String encoding = "UTF-8";
    private String source;
    private String destination;
    private String messageId;
    private MessageDispatcher dispatcher;

    CallbackContext(String source, String destination, String messageId, MessageDispatcher dispatcher) {
        this.source = source;
        this.destination = destination;
        this.messageId = messageId;
        this.dispatcher = dispatcher;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean callback(Message message) throws Exception {
        if (this.messageId == null) {
            return false;
        }
        message.setHeader("msgType", MessageType.Response.value());
        message.setHeader("des", this.source);
        message.setHeader("src", this.destination);
        message.setHeader("id", this.messageId);
        this.dispatcher.sendMessage(this.source, message);
        return true;
    }

    public boolean callback(Map<String, String> headers, Object data, ContentType contentType) throws Exception {
        Message message = new Message();
        message.setHeader("statusCode", "200");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                message.setHeader(entry.getKey(), entry.getValue());
            }
        }
        message.setHeader("type", contentType.value());
        message.setData(data);
        return this.callback(message);
    }

    public boolean callback(Object data, ContentType contentType) throws Exception {
        return this.callback(null, data, contentType);
    }

    public boolean error(Object data, ContentType contentType) throws Exception {
        Message message = new Message();
        message.setHeader("statusCode", "500");
        message.setHeader("type", contentType.value());
        message.setData(data);
        return this.callback(message);
    }

    public boolean report(Object data, ContentType contentType) throws Exception {
        Message message = new Message();
        message.setHeader("statusCode", "100");
        message.setHeader("type", contentType.value());
        message.setData(data);
        return this.callback(message);
    }
}

