/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.utils;

import java.lang.reflect.Array;

public class ObjectConvert {
    private static char ARRAY_START = (char)91;
    private static char ARRAY_END = (char)93;
    private static String ARRAY_SPLITOR = ",";

    public static <T> T convert(Object src, Class<T> expectType) throws Exception {
        if (src == null) {
            return null;
        }
        Class<?> srcType = src.getClass();
        if (srcType.equals(expectType)) {
            return (T)src;
        }
        String str = ObjectConvert.object2Str(src);
        Object obj = ObjectConvert.str2Object(str, expectType);
        return (T)obj;
    }

    public static String object2Str(Object param) throws Exception {
        if (param == null) {
            return null;
        }
        Class<?> clazz = param.getClass();
        String res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            res = param.toString();
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            res = param.toString();
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            res = param.toString();
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            res = param.toString();
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            String s = param.toString();
            res = ObjectConvert.converExponentFormatStr(s);
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            String s = param.toString();
            res = ObjectConvert.converExponentFormatStr(s);
        } else {
            res = Character.TYPE == clazz || Character.class == clazz ? param.toString() : (Boolean.TYPE == clazz || Boolean.class == clazz ? param.toString() : (CharSequence.class.isAssignableFrom(clazz) ? param.toString() : param.toString()));
        }
        return res;
    }

    private static String converExponentFormatStr(String s) {
        String res = s;
        int index = s.toUpperCase().indexOf(69);
        if (index != -1) {
            int exponent = Integer.parseInt(s.substring(index + 1));
            int doitIndex = s.indexOf(46);
            String intPart = s.substring(0, doitIndex);
            String doitPart = doitIndex != -1 ? s.substring(doitIndex + 1, index) : "";
            StringBuilder sb = new StringBuilder();
            if (exponent > 0) {
                sb.append(intPart);
                int size = doitPart.length();
                if (exponent == size) {
                    sb.append(doitPart);
                } else if (exponent < size) {
                    String numPart = doitPart.substring(0, exponent);
                    sb.append(numPart);
                    sb.append(".");
                    String decPart = doitPart.substring(exponent);
                    sb.append(decPart);
                } else {
                    sb.append(doitPart);
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                }
            } else {
                int size = intPart.length();
                if ((exponent *= -1) == size) {
                    sb.append(intPart);
                    sb.append(doitPart);
                } else if (exponent < size) {
                    int splitIndex = size - exponent;
                    sb.append(intPart.substring(0, splitIndex));
                    sb.append(".");
                    sb.append(intPart.substring(splitIndex));
                    sb.append(doitPart);
                } else {
                    sb.append("0.");
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                    sb.append(intPart);
                    sb.append(doitPart);
                }
            }
            res = sb.toString();
        }
        return res;
    }

    public static Object str2Object(String src, String expectedType) {
        Object res = null;
        if ("byte".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Byte.valueOf(src);
            }
        } else if ("short".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Short.valueOf(src);
            }
        } else if ("int".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Integer.valueOf(src);
            }
        } else if ("long".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Long.valueOf(src);
            }
        } else if ("float".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Float.valueOf(src);
            }
        } else if ("double".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Double.valueOf(src);
            }
        } else if ("char".equalsIgnoreCase(expectedType)) {
            res = Character.valueOf(src.charAt(0));
        } else if ("boolean".equalsIgnoreCase(expectedType)) {
            if (src.length() > 0) {
                res = Boolean.parseBoolean(src);
            }
        } else {
            res = src;
        }
        return res;
    }

    public static Object str2Object(String src, Class<?> clazz) throws Exception {
        if (src == null) {
            return null;
        }
        Class<?> srcClazz = src.getClass();
        if (clazz == srcClazz) {
            return src;
        }
        Object res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            res = String.class == srcClazz ? Byte.valueOf(src) : (Byte)res;
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            res = String.class == srcClazz ? Short.valueOf(src) : (Short)res;
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            res = String.class == srcClazz ? Integer.valueOf(src) : (Integer)res;
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            res = String.class == srcClazz ? Long.valueOf(src) : (Long)res;
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            res = String.class == srcClazz ? Float.valueOf(src) : (Float)res;
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            res = String.class == srcClazz ? Double.valueOf(src) : (Double)res;
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            res = String.class == srcClazz ? Double.valueOf(src) : (Double)res;
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            res = String.class == srcClazz ? Boolean.valueOf(src) : (Boolean)res;
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            res = src.toString();
        } else if (clazz.isArray()) {
            String s = src.toString();
            int startIndex = s.indexOf(ARRAY_START);
            int endIndex = s.indexOf(ARRAY_END);
            String content = s.substring(startIndex + 1, endIndex);
            String[] array = content.split(ARRAY_SPLITOR);
            Class<?> componentType = clazz.getComponentType();
            int size = array.length;
            Object[] resArray = (Object[])Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                resArray[i] = ObjectConvert.str2Object(array[i], componentType);
            }
            res = resArray;
        }
        return res;
    }
}

