/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteUtil {
    private static Logger logger = LoggerFactory.getLogger(ByteUtil.class);
    private static String CHARSET_NAME = "UTF-8";

    public static byte[] long2byteArray(long logVal) {
        byte[] res = new byte[]{(byte)(logVal >> 56 & 0xFFL), (byte)(logVal >> 48 & 0xFFL), (byte)(logVal >> 40 & 0xFFL), (byte)(logVal >> 32 & 0xFFL), (byte)(logVal >> 24 & 0xFFL), (byte)(logVal >> 16 & 0xFFL), (byte)(logVal >> 8 & 0xFFL), (byte)(logVal & 0xFFL)};
        return res;
    }

    public static long byteArray2Long(byte[] buffer, int offset) {
        long n = 0L;
        long m = 0L;
        m = buffer[offset];
        m &= 0xFFL;
        n |= (m <<= 56);
        m = buffer[offset + 1];
        m &= 0xFFL;
        n |= (m <<= 48);
        m = buffer[offset + 2];
        m &= 0xFFL;
        n |= (m <<= 40);
        m = buffer[offset + 3];
        m &= 0xFFL;
        n |= (m <<= 32);
        m = buffer[offset + 4];
        m &= 0xFFL;
        n |= (m <<= 24);
        m = buffer[offset + 5];
        m &= 0xFFL;
        n |= (m <<= 16);
        m = buffer[offset + 6];
        m &= 0xFFL;
        n |= (m <<= 8);
        m = buffer[offset + 7];
        return n |= (m &= 0xFFL);
    }

    public static byte[] int2byteArray(int intVal) {
        byte[] res = new byte[]{(byte)(intVal >> 24 & 0xFF), (byte)(intVal >> 16 & 0xFF), (byte)(intVal >> 8 & 0xFF), (byte)(intVal & 0xFF)};
        return res;
    }

    public static int byteArray2Int(byte[] buffer, int offset) {
        int n = 0;
        n |= buffer[offset] << 24 & 0xFF000000;
        n |= buffer[offset + 1] << 16 & 0xFF0000;
        n |= buffer[offset + 2] << 8 & 0xFF00;
        return n |= buffer[offset + 3] & 0xFF;
    }

    public static byte[] short2byteArray(short shortVal) {
        byte[] res = new byte[]{(byte)(shortVal >> 8 & 0xFF), (byte)(shortVal & 0xFF)};
        return res;
    }

    public static short byteArray2Short(byte[] buffer, int offset) {
        short n = 0;
        n = (short)(n | buffer[offset + 0] << 8 & 0xFF00);
        n = (short)(n | buffer[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] str2Bytes(String s) {
        if (s != null) {
            try {
                byte[] bytes = s.getBytes(CHARSET_NAME);
                return bytes;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new byte[0];
    }

    public static String bytes2Str(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, offset, len, CHARSET_NAME);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String bytes2Str(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String s = ByteUtil.bytes2Str(bytes, 0, bytes.length);
        return s;
    }

    public static int readBytes(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int count;
        int expectCount = len;
        while ((count = in.read(buffer, offset, expectCount)) != -1) {
            offset += count;
            if ((expectCount -= count) > 0) continue;
        }
        int readLen = len - expectCount;
        return readLen;
    }

    public static byte[] map2Bytes(Map<String, String> map) throws Exception {
        if (map == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        for (String key : map.keySet()) {
            byte[] bytes = ByteUtil.str2Bytes(key);
            byte[] lenBytes = ByteUtil.int2byteArray(bytes.length);
            byteOut.write(lenBytes);
            byteOut.write(bytes);
            String value = map.get(key);
            bytes = ByteUtil.str2Bytes(value);
            lenBytes = ByteUtil.int2byteArray(bytes.length);
            byteOut.write(lenBytes);
            byteOut.write(bytes);
        }
        byte[] bytes = byteOut.toByteArray();
        return bytes;
    }

    public static Map<String, String> bytes2Map(byte[] bytes) {
        Map<String, String> map = ByteUtil.bytes2Map(bytes, 0, bytes.length);
        return map;
    }

    public static Map<String, String> bytes2Map(byte[] bytes, int offset, int length) {
        if (offset == -1) {
            offset = 0;
        }
        int limit = 0;
        limit = length == -1 ? bytes.length : offset + length;
        HashMap<String, String> params = new HashMap<String, String>();
        while (offset < limit) {
            int len = ByteUtil.byteArray2Int(bytes, offset);
            String key = ByteUtil.bytes2Str(bytes, offset += 4, len);
            offset += len;
            len = ByteUtil.byteArray2Int(bytes, offset);
            String value = ByteUtil.bytes2Str(bytes, offset += 4, len);
            offset += len;
            params.put(key, value);
        }
        return params;
    }

    public static String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            String s = Integer.toHexString(bytes[i] & 0xFF);
            if (s.length() < 2) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hex2Bytes(String src) {
        byte[] b2 = new byte[src.length() / 2];
        for (int i = 0; i < b2.length; ++i) {
            b2[i] = (byte)Integer.parseInt(src.substring(i * 2, i * 2 + 2), 16);
        }
        return b2;
    }
}

