/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.thread;

import cn.com.yusys.fox.server.Settings;
import cn.com.yusys.fox.server.thread.FXThreadFactory;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FXExecutorFactory {
    private static ExecutorService defaultExecutorService;

    public static synchronized ExecutorService getDefaultCachedThreadPool() {
        if (defaultExecutorService == null) {
            defaultExecutorService = FXExecutorFactory.newCachedThreadPool();
        }
        return defaultExecutorService;
    }

    public static ExecutorService newCachedThreadPool() {
        Settings settings = Settings.getInstance();
        int corePoolSize = settings.getCorePoolSize();
        int maximumPoolSize = settings.getMaxPoolSize();
        int keepAliveTime = settings.getKeepAliveTime();
        int queueSize = settings.getQueueSize();
        AbstractQueue workQueue = null;
        workQueue = queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)workQueue), new FXThreadFactory());
        return executor;
    }

    public static ExecutorService newCachedThreadPool(String prefixName, int corePoolSize, int maximumPoolSize, int keepAliveTime, int queueSize) {
        AbstractQueue workQueue = null;
        workQueue = queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)workQueue), new FXThreadFactory(prefixName));
        return executor;
    }
}

