/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server.acceptor;

import cn.com.yusys.fox.server.IAcceptListener;
import cn.com.yusys.fox.server.IConnectionStateListener;
import cn.com.yusys.fox.server.IMessageChannel;
import cn.com.yusys.fox.server.Settings;
import cn.com.yusys.fox.server.acceptor.MessageProtocolCodecFactory;
import cn.com.yusys.fox.server.constant.ConnectionState;
import cn.com.yusys.fox.server.utils.ByteUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaServerMsgChannel
implements IMessageChannel {
    private static Logger logger = LoggerFactory.getLogger(MinaServerMsgChannel.class);
    private static final String ADDRESS = "address";
    private static final String CONNECTOR = "connector";
    private static final byte HEART_REQUEST_MARK = 0;
    private static final byte HEART_RESPONSE_MARK = 1;
    private static final byte SEC_INSTALL_MARK = 2;
    private IAcceptListener acceptListener;
    private List<IConnectionStateListener> connectionStateListeners = new ArrayList<IConnectionStateListener>();
    private ReentrantReadWriteLock listenerLock = new ReentrantReadWriteLock();
    private Lock sessionCreatLock = new ReentrantLock();
    private Map<String, IoSession> sessionMap = new ConcurrentHashMap<String, IoSession>();
    private int soLingerTime = 0;
    private long connectTimeout = 30000L;
    private int autoDisconnectTimeout = 60000;
    private int pingTimeout = 300;
    private SocketAcceptor acceptor;
    private String host;
    private int port;
    private String localAddress = null;
    private boolean isStarted = false;
    private String securityPolicy = "none";
    private IoHandler acceptHandler = new IoHandler(){
        private String LAST_HEART_TIME = "lastHeartTime";

        public void sessionCreated(IoSession session) throws Exception {
            SocketAddress socketAddress = session.getRemoteAddress();
            int checkInterval = MinaServerMsgChannel.this.autoDisconnectTimeout / 4000;
            SocketSessionConfig cfg = (SocketSessionConfig)session.getConfig();
            cfg.setSoLinger(MinaServerMsgChannel.this.soLingerTime);
            cfg.setTcpNoDelay(true);
            cfg.setIdleTime(IdleStatus.BOTH_IDLE, checkInterval);
            String address = MinaServerMsgChannel.this.socketAddress2Str(socketAddress);
            int index = address.indexOf(58);
            String ip = address.substring(0, index);
            String port = address.substring(index + 1);
            if (ip.equals("127.0.0.1")) {
                String localAddress = MinaServerMsgChannel.this.getLocalAddress();
                index = localAddress.indexOf(58);
                address = localAddress.substring(0, index) + ":" + port;
            }
            session.setAttribute((Object)MinaServerMsgChannel.ADDRESS, (Object)address);
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("toAddress", MinaServerMsgChannel.this.getLocalAddress());
            metadata.put("fromAddress", address);
            metadata.put("securityPolicy", MinaServerMsgChannel.this.securityPolicy);
            byte[] buffer = ByteUtil.map2Bytes(metadata);
            session.write((Object)buffer);
            MinaServerMsgChannel.this.sessionMap.put(address, session);
            MinaServerMsgChannel.this.fireConnectionStateListener(ConnectionState.CONNECTED, address, null);
            if (logger.isDebugEnabled()) {
                logger.debug("\u63a5\u53d7\u8fde\u63a5[" + address + "]\uff0c\u5f53\u524d\u65b9\u5f0f\u8fde\u63a5\u7684\u8fde\u63a5\u6570\u4e3a\uff1a" + MinaServerMsgChannel.this.sessionMap.size());
            }
        }

        public void sessionOpened(IoSession session) throws Exception {
        }

        public void sessionClosed(IoSession session) throws Exception {
            String address = (String)session.getAttribute((Object)MinaServerMsgChannel.ADDRESS);
            if (address != null) {
                MinaServerMsgChannel.this.sessionMap.remove(address);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u79fb\u9664\u8fde\u63a5[" + address + "]\uff0c\u5f53\u524d\u65b9\u5f0f\u8fde\u63a5\u7684\u8fde\u63a5\u6570\u4e3a\uff1a" + MinaServerMsgChannel.this.sessionMap.size());
                }
                MinaServerMsgChannel.this.fireConnectionStateListener(ConnectionState.DISCONNECTED, address, null);
            }
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            long curTime = System.currentTimeMillis();
            long idleTime = curTime - session.getLastIoTime();
            long lastHeartTime = (Long)session.getAttribute((Object)this.LAST_HEART_TIME, (Object)0L);
            long heartIdleTime = curTime - lastHeartTime;
            if (idleTime > (long)MinaServerMsgChannel.this.autoDisconnectTimeout && heartIdleTime > (long)MinaServerMsgChannel.this.autoDisconnectTimeout) {
                String address = (String)session.getAttribute((Object)MinaServerMsgChannel.ADDRESS);
                session.close(false);
                if (logger.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("accept\u8fde\u63a5[");
                    sb.append(address);
                    sb.append("]\u7a7a\u95f2\u65f6\u95f4\u5927\u4e8e\u81ea\u52a8\u65ad\u5f00\u65f6\u95f4,\u670d\u52a1\u5668\u4e3b\u52a8\u65ad\u5f00\u8fde\u63a5,idleTime[");
                    sb.append(idleTime);
                    sb.append("],heartIdleTime[");
                    sb.append(heartIdleTime);
                    sb.append("]");
                    logger.debug(sb.toString());
                }
                return;
            }
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            String address = (String)session.getAttribute((Object)MinaServerMsgChannel.ADDRESS);
            MinaServerMsgChannel.this.fireConnectionStateListener(ConnectionState.EXCEPTION, address, cause);
            session.close(true);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            byte[] msg = (byte[])message;
            if (msg.length == 1) {
                if (msg[0] == 0) {
                    session.write((Object)new byte[]{1});
                    long lastHeartTime = System.currentTimeMillis();
                    session.setAttribute((Object)this.LAST_HEART_TIME, (Object)lastHeartTime);
                    if (logger.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("\u6536\u5230\u5fc3\u8df3\u6765\u6e90:");
                        sb.append(session.getAttribute((Object)MinaServerMsgChannel.ADDRESS));
                        logger.debug(sb.toString());
                    }
                    return;
                }
                if (msg[0] == 2) {
                    return;
                }
            }
            String address = (String)session.getAttribute((Object)MinaServerMsgChannel.ADDRESS);
            MinaServerMsgChannel.this.acceptListener.accept(address, msg);
        }

        public void messageSent(IoSession session, Object message) throws Exception {
        }

        public void inputClosed(IoSession ioSession) throws Exception {
        }
    };

    public int getConnectionCount() {
        return this.sessionMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnitTimeConnectedClientCount(long currentTime, long unitTime) {
        int unitTimeConnectionCount = 0;
        Map<String, IoSession> map = this.sessionMap;
        synchronized (map) {
            for (IoSession session : this.sessionMap.values()) {
                long sesstionStamp = session.getCreationTime();
                if (sesstionStamp > currentTime || sesstionStamp < currentTime - unitTime) continue;
                ++unitTimeConnectionCount;
            }
        }
        return unitTimeConnectionCount;
    }

    @Override
    public void start() {
        this.loadConfig();
        int numCpu = Runtime.getRuntime().availableProcessors();
        if (numCpu > 5) {
            numCpu = 5;
        }
        this.acceptor = new NioSocketAcceptor((Executor)Executors.newCachedThreadPool(), (IoProcessor)new SimpleIoProcessorPool(NioProcessor.class, numCpu + 1));
        this.acceptor.setReuseAddress(true);
        this.acceptor.getFilterChain().addFirst("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MessageProtocolCodecFactory()));
        this.acceptor.setHandler(this.acceptHandler);
        try {
            if (this.host != null) {
                this.acceptor.bind((SocketAddress)new InetSocketAddress(this.host, this.port));
            } else {
                this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
            }
            this.isStarted = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("MinaMessageChannel\u542f\u52a8\u5931\u8d25, cause by " + e.getMessage(), e);
        }
    }

    private void loadConfig() {
        Settings settings = Settings.getInstance();
        this.port = settings.getPort();
        this.autoDisconnectTimeout = settings.getAutoDisconnectTimeout();
        this.pingTimeout = settings.getPingTimeout();
        this.securityPolicy = settings.getSecurityPolicy();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void disconnect(String address) {
        IoSession session = this.sessionMap.get(address);
        session.close(true);
    }

    @Override
    public void stop() {
        if (this.sessionMap.size() > 0) {
            String[] items;
            for (String key : items = this.sessionMap.keySet().toArray(new String[0])) {
                IoSession session = this.sessionMap.get(key);
                session.close(true);
                NioSocketConnector connector = (NioSocketConnector)session.getAttribute((Object)CONNECTOR);
                if (connector == null) continue;
                connector.dispose();
            }
        }
        this.acceptor.dispose();
        this.isStarted = false;
    }

    @Override
    public void setAcceptListener(IAcceptListener acceptListener) {
        if (acceptListener == null) {
            throw new IllegalArgumentException("acceptListener can not be null");
        }
        this.acceptListener = acceptListener;
    }

    @Override
    public void addConnectionStateListener(IConnectionStateListener connectionStateListener) {
        if (connectionStateListener == null) {
            return;
        }
        this.listenerLock.writeLock().lock();
        try {
            this.connectionStateListeners.add(connectionStateListener);
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }

    @Override
    public void addConnectionStateListener(int index, IConnectionStateListener connectionStateListener) {
        if (connectionStateListener == null) {
            return;
        }
        this.listenerLock.writeLock().lock();
        try {
            this.connectionStateListeners.add(index, connectionStateListener);
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }

    @Override
    public void removeConnectionStateListener(IConnectionStateListener connectionStateListener) {
        if (connectionStateListener == null) {
            return;
        }
        this.listenerLock.writeLock().lock();
        try {
            this.connectionStateListeners.remove(connectionStateListener);
        }
        finally {
            this.listenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionStateListener(ConnectionState state, String remoteAddress, Object data) {
        this.listenerLock.readLock().lock();
        try {
            int size = this.connectionStateListeners.size();
            for (int i = 0; i < size; ++i) {
                IConnectionStateListener listener = this.connectionStateListeners.get(i);
                try {
                    listener.onMessage(state, remoteAddress, data);
                    continue;
                }
                catch (Throwable cause) {
                    logger.error(cause.getMessage(), cause);
                }
            }
        }
        finally {
            this.listenerLock.readLock().unlock();
        }
    }

    @Override
    public String getLocalAddress() {
        if (this.localAddress == null) {
            int port = this.acceptor.getLocalAddress().getPort();
            try {
                String localip = null;
                String netip = null;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                boolean finded = false;
                block2: while (netInterfaces.hasMoreElements() && !finded) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> address = ni.getInetAddresses();
                    while (address.hasMoreElements()) {
                        ip = address.nextElement();
                        if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                            netip = ip.getHostAddress();
                            finded = true;
                            continue block2;
                        }
                        if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                        localip = ip.getHostAddress();
                    }
                }
                if (netip != null && !"".equals(netip)) {
                    this.localAddress = netip + ":" + port;
                    return this.localAddress;
                }
                if (localip == null) {
                    localip = "127.0.0.1";
                }
                this.localAddress = localip + ":" + port;
                return this.localAddress;
            }
            catch (SocketException e) {
                logger.error("\u672c\u5730IP\u6ca1\u6709\u627e\u5230", (Throwable)e);
            }
        }
        return this.localAddress;
    }

    @Override
    public String[] getRemoteAddress() {
        String[] address = this.sessionMap.keySet().toArray(new String[0]);
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReachable(SocketAddress socketAddress, String address) {
        Socket socket = new Socket();
        try {
            socket.setReuseAddress(true);
            socket.setSoLinger(true, this.soLingerTime);
            socket.connect(socketAddress, this.pingTimeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.warn("address [" + address + "] is not reachable");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isConnected(String address) {
        boolean res = this.sessionMap.containsKey(address);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoSession createSession(final String address) throws Exception {
        NioSocketConnector connector;
        block18: {
            if (logger.isDebugEnabled()) {
                logger.debug("\u5f00\u59cb\u521b\u5efaconnect\u8fde\u63a5");
            }
            connector = null;
            this.sessionCreatLock.lock();
            try {
                IoSession session = this.sessionMap.get(address);
                if (session != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u83b7\u53d6\u5df2\u6709connect\u8fde\u63a5");
                    }
                    IoSession ioSession = session;
                    return ioSession;
                }
                SocketAddress socketAddress = this.str2SocketAddress(address);
                boolean isReachable = this.isReachable(socketAddress, address);
                if (!isReachable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u76ee\u6807\u5730\u5740\u65e0\u6cd5\u8fde\u901a");
                    }
                    IoSession ioSession = null;
                    return ioSession;
                }
                connector = new NioSocketConnector();
                connector.getFilterChain().addFirst("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MessageProtocolCodecFactory()));
                final Boolean[] initialized = new Boolean[]{false};
                final Object initLock = new Object();
                final int conAutoDisconnectTimeout = this.autoDisconnectTimeout;
                final int checkInterval = conAutoDisconnectTimeout / 4000;
                connector.setHandler(new IoHandler(){

                    public void sessionCreated(IoSession session) throws Exception {
                    }

                    public void sessionOpened(IoSession session) throws Exception {
                    }

                    public void sessionClosed(IoSession session) throws Exception {
                        try {
                            NioSocketConnector connector = (NioSocketConnector)session.getAttribute((Object)MinaServerMsgChannel.CONNECTOR);
                            if (connector != null) {
                                connector.dispose();
                            }
                        }
                        catch (Throwable e) {
                            logger.error(e.getMessage(), e);
                        }
                        String s = (String)session.getAttribute((Object)MinaServerMsgChannel.ADDRESS);
                        if (s != null) {
                            MinaServerMsgChannel.this.sessionMap.remove(s);
                            if (logger.isDebugEnabled()) {
                                logger.debug("\u79fb\u9664connect\u8fde\u63a5[" + address + "]\uff0c\u5f53\u524d\u65b9\u5f0f\u8fde\u63a5\u7684\u8fde\u63a5\u6570\u4e3a\uff1a" + MinaServerMsgChannel.this.sessionMap.size());
                            }
                            MinaServerMsgChannel.this.fireConnectionStateListener(ConnectionState.DISCONNECTED, address, null);
                        }
                    }

                    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
                        if (!initialized[0].booleanValue() || !session.isConnected()) {
                            return;
                        }
                        long idleTime = System.currentTimeMillis() - session.getLastIoTime();
                        if (idleTime > (long)conAutoDisconnectTimeout) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("connect\u8fde\u63a5[" + address + "]\u7a7a\u95f2\u65f6\u95f4\u5927\u4e8e\u81ea\u52a8\u65ad\u5f00\u65f6\u95f4,\u670d\u52a1\u5668\u4e3b\u52a8\u65ad\u5f00\u8fde\u63a5");
                            }
                            session.close(true);
                            return;
                        }
                        if (idleTime > (long)checkInterval) {
                            session.write((Object)new byte[]{0});
                        }
                    }

                    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                        String address2 = MinaServerMsgChannel.this.socketAddress2Str(session.getRemoteAddress());
                        MinaServerMsgChannel.this.fireConnectionStateListener(ConnectionState.EXCEPTION, address2, cause);
                        session.close(true);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(IoSession session, Object message) throws Exception {
                        byte[] msg = (byte[])message;
                        if (!initialized[0].booleanValue()) {
                            String securityPolicy = "none";
                            try {
                                Map<String, String> metadata = ByteUtil.bytes2Map(msg);
                                securityPolicy = metadata.get("securityPolicy");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (securityPolicy.equals("by-client")) {
                                session.write((Object)new byte[]{2});
                            } else if (securityPolicy.equals("by-server")) {
                                // empty if block
                            }
                            Object object = initLock;
                            synchronized (object) {
                                initialized[0] = true;
                                initLock.notifyAll();
                            }
                            return;
                        }
                        if (msg.length == 1) {
                            if (msg[0] == 1) {
                                return;
                            }
                            if (msg[0] == 2) {
                                return;
                            }
                        }
                    }

                    public void messageSent(IoSession session, Object message) throws Exception {
                    }

                    public void inputClosed(IoSession ioSession) throws Exception {
                    }
                });
                ConnectFuture cf = connector.connect(socketAddress);
                cf.await(this.connectTimeout);
                if (!cf.isConnected()) break block18;
                session = cf.getSession();
                SocketSessionConfig cfg = (SocketSessionConfig)session.getConfig();
                cfg.setSoLinger(this.soLingerTime);
                cfg.setTcpNoDelay(true);
                cfg.setIdleTime(IdleStatus.BOTH_IDLE, checkInterval);
                Object object = initLock;
                synchronized (object) {
                    if (!initialized[0].booleanValue()) {
                        initLock.wait(30000L);
                    }
                }
                session.setAttribute((Object)CONNECTOR, (Object)connector);
                session.setAttribute((Object)ADDRESS, (Object)address);
                this.sessionMap.put(address, session);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u521b\u5efaconnect\u8fde\u63a5\uff0c\u5f53\u524d\u65b9\u5f0f\u8fde\u63a5\u7684\u8fde\u63a5\u6570\u4e3a\uff1a" + this.sessionMap.size());
                }
                object = session;
                return object;
            }
            catch (Throwable cause) {
                logger.error(cause.getMessage(), cause);
            }
            finally {
                this.sessionCreatLock.unlock();
            }
        }
        if (connector != null && !connector.isDisposed()) {
            connector.dispose();
        }
        return null;
    }

    @Override
    public void send(String destination, byte[] message) throws Exception {
        IoSession session = null;
        session = this.sessionMap.get(destination);
        try {
            if ((session == null || session.isClosing()) && (session = this.createSession(destination)) == null) {
                String errorMsg = "\u8bd5\u56fe\u8fde\u63a5\u76ee\u6807\u5730\u5740[" + destination + "]\u5931\u8d25";
                logger.error(errorMsg);
                throw new Exception(errorMsg);
            }
            session.write((Object)message);
        }
        catch (Throwable e) {
            if (session != null) {
                logger.error("\u76ee\u6807\u5730\u5740[" + destination + "]\u5f02\u5e38");
                session.close(true);
            } else {
                logger.error("\u76ee\u6807\u5730\u5740[" + destination + "]\u4e0d\u5b58\u5728");
            }
            this.fireConnectionStateListener(ConnectionState.EXCEPTION, destination, null);
            throw new Exception(e.getMessage(), e);
        }
    }

    private String socketAddress2Str(SocketAddress socketAddress) {
        String address = socketAddress.toString().substring(1);
        return new String(address);
    }

    private SocketAddress str2SocketAddress(String address) {
        int index = address.indexOf(58);
        String addr = address.substring(0, index);
        int port = Integer.parseInt(address.substring(index + 1));
        return new InetSocketAddress(addr, port);
    }

    public String getLocalPhysicalAddress() {
        return this.getLocalAddress();
    }

    public String getLocalLogicalAddr() {
        String localAbsoluteAddr = this.getLocalAddress();
        return localAbsoluteAddr;
    }

    public String[] getRemoteLogicalAddr() {
        String localAddr = this.getLocalLogicalAddr();
        String[] remoteAddr = this.getRemoteAddress();
        for (int i = 0; i < remoteAddr.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(remoteAddr[i]);
            sb.append("|");
            sb.append(localAddr);
            remoteAddr[i] = sb.toString();
        }
        return remoteAddr;
    }

    @Override
    public void disconnect() {
        Iterator<Map.Entry<String, IoSession>> iter = this.sessionMap.entrySet().iterator();
        while (iter.hasNext()) {
            IoSession session = iter.next().getValue();
            session.close(true);
        }
    }
}

