/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Message {
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected Object data;

    public Message() {
    }

    public Message(Map<String, List<String>> headers, Object data) {
        this.headers = headers;
        this.data = data;
    }

    public void setHeader(String key, String value) {
        if (key == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.headers.put(key, list);
    }

    public void addHeader(String key, String value) {
        if (key == null) {
            return;
        }
        List<String> list = this.headers.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(key, list);
        }
        list.add(value);
    }

    public String getHeader(String key) {
        if (key == null) {
            return null;
        }
        List<String> list = this.headers.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        String value = (String)list.stream().reduce((sum, item) -> {
            sum = String.format("%s, %s", sum, item);
            return sum;
        }).get();
        return value;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) continue;
            String value = (String)list.stream().reduce((sum, item) -> {
                sum = String.format("%s, %s", sum, item);
                return sum;
            }).get();
            map.put(entry.getKey(), value);
        }
        return map;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Message clone() {
        HashMap<String, List<String>> cloneHeaders = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            ArrayList cloneList = new ArrayList();
            cloneList.addAll(entry.getValue());
            cloneHeaders.put(entry.getKey(), cloneList);
        }
        Message cloneMessage = new Message();
        cloneMessage.headers = cloneHeaders;
        cloneMessage.data = this.data;
        return cloneMessage;
    }

    public class Item {
        public String key;
        public String value;

        public Item() {
        }

        public Item(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Item clone() {
            return new Item(this.key, this.value);
        }
    }
}

