/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public class FoxHttpHandlerAdapter
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(FoxHttpHandlerAdapter.class);
    private HttpHandler httpHandler;
    private ReactiveWebServerApplicationContext applicationContext;

    public FoxHttpHandlerAdapter(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public Mono<Void> request(ServerHttpRequest foxRequest, ServerHttpResponse foxResponse) {
        try {
            return this.httpHandler.handle(foxRequest, foxResponse).doOnError(ex -> logger.trace(foxRequest.getPath() + "Failed to complete: " + ex.getMessage())).doOnSuccess(aVoid -> logger.trace(foxRequest.getPath() + "Handling completed"));
        }
        catch (Exception ex2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get request URI: " + ex2.getMessage());
            }
            foxResponse.setStatusCode(HttpStatus.BAD_REQUEST);
            return Mono.empty();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ReactiveWebServerApplicationContext)applicationContext;
        this.httpHandler = this.applicationContext.getHttpHandler();
    }
}

