/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.adapter.proxy;

import cn.com.yusys.fox.adapter.http.FXHttpServletRequest;
import cn.com.yusys.fox.adapter.http.FXHttpServletResponse;
import cn.com.yusys.fox.adapter.http.FXServletInputStream;
import cn.com.yusys.fox.adapter.proxy.Constants;
import cn.com.yusys.fox.adapter.proxy.FoxDispatcher;
import cn.com.yusys.fox.adapter.proxy.utils.ExtHeaderParser;
import cn.com.yusys.fox.server.CallbackContext;
import cn.com.yusys.fox.server.IMessageService;
import cn.com.yusys.fox.server.Message;
import cn.com.yusys.fox.server.constant.ContentType;
import cn.com.yusys.fox.server.constant.ProtocolConstants;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoxMessageService
implements IMessageService,
ProtocolConstants {
    private static Logger logger = LoggerFactory.getLogger(FoxMessageService.class);
    private File root;

    public FoxMessageService(File root) {
        this.root = root;
    }

    public void run(String source, Message message, CallbackContext context) throws Exception {
        Map<String, String> extHeaders = ExtHeaderParser.getRequestHeaders(message);
        String method = extHeaders.remove("Method");
        String path = extHeaders.remove("Path");
        String contextPath = "zuul";
        String urlString = path.startsWith("/") ? String.format("http://127.0.1.1:3160/%s%s", contextPath, path) : String.format("http://127.0.1.1:3160/%s/%s", contextPath, path);
        URL url = new URL(urlString);
        logger.info("\u8bf7\u6c42url======================" + urlString + "==========================");
        byte[] bytes = (byte[])message.getData();
        logger.info("\u8bf7\u6c42\u62a5\u6587\u5185\u5bb9======================" + new String(bytes) + "==========================");
        FXServletInputStream inputStream = new FXServletInputStream(bytes);
        extHeaders.put("Content-Length", String.valueOf(bytes.length));
        FXHttpServletRequest request = new FXHttpServletRequest(method, contextPath, url, extHeaders, inputStream, this.root);
        source = source.substring(0, source.lastIndexOf("/"));
        request.setAttribute(Constants.ClientId, source);
        FXHttpServletResponse response = new FXHttpServletResponse();
        FoxDispatcher dispatcher = new FoxDispatcher();
        Map<String, String> rspHeaders = ExtHeaderParser.getResponseHeaders(response);
        Message rspMessage = new Message();
        for (Map.Entry<String, String> entry : rspHeaders.entrySet()) {
            String extKey = String.format("%s%s", Constants.ExPrefix, entry.getKey());
            rspMessage.addHeader(extKey, entry.getValue());
        }
        byte[] rspData = response.getData();
        if (rspData.length == 0) {
            rspHeaders.put("statusCode", String.valueOf(400));
            context.callback(rspHeaders, (Object)"not find route", ContentType.String_UTF8);
            return;
        }
        logger.info("\u8fd4\u56de\u62a5\u6587\u5185\u5bb9======================" + new String(rspData) + "==========================");
        int statusCode = response.getStatus();
        rspHeaders.put("statusCode", String.valueOf(statusCode));
        context.callback(rspHeaders, (Object)response.getData(), ContentType.Binary_Array);
    }
}

