/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.adapter.http;

import cn.com.yusys.fox.adapter.utils.EncodingParser;
import cn.com.yusys.fox.adapter.utils.Query2Parameters;
import cn.com.yusys.fox.adapter.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class FXHttpServletRequest
implements HttpServletRequest {
    private Map<String, Object> attrs = new ConcurrentHashMap<String, Object>();
    private String method;
    private String contextPath;
    private URL url;
    private Map<String, String> headers;
    private Map<String, List<String>> parameters = new ConcurrentHashMap<String, List<String>>();
    private ServletInputStream in;
    private File root;

    public FXHttpServletRequest(String method, String contextPath, URL url, Map<String, String> headers, ServletInputStream in, File root) {
        this.method = method;
        this.contextPath = contextPath;
        this.url = url;
        this.headers = headers;
        this.in = in;
        this.root = root;
        if ("GET".equalsIgnoreCase(this.method)) {
            this.parameters = Query2Parameters.parser(url.getQuery());
        }
    }

    public Object getAttribute(String key) {
        return this.attrs.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        Vector v = new Vector();
        this.attrs.keySet().stream().forEach(name -> v.add(name));
        return v.elements();
    }

    public String getCharacterEncoding() {
        String contentType = this.getContentType();
        String encoding = EncodingParser.parser(contentType);
        return encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedEncodingException();
    }

    public int getContentLength() {
        String s = this.getHeader("Content-Length");
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        String contentType = this.getHeader("Content-Type");
        return contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getParameter(String key) {
        if (this.parameters == null) {
            return null;
        }
        List<String> list = this.parameters.get(key);
        if (list == null || list.isEmpty()) {
            return "";
        }
        String value = (String)list.stream().reduce((acc, item) -> {
            acc = String.format("%s, %s", acc, item);
            return acc;
        }).get();
        return value;
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> v = new Vector<String>();
        Set<String> keys = this.parameters.keySet();
        for (String key : keys) {
            v.add(key);
        }
        return v.elements();
    }

    public String[] getParameterValues(String key) {
        List<String> list = this.parameters.get(key);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getScheme() {
        return "";
    }

    public String getServerName() {
        return "Fox";
    }

    public int getServerPort() {
        return this.url.getPort();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.in));
    }

    public String getRemoteAddr() {
        return "http://127.0.0.1";
    }

    public String getRemoteHost() {
        return "127.0.0.1";
    }

    public void setAttribute(String key, Object value) {
        this.attrs.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attrs.remove(key);
    }

    public Locale getLocale() {
        return Locale.CHINA;
    }

    public Enumeration<Locale> getLocales() {
        Vector<Locale> v = new Vector<Locale>();
        v.add(Locale.CHINA);
        return v.elements();
    }

    public boolean isSecure() {
        return true;
    }

    public RequestDispatcher getRequestDispatcher(String key) {
        return null;
    }

    @Deprecated
    public String getRealPath(String path) {
        String realPath = new File("").getAbsolutePath();
        return realPath;
    }

    public int getRemotePort() {
        return 1000;
    }

    public String getLocalName() {
        return Locale.CHINA.toString();
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return -1;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public AsyncContext startAsync(ServletRequest var1, ServletResponse var2) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        String s = this.getHeader("Cookie");
        if (StringUtil.isEmpty(s)) {
            return new Cookie[0];
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String[] items = StringUtil.split(s, ",");
        for (int i = 0; i < items.length; ++i) {
            String[] ss = StringUtil.split(items[i], "=");
            cookies.add(new Cookie(ss[0], ss[1]));
        }
        return cookies.toArray(new Cookie[0]);
    }

    public long getDateHeader(String key) {
        return this.headers.size();
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public Enumeration<String> getHeaders(String key) {
        Vector<String> v = new Vector<String>();
        String s = this.headers.get(key);
        if (s == null) {
            return v.elements();
        }
        String[] ss = StringUtil.split(s, ",");
        for (int i = 0; i < ss.length; ++i) {
            v.add(ss[i]);
        }
        return v.elements();
    }

    public Enumeration<String> getHeaderNames() {
        Vector<String> v = new Vector<String>();
        for (String key : this.headers.keySet()) {
            v.add(key);
        }
        return v.elements();
    }

    public int getIntHeader(String s) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.url.getPath();
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.url.getQuery();
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.url.getPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.url.toString());
    }

    public String getServletPath() {
        return this.root.getPath();
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String s) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }
}

