/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.adapter;

import cn.com.yusys.fox.adapter.http.HttpAdapter;
import cn.com.yusys.fox.adapter.proxy.FoxMessageService;
import cn.com.yusys.fox.server.CommController;
import cn.com.yusys.fox.server.Settings;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class FoxSpringApplicationRunListener
implements SpringApplicationRunListener {
    private static Logger logger = LoggerFactory.getLogger(FoxSpringApplicationRunListener.class);
    private final SpringApplication application;
    private final String[] args;
    private HttpAdapter httpAdapter;

    public FoxSpringApplicationRunListener(SpringApplication sa, String[] args) {
        this.application = sa;
        this.args = args;
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    public void starting() {
        System.out.println("fox starting");
        if (this.httpAdapter != null) {
            return;
        }
        int socketPort = 9100;
        CommController controller = CommController.getInstance();
        if (controller.isStarted()) {
            System.out.println("Fox Server\u5df2\u7ecf\u542f\u52a8");
            return;
        }
        Settings settings = controller.getSettings();
        settings.setPort(socketPort);
        controller.start();
        File contextRoot = new File("");
        this.httpAdapter = new HttpAdapter(controller, new FoxMessageService(contextRoot));
        try {
            this.httpAdapter.init();
            System.out.println("Fox Server\u542f\u52a8\u6210\u529f\uff0c\u76d1\u542c\u7aef\u53e3:" + socketPort);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        System.out.println("fox environmentPrepared");
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        System.out.println("fox contextPrepared");
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
        System.out.println("fox contextLoaded");
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
        System.out.println("fox finished");
        this.httpAdapter.destroy();
        CommController controller = CommController.getInstance();
        controller.stop();
    }
}

