/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.fox.adapter.http;

import cn.com.yusys.fox.adapter.http.FXServletOutputStream;
import cn.com.yusys.fox.adapter.utils.EncodingParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class FXHttpServletResponse
implements HttpServletResponse {
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private ByteArrayOutputStream cacheOut = new ByteArrayOutputStream();
    private FXServletOutputStream out = new FXServletOutputStream(this.cacheOut);
    private int statusCode = 200;
    private String statusMessage = "";

    public byte[] getData() {
        return this.cacheOut.toByteArray();
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String s) {
        return false;
    }

    public String encodeURL(String s) {
        return null;
    }

    public String encodeRedirectURL(String s) {
        return null;
    }

    @Deprecated
    public String encodeUrl(String var1) {
        return "";
    }

    @Deprecated
    public String encodeRedirectUrl(String var1) {
        return "";
    }

    public void sendError(int code, String message) throws IOException {
        this.statusCode = code;
        this.statusMessage = message;
    }

    public void sendError(int code) throws IOException {
        this.statusCode = code;
    }

    public void sendRedirect(String s) throws IOException {
    }

    public void setDateHeader(String s, long l) {
    }

    public void addDateHeader(String s, long l) {
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.headers.put(name, list);
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            return;
        }
        List<String> list = this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(name, list);
        }
        list.add(value);
    }

    public void setIntHeader(String s, int i) {
        this.setHeader(s, String.valueOf(i));
    }

    public void addIntHeader(String s, int i) {
        this.addHeader(s, String.valueOf(i));
    }

    public void setStatus(int code) {
        this.statusCode = code;
    }

    public void setStatus(int code, String message) {
        this.statusCode = code;
        this.statusMessage = message;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        List<String> list = this.headers.get(name);
        String value = (String)list.stream().reduce((sum, item) -> {
            sum = String.format("%s, %s", sum, item);
            return sum;
        }).get();
        return value;
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        String contentType = this.getContentType();
        String encoding = EncodingParser.parser(contentType);
        return encoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        String encoding = this.getCharacterEncoding();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.out), encoding));
        return writer;
    }

    public void setCharacterEncoding(String s) {
    }

    public void setContentLength(int length) {
        this.setHeader("Content-Length", String.valueOf(length));
    }

    public void setContentLengthLong(long length) {
        this.setHeader("Content-Length", String.valueOf(length));
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void setBufferSize(int i) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale locale) {
    }

    public Locale getLocale() {
        return null;
    }
}

