/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.util;

import cn.com.yusys.yusp.commons.session.util.SecurityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.jwt.JwtHelper;

public class AuthUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthUtils.class);
    private static final int TOKEN_TYPE_BEARER_LENGTH = "Bearer".length() + 1;

    private AuthUtils() {
    }

    public static Map getParsedAccessTokenMap() {
        String accessToken = SecurityUtils.getCurrentUserToken();
        try {
            Map resMap = (Map)new ObjectMapper().readValue(JwtHelper.decode((String)accessToken).getClaims(), Map.class);
            resMap.put("PARSE_TOKEN", accessToken);
            return resMap;
        }
        catch (Exception e) {
            log.error("Failed to parse token:{}", (Object)e.getMessage());
            throw new RuntimeException("Token cannot be parsed correctly");
        }
    }

    public static String getCurrentUserLogin(@NotNull Map<String, Object> parsedTokenMa) {
        Object loginCode = parsedTokenMa.get("user_name");
        if (loginCode != null) {
            return loginCode.toString();
        }
        return null;
    }

    public static String getCurrentUserLoginSYS(@NotNull Map<String, Object> parsedTokenMap) {
        Object sysId = parsedTokenMap.get("sysId");
        if (sysId != null) {
            return sysId.toString();
        }
        return null;
    }

    public static String getCurrentUserToken(@NotNull Map<String, Object> parsedTokenMap) {
        Object accessToken = parsedTokenMap.get("PARSE_TOKEN");
        if (accessToken != null) {
            return accessToken.toString();
        }
        return null;
    }
}

