/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.common.user.MenuContr;
import cn.com.yusys.yusp.common.user.User;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.oca.service.UserProviderService;
import cn.com.yusys.yusp.oca.util.AuthUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class UserProviderServiceController {
    private static final Logger logger = LoggerFactory.getLogger(UserProviderServiceController.class);
    @Autowired
    private UserProviderService providerService;
    private static final String SYS_ID = "sysId";

    @PostMapping(value={"/user/info"})
    public IcspResultDto<User> getUserInfo(@RequestBody IcspRequest<Map<String, String>> request) {
        String userId = (String)((Map)request.getBody()).get("userId");
        logger.info("userId: {}", (Object)userId);
        return IcspResultDto.success((Object)this.providerService.getUserInfo(userId));
    }

    @PostMapping(value={"/session/info"})
    public IcspResultDto<User> getSessionInfo(@RequestBody IcspRequest<Map<String, String>> request) {
        String orgId = (String)((Map)request.getBody()).get("orgId");
        Map parsedTokenMap = AuthUtils.getParsedAccessTokenMap();
        String accessToken = AuthUtils.getCurrentUserToken(parsedTokenMap);
        String sysId = AuthUtils.getCurrentUserLoginSYS(parsedTokenMap);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            logger.warn("Failed to get user authorization information {}", (Object)accessToken);
            return null;
        }
        String loginCode = this.providerService.getUserCode(accessToken);
        String clientId = SessionUtils.getClientId();
        String userId = SessionUtils.getUserId();
        String workDate = request.getTradeHead().getWorkDate();
        logger.info("clientId {} userCode: {}", (Object)clientId, (Object)loginCode);
        return IcspResultDto.success((Object)this.providerService.getUserInfo(clientId, userId, loginCode, orgId, sysId, accessToken, workDate));
    }

    @PostMapping(value={"/account/menuandcontr"})
    public IcspResultDto<MenuContr> getMenuandContr(@RequestBody IcspRequest<Map<String, String>> request) {
        String sysId = "btop";
        String orgId = (String)((Map)request.getBody()).get("orgId");
        String roleId = (String)((Map)request.getBody()).get("roleId");
        String lang = (String)((Map)request.getBody()).get("lang");
        Map parsedTokenMap = AuthUtils.getParsedAccessTokenMap();
        String accessToken = AuthUtils.getCurrentUserToken(parsedTokenMap);
        String loginCode = SessionUtils.getLoginCode();
        String clientId = SessionUtils.getClientId();
        if (((Map)request.getBody()).containsKey(SYS_ID) && StringUtils.nonEmpty((CharSequence)((CharSequence)((Map)request.getBody()).get(SYS_ID)))) {
            sysId = (String)((Map)request.getBody()).get(SYS_ID);
        }
        String finalSysId = sysId;
        CompletableFuture.supplyAsync(() -> this.providerService.getDataandContr(finalSysId, clientId, loginCode, orgId));
        return IcspResultDto.success((Object)this.providerService.getMenuandContr(loginCode, sysId, orgId, accessToken, lang, roleId));
    }

    @PostMapping(value={"/session/logOut"})
    public IcspResultDto<String> logOut(@RequestBody IcspRequest<Map<String, String>> request) {
        Map parsedTokenMap = AuthUtils.getParsedAccessTokenMap();
        String accessToken = AuthUtils.getCurrentUserToken(parsedTokenMap);
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            logger.warn("Failed to get user authorization information {}", (Object)accessToken);
            return null;
        }
        this.providerService.logOut(accessToken);
        return IcspResultDto.success((Object)"200");
    }
}

