/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.controller;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.context.header.annonation.MessageBody;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.oca.dto.AdminSmMenuDto;
import cn.com.yusys.yusp.oca.dto.MenuTransDto;
import cn.com.yusys.yusp.oca.dto.query.AdminSmMenuQueryDto;
import cn.com.yusys.yusp.oca.service.AdminSmMenuService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/adminSmMenu"})
public class AdminSmMenuController {
    @Autowired
    private AdminSmMenuService adminSmMenuService;

    @PostMapping(value={"/menuTreeQuery"})
    public IcspResultDto<List<AdminSmMenuDto>> getMenuTree(@MessageBody(value="body") AdminSmMenuQueryDto adminSmMenuQueryDto) {
        if (StringUtils.isEmpty((CharSequence)adminSmMenuQueryDto.getSysId())) {
            return IcspResultDto.failure((String)"500", (String)"sysId\u5fc5\u8f93");
        }
        List list = this.adminSmMenuService.getMenuTree(adminSmMenuQueryDto);
        return IcspResultDto.success((Object)list, (long)list.size());
    }

    @PostMapping(value={"/menuInfoQuery"})
    public IcspResultDto<Map<String, Object>> getMenuInfo(@MessageBody(value="body") AdminSmMenuQueryDto adminSmMenuQueryDto) {
        if (StringUtils.isEmpty((CharSequence)adminSmMenuQueryDto.getMenuId())) {
            return IcspResultDto.failure((String)"500", (String)"menuId\u5fc5\u8f93");
        }
        Map result = this.adminSmMenuService.getMenuInfo(adminSmMenuQueryDto);
        return IcspResultDto.success((Object)result, (long)1L);
    }

    @PostMapping(value={"/create"})
    public IcspResultDto<Integer> create(@MessageBody(value="body") AdminSmMenuDto adminSmMenuDto) {
        int result = this.adminSmMenuService.create(adminSmMenuDto);
        if (result >= 1) {
            return IcspResultDto.successMsg((String)("\u6dfb\u52a0\u83dc\u5355" + adminSmMenuDto.getMenuName()));
        }
        return IcspResultDto.failure((String)"1", (String)"\u65b0\u589e\u83dc\u5355\u5931\u8d25");
    }

    @PostMapping(value={"/update"})
    public IcspResultDto<Integer> update(@MessageBody(value="body") AdminSmMenuDto adminSmMenuDto) {
        int result = this.adminSmMenuService.update(adminSmMenuDto);
        if (result >= 1) {
            return IcspResultDto.successMsg((String)("\u83dc\u5355" + adminSmMenuDto.getMenuName() + "\u4fee\u6539\u6210\u529f\uff01"));
        }
        return IcspResultDto.failure((String)"1", (String)"\u4fee\u6539\u83dc\u5355\u5931\u8d25");
    }

    @PostMapping(value={"/delete"})
    public IcspResultDto<Integer> delete(@MessageBody(value="body") AdminSmMenuQueryDto adminSmMenuQueryDto) {
        String menuId = adminSmMenuQueryDto.getMenuId();
        int result = this.adminSmMenuService.delete(adminSmMenuQueryDto);
        if (result >= 1) {
            return IcspResultDto.successMsg((String)("\u6210\u529f\u5220\u9664\u83dc\u5355" + menuId + ""));
        }
        return IcspResultDto.failure((String)"1", (String)"\u5220\u9664\u83dc\u5355\u5931\u8d25");
    }

    @PostMapping(value={"/funcListQuery"})
    public IcspResultDto<List<Map<String, Object>>> getFuncInfo(@MessageBody(value="body") AdminSmMenuQueryDto adminSmMenuQueryDto) {
        List list = this.adminSmMenuService.getFuncInfo(adminSmMenuQueryDto);
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/queryMenu"})
    protected IcspResultDto<List<Map<String, Object>>> queryMenu(@MessageBody(value="body") AdminSmMenuQueryDto adminSmMenuQueryDto) {
        List list = this.adminSmMenuService.queryMenu(adminSmMenuQueryDto);
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/queryTradeMenu"})
    protected IcspResultDto<List<Map<String, Object>>> queryTradeMenu(@RequestBody IcspRequest<String> request) {
        if (request.getBody() == null || "".equals(request.getBody())) {
            return IcspResultDto.success(new ArrayList());
        }
        AdminSmMenuQueryDto adminSmMenuQueryDto = new AdminSmMenuQueryDto();
        adminSmMenuQueryDto.setQueryKey((String)request.getBody());
        List list = this.adminSmMenuService.queryTradeMenu(adminSmMenuQueryDto);
        return IcspResultDto.success((Object)list);
    }

    @PostMapping(value={"/orderTransform"})
    public IcspResultDto<String> orderTransform(@MessageBody(value="body") MenuTransDto reqBean) throws Exception {
        if (StringUtils.isEmpty((CharSequence)reqBean.getTransType()) || !"inner".equalsIgnoreCase(reqBean.getTransType()) && !"before".equalsIgnoreCase(reqBean.getTransType()) && !"after".equalsIgnoreCase(reqBean.getTransType())) {
            throw new IcspException("500", "\u672a\u8bc6\u522b\u5230\u6392\u5e8f\u8c03\u6574\u7c7b\u578b");
        }
        this.adminSmMenuService.orderTransform(reqBean);
        return IcspResultDto.successMsg((String)"success");
    }
}

