/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.utils;

import cn.com.yusys.yusp.common.exception.IcspException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.generators.KDF1BytesGenerator;
import org.bouncycastle.crypto.params.ISO18033KDFParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Util {
    private Logger logger = LoggerFactory.getLogger(SM2Util.class);
    private static final String FFE = "FFFFFFFE";
    private static final String FFF = "FFFFFFFF";
    private static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static final BigInteger xg = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger yg = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static SecureRandom random = new SecureRandom();
    private ECCurve.Fp curve = new ECCurve.Fp(p, a, b);
    private ECPoint G = this.curve.createPoint(xg, yg);

    public String encryptSM2(String input) {
        ECPoint publicKey = this.importPublicKey("cert/publicKey.pem");
        byte[] inputBuffer = input.getBytes();
        BigInteger k = this.random(n);
        ECPoint C1 = this.G.multiply(k);
        byte[] C1Buffer = C1.getEncoded(false);
        ECPoint kpb = publicKey.multiply(k).normalize();
        byte[] kpbBytes = kpb.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        byte[] t = new byte[inputBuffer.length];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(kpbBytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            System.err.println("all zero");
        }
        byte[] C2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            C2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }
        byte[] C3 = this.calculateHash(kpb.getXCoord().toBigInteger(), inputBuffer, kpb.getYCoord().toBigInteger());
        byte[] encryptResult = new byte[C1Buffer.length + C2.length + C3.length];
        System.arraycopy(C1Buffer, 0, encryptResult, 0, C1Buffer.length);
        System.arraycopy(C2, 0, encryptResult, C1Buffer.length, C2.length);
        System.arraycopy(C3, 0, encryptResult, C1Buffer.length + C2.length, C3.length);
        return SM2Util.printHexString(encryptResult);
    }

    public String decryptSM2(String data) {
        BigInteger privateKey = this.importPrivateKey("cert/privateKey.pem");
        byte[] encryptData = SM2Util.hexStringToBytes(data);
        byte[] C1Byte = new byte[65];
        System.arraycopy(encryptData, 0, C1Byte, 0, C1Byte.length);
        ECPoint C1 = this.curve.decodePoint(C1Byte).normalize();
        ECPoint dBC1 = C1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        int klen = encryptData.length - 65 - 20;
        byte[] t = new byte[klen];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(dBC1Bytes));
        kdf.generateBytes(t, 0, t.length);
        if (this.allZero(t)) {
            this.logger.info("all zero");
        }
        byte[] M = new byte[klen];
        for (int i = 0; i < M.length; ++i) {
            M[i] = (byte)(encryptData[C1Byte.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[20];
        System.arraycopy(encryptData, encryptData.length - 20, C3, 0, 20);
        byte[] u = this.calculateHash(dBC1.getXCoord().toBigInteger(), M, dBC1.getYCoord().toBigInteger());
        if (Arrays.equals(u, C3)) {
            return new String(M);
        }
        throw new IcspException("500", "\u89e3\u5bc6\u9a8c\u8bc1\u5931\u8d25");
    }

    public static String printHexString(byte[] b) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0' + hex);
                continue;
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || "".equals(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(SM2Util.charToByte(hexChars[pos]) << 4 | SM2Util.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private byte[] calculateHash(BigInteger x2, byte[] M, BigInteger y2) {
        ShortenedDigest digest = new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20);
        byte[] buf = x2.toByteArray();
        digest.update(buf, 0, buf.length);
        digest.update(M, 0, M.length);
        buf = y2.toByteArray();
        digest.update(buf, 0, buf.length);
        buf = new byte[20];
        digest.doFinal(buf, 0);
        return buf;
    }

    private boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        return false;
    }

    public BigInteger importPrivateKey(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(SM2Util.class.getClassLoader().getResourceAsStream(path));
            BigInteger res = (BigInteger)ois.readObject();
            ois.close();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ECPoint importPublicKey(String path) {
        try {
            int size;
            InputStream is = SM2Util.class.getClassLoader().getResourceAsStream(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[16];
            while ((size = is.read(buffer)) != -1) {
                baos.write(buffer, 0, size);
            }
            is.close();
            return this.curve.decodePoint(baos.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

