/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.util;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.util.encrypt.BCRSAUtils;
import cn.com.yusys.yusp.oca.constant.MessageEnums;
import cn.com.yusys.yusp.oca.constant.ResponseAndMessageEnum;
import cn.com.yusys.yusp.oca.dto.AdminSmUserDto;
import cn.com.yusys.yusp.oca.service.AdminSmUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class PasswordUtils {
    private static final Logger log = LoggerFactory.getLogger(PasswordUtils.class);
    @Autowired
    AdminSmUserService adminSmUserService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public boolean matchUserPassword(String rawPassword, String loginCode) throws Exception {
        AdminSmUserDto AdminSmUserDto2 = new AdminSmUserDto();
        AdminSmUserDto2.setLoginCode(loginCode);
        AdminSmUserDto adminSmUserDto = this.adminSmUserService.show(AdminSmUserDto2);
        if (adminSmUserDto != null) {
            String passwordDb = adminSmUserDto.getUserPassword();
            return this.checkSecret(passwordDb, rawPassword);
        }
        log.error("\u7528\u6237\u4e0d\u5b58\u5728");
        throw BizException.error(null, (String)ResponseAndMessageEnum.NON_USER.getCode(), (Object[])new Object[]{ResponseAndMessageEnum.NON_USER.getMessage()});
    }

    public boolean checkSecret(String dbPassword, String rawPassword) {
        try {
            rawPassword = this.dePassword(rawPassword);
            return this.passwordEncoder.matches((CharSequence)rawPassword, dbPassword);
        }
        catch (Exception e) {
            log.error("\u5bc6\u7801\u6821\u9a8c\u5931\u8d25");
            return false;
        }
    }

    public String dePassword(String password) {
        try {
            password = BCRSAUtils.decryptByPrivate((String)password);
            return password;
        }
        catch (Exception e) {
            log.error("\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
            throw BizException.error(null, (String)MessageEnums.PASSWORD_RESOLUTION_FAILED.getCode(), (Object[])new Object[]{MessageEnums.PASSWORD_RESOLUTION_FAILED.getMessage()});
        }
    }

    public String enPassword(String password) {
        try {
            String cipherText = BCRSAUtils.decryptByPrivate((String)password);
            password = this.passwordEncoder.encode((CharSequence)cipherText);
            return password;
        }
        catch (Exception e) {
            log.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
            throw BizException.error(null, (String)MessageEnums.PASSWORD_ENCODE_FAILED.getCode(), (Object[])new Object[]{MessageEnums.PASSWORD_ENCODE_FAILED.getMessage()});
        }
    }
}

