/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.specification;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.oca.assembler.AdminSmUserAssembler;
import cn.com.yusys.yusp.oca.dataobj.AdminSmUserDo;
import cn.com.yusys.yusp.oca.domain.AbstractSpecification;
import cn.com.yusys.yusp.oca.dto.AdminSmUserDto;
import cn.com.yusys.yusp.oca.entity.AdminSmOrgEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmOrgRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUserRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminSmUserSpecification
extends AbstractSpecification<AdminSmUserEntity> {
    @Autowired
    private AdminSmUserRepository adminSmUserRepository;
    @Autowired
    private AdminSmOrgRepository adminSmOrgRepository;

    public boolean isSatisfiedBy(AdminSmUserEntity adminSmUser) {
        AdminSmUserDo adminSmUserDo = AdminSmUserAssembler.toAdminSmUserDo(adminSmUser);
        QueryModel queryModel = new QueryModel();
        queryModel.setCondition((Object)adminSmUserDo);
        List list = this.adminSmUserRepository.selectByModel(queryModel);
        if (list == null || list.size() < 1) {
            throw new IcspException("500", adminSmUser.getUserId() + "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return true;
    }

    public boolean isSatisfiedByCreate(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDto adminSmUserDto = new AdminSmUserDto();
        adminSmUserDto.setUserId(adminSmUserEntity.getLoginCode());
        List select = this.adminSmUserRepository.select(adminSmUserDto);
        if (select.size() > 0) {
            throw new IcspException("500", "\u5ba2\u6237\u53f7\u5df2\u5b58\u5728");
        }
        return true;
    }

    public boolean isSatisfiedByShow(AdminSmUserEntity adminSmUserEntity) {
        if (StringUtils.isEmpty((CharSequence)adminSmUserEntity.getUserId()) && StringUtils.isEmpty((CharSequence)adminSmUserEntity.getLoginCode())) {
            throw new IcspException("500", "\u7528\u6237\u7f16\u53f7\u4e0eLoginCode\u5168\u4e3a\u7a7a\uff01");
        }
        return true;
    }

    public boolean isSatisfiedByQuery(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserEntity adminSmUserEntity1 = new AdminSmUserEntity();
        adminSmUserEntity1.setLoginCode(adminSmUserEntity.getLoginCode());
        AdminSmUserEntity adminSmUserEntity2 = this.adminSmUserRepository.selectByLoginCode(adminSmUserEntity1);
        if (adminSmUserEntity2 == null) {
            throw new IcspException("500", adminSmUserEntity.getLoginCode() + "\u4e0d\u5b58\u5728");
        }
        if ("L".equalsIgnoreCase(adminSmUserEntity2.getUserSts())) {
            throw new IcspException("500", adminSmUserEntity.getLoginCode() + "\u5df2\u9501\u5b9a");
        }
        BeanUtils.beanCopy((Object)adminSmUserEntity2, (Object)adminSmUserEntity);
        return true;
    }

    public boolean isSatisfiedBysaveUserParam(AdminSmUserEntity adminSmUser) {
        if (adminSmUser.getLastChgUser().equals((Object)adminSmUser.getUserId())) {
            throw new IcspException("500", "\u7528\u6237\u4e0d\u5141\u8bb8\u7ed9\u81ea\u5df1\u914d\u7f6e\u89d2\u8272\u5c97\u4f4d");
        }
        return true;
    }

    public boolean isSatisfiedByOrgTransfer(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserEntity adminSmUserEntity1 = this.adminSmUserRepository.selectByPrimaryKey(adminSmUserEntity);
        if ("20220809".equals(adminSmUserEntity1.getSignDate()) && "1".equals(adminSmUserEntity1.getSignSts())) {
            throw new IcspException("500", "\u5f53\u65e5\u7b7e\u5230\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u8c03\u52a8");
        }
        if ("I".equals(adminSmUserEntity1.getUserSts())) {
            throw new IcspException("500", "\u67dc\u5458\u5931\u6548\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u8c03\u52a8");
        }
        AdminSmOrgEntity newOrg = this.adminSmOrgRepository.selectByPrimaryKey(adminSmUserEntity.getTargetOrg());
        AdminSmOrgEntity oldOrg = this.adminSmOrgRepository.selectByPrimaryKey(adminSmUserEntity.getOrg());
        if (newOrg == null || oldOrg == null || StringUtils.isEmpty((CharSequence)newOrg.getInstuId()) || StringUtils.isEmpty((CharSequence)oldOrg.getInstuId())) {
            throw new IcspException("500", "\u539f\u673a\u6784\u6216\u8c03\u52a8\u673a\u6784\u4e0d\u5b58\u5728\u6cd5\u4eba");
        }
        if (!newOrg.getInstuId().equals(oldOrg.getInstuId())) {
            throw new IcspException("500", "\u4e0d\u5141\u8bb8\u8de8\u6cd5\u4eba\u673a\u6784\u8c03\u52a8");
        }
        return true;
    }
}

