/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.specification;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.oca.bp.ApplyScope;
import cn.com.yusys.yusp.oca.dataobj.AdminSmDutyDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSmRoleDo;
import cn.com.yusys.yusp.oca.domain.AbstractSpecification;
import cn.com.yusys.yusp.oca.entity.AdminSmDutySubstituteEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmOrgEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmApplyScopeRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmDutyRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmDutySubstituteRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmOrgRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmRoleRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUserRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminSmDutySubstituteSpecification
extends AbstractSpecification<AdminSmDutySubstituteEntity> {
    @Autowired
    AdminSmUserRepository adminSmUserRepository;
    @Autowired
    AdminSmDutySubstituteRepository adminSmDutySubstituteRepository;
    @Autowired
    AdminSmOrgRepository adminSmOrgRepository;
    @Autowired
    AdminSmRoleRepository adminSmRoleRepository;
    @Autowired
    AdminSmApplyScopeRepository adminSmApplyScopeRepository;
    @Autowired
    AdminSmDutyRepository adminSmDutyRepository;

    public boolean isSatisfiedBy(AdminSmDutySubstituteEntity adminSmDutySubstituteEntity) {
        return false;
    }

    public void isSatisfiedByCreate(AdminSmDutySubstituteEntity adminSmDutySubstituteEntity) {
        AdminSmUserEntity adminSmUserEntity = adminSmDutySubstituteEntity.getAdminSmUserEntity();
        AdminSmUserEntity user = this.adminSmUserRepository.selectByPrimaryKey(adminSmUserEntity);
        if (!"A".equals(user.getUserSts())) {
            throw new IcspException("500", "\u88ab\u66ff\u5c97\u4eba\u4e0d\u662f\u751f\u6548\u72b6\u6001\uff0c\u65e0\u6cd5\u88ab\u66ff\u5c97");
        }
        StringBuffer sb = new StringBuffer();
        String workDate = "20220809";
        sb.append(workDate).insert(4, "-").insert(7, "-").append(" 00:00");
        List listUser = this.adminSmDutySubstituteRepository.queryUserBySub(sb.toString(), adminSmDutySubstituteEntity.getUserId(), adminSmDutySubstituteEntity.getSubUserId());
        if (listUser.size() > 0) {
            throw new IcspException("500", "\u66ff\u5c97\u4eba\u6216\u88ab\u66ff\u5c97\u4eba\u5df2\u5b58\u5728\u66ff\u5c97\u72b6\u6001");
        }
        adminSmDutySubstituteEntity.setDutySubId(StringUtils.getUUID());
        List list = this.adminSmDutySubstituteRepository.queryDutyByUser(adminSmDutySubstituteEntity.getUserId());
        if (list.size() > 0) {
            throw new IcspException("500", "\u88ab\u66ff\u5c97\u4eba\u5177\u6709\u4e0d\u53ef\u4ee5\u4ea4\u63a5\u7684\u5c97\u4f4d");
        }
        boolean authNotFit = this.judgeOrgAuth(adminSmDutySubstituteEntity.getCurrentOrgId(), adminSmDutySubstituteEntity.getSubUserId());
        if (authNotFit) {
            throw new IcspException("500", "\u5f53\u524d\u767b\u9646\u673a\u6784\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u65b0\u589e\u66ff\u5c97\u8bb0\u5f55");
        }
    }

    private boolean judgeOrgAuth(String currentOrgId, String userId) {
        boolean flag = false;
        AdminSmOrgEntity adminSmOrgEntity = new AdminSmOrgEntity();
        adminSmOrgEntity.setOrgId(currentOrgId);
        AdminSmOrgEntity logInOrg = this.adminSmOrgRepository.selectByPrimaryKey(adminSmOrgEntity);
        List roleList = this.adminSmRoleRepository.selectByUserId(userId);
        flag = this.ifRoleList(roleList, logInOrg);
        List dutyList = this.adminSmDutyRepository.selectByUserId(userId);
        flag = this.ifDutyList(dutyList, logInOrg, flag);
        return flag;
    }

    public boolean isSatisfiedByCanel(AdminSmDutySubstituteEntity adminSmDutySubstituteEntity) {
        if ("0".equals(adminSmDutySubstituteEntity.getDutySubSts())) {
            throw new IcspException("500", "\u5f53\u524d\u72b6\u6001\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
        return true;
    }

    public boolean ifRoleList(List<AdminSmRoleDo> roleList, AdminSmOrgEntity logInOrg) {
        boolean flag = false;
        if (roleList != null && roleList.size() > 0) {
            for (AdminSmRoleDo adminSmRoleDo : roleList) {
                if ("L".equals(adminSmRoleDo.getApplyScopeType())) {
                    String level = logInOrg.getOrgLevel();
                    String applyScope = adminSmRoleDo.getApplyScope();
                    boolean b2 = level.equals("2") && applyScope.charAt(0) == '1';
                    boolean b3 = level.equals("3") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1');
                    boolean b4 = level.equals("4") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1' || applyScope.charAt(2) == '1');
                    flag = this.ifB(b2, b3, b4, flag);
                    continue;
                }
                ApplyScope applyScope = new ApplyScope();
                applyScope.setObjType("R");
                applyScope.setObjId(adminSmRoleDo.getRoleId());
                String orgs = this.adminSmApplyScopeRepository.selectByApplyRelId(applyScope);
                flag = this.ifOrg(orgs, logInOrg, flag);
            }
        }
        return flag;
    }

    public boolean ifB(boolean b2, boolean b3, boolean b4, boolean flag) {
        if (b2 || b3 || b4) {
            flag = true;
        }
        return flag;
    }

    public boolean ifOrg(String orgs, AdminSmOrgEntity logInOrg, boolean flag) {
        if (!orgs.contains(logInOrg.getOrgCode())) {
            flag = true;
        }
        return flag;
    }

    public boolean ifDutyList(List<AdminSmDutyDo> dutyList, AdminSmOrgEntity logInOrg, boolean flag) {
        if (dutyList != null && dutyList.size() > 0) {
            for (AdminSmDutyDo adminSmDutyDo : dutyList) {
                if ("L".equals(adminSmDutyDo.getApplyScopeType())) {
                    String level = logInOrg.getOrgLevel();
                    String applyScope = adminSmDutyDo.getApplyScope();
                    boolean b2 = level.equals("2") && applyScope.charAt(0) == '1';
                    boolean b3 = level.equals("3") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1');
                    boolean b4 = level.equals("4") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1' || applyScope.charAt(2) == '1');
                    flag = this.ifB(b2, b3, b4, flag);
                    continue;
                }
                ApplyScope applyScope = new ApplyScope();
                applyScope.setObjType("D");
                applyScope.setObjId(adminSmDutyDo.getDutyId());
                String orgs = this.adminSmApplyScopeRepository.selectByApplyRelId(applyScope);
                flag = this.ifOrg(orgs, logInOrg, flag);
            }
        }
        return flag;
    }
}

