/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.service.impl;

import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.user.Contr;
import cn.com.yusys.yusp.common.user.DataContr;
import cn.com.yusys.yusp.common.user.Duty;
import cn.com.yusys.yusp.common.user.Menu;
import cn.com.yusys.yusp.common.user.MenuContr;
import cn.com.yusys.yusp.common.user.Org;
import cn.com.yusys.yusp.common.user.Role;
import cn.com.yusys.yusp.common.user.User;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.dao.AdminSmDutySubstituteDao;
import cn.com.yusys.yusp.oca.dao.AdminSmOrgDao;
import cn.com.yusys.yusp.oca.dao.AdminSmUserPrivilegeDao;
import cn.com.yusys.yusp.oca.dao.UserCacheDao;
import cn.com.yusys.yusp.oca.dataobj.AdminSmDutySubstituteDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSmOrgDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSmUserPrivilegeDo;
import cn.com.yusys.yusp.oca.dto.query.AdminSmUserPrivilegeQueryDto;
import cn.com.yusys.yusp.oca.entity.AdminSmOrgEntity;
import cn.com.yusys.yusp.oca.service.UserProviderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserProviderServiceImpl
implements UserProviderService {
    private static final Logger log = LoggerFactory.getLogger(UserProviderServiceImpl.class);
    private static final String UP_ORG_ID = "upOrgId";
    private static final String ROLE_ID = "roleId";
    private static final String DUTY_ID = "dutyId";
    @Value(value="${oca.menu-is-all:true}")
    private boolean menuIsAll;
    @Autowired
    private UserCacheDao userCacheDao;
    @Autowired
    private AdminSmOrgDao adminSmOrgDao;
    @Autowired
    private AdminSmUserPrivilegeDao adminSmUserPrivilegeDao;
    @Autowired
    private AdminSmDutySubstituteDao adminSmDutySubstituteDao;

    public User getUserInfo(String loginCode) {
        List<Map<String, Object>> users = this.userCacheDao.selectUserInfo(loginCode, "");
        if (users.isEmpty()) {
            return null;
        }
        User user = new User();
        this.fullUserDto(user, users, (String)users.get(0).get("orgId"), false, null);
        return user;
    }

    @Transactional(readOnly=true)
    @CachePut(value={"Session"}, key="#clientId+'-'+#userId", unless="#result == null")
    public User getUserInfo(String clientId, String userId, String loginCode, String orgId, String sysId, String accessToken, String workDate) {
        List<Map<String, Object>> users;
        List<AdminSmDutySubstituteDo> listUsers;
        boolean userIsSub = false;
        ArrayList<Map<String, Object>> subUsers = new ArrayList();
        StringBuffer sb = new StringBuffer();
        if (StringUtils.nonEmpty((CharSequence)workDate)) {
            sb.append(workDate).insert(4, "-").insert(7, "-").append(" 00:00");
        }
        if ((listUsers = this.adminSmDutySubstituteDao.queryDutySubUser(sb.toString(), loginCode)) != null && listUsers.size() > 0) {
            userIsSub = true;
            subUsers = this.userCacheDao.selectUserInfo(listUsers.get(0).getUserId(), sysId);
        }
        if ((users = this.userCacheDao.selectUserInfo(loginCode, sysId)).isEmpty()) {
            return null;
        }
        User user = new User();
        this.fullUserDto(user, users, orgId, userIsSub, subUsers);
        return user;
    }

    @Cacheable(value={"sessionInfo"}, key="'userCode_'+#accessToken", unless="#result == null")
    public String getUserCode(String accessToken) {
        String loginCode = SessionUtils.getUserId();
        return loginCode;
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"sessionInfo"}, key="#sysId+'_menuandContr_'+#accessToken", unless="#result == null")
    public MenuContr getMenuandContr(String loginCode, String sysId, String orgId, String accessToken, String lang, String roleId) {
        QueryModel model = new QueryModel();
        AdminSmUserPrivilegeQueryDto adminSmUserPrivilegeQuery = new AdminSmUserPrivilegeQueryDto();
        adminSmUserPrivilegeQuery.setUserId(loginCode);
        model.setCondition((Object)adminSmUserPrivilegeQuery);
        List<AdminSmUserPrivilegeDo> entities = this.adminSmUserPrivilegeDao.selectByModel(model);
        MenuContr menuContr = new MenuContr();
        if (this.menuIsAll) {
            ArrayList<Menu> menus = new ArrayList();
            menus = this.ifEN(lang, sysId);
            this.forEntity(entities, menus);
            menuContr.setMenu(menus);
            menuContr.setContr(this.userCacheDao.selectAllContr(sysId));
        } else {
            List<Object> menus = new ArrayList();
            menus = "En".equalsIgnoreCase(lang) ? this.userCacheDao.selectMenu4En(loginCode, sysId, orgId) : this.userCacheDao.selectMenu(loginCode, sysId, orgId, roleId);
            for (int i = 0; i < entities.size(); ++i) {
                AdminSmUserPrivilegeDo privilegeEntity = entities.get(i);
                for (int j = 0; j < menus.size(); ++j) {
                    if (!privilegeEntity.getResId().equals(((Menu)menus.get(j)).getMenuCode())) continue;
                    menus.remove(j);
                }
            }
            menuContr.setContr(this.userCacheDao.selectUserContr(loginCode, sysId, orgId));
            menuContr.setMenu(menus);
        }
        return menuContr;
    }

    public List<Menu> ifEN(String lang, String sysId) {
        List<Object> menus = new ArrayList();
        menus = "En".equalsIgnoreCase(lang) ? this.userCacheDao.selectAllMenu4En(sysId) : this.userCacheDao.selectAllMenu(sysId);
        return menus;
    }

    public void forEntity(List<AdminSmUserPrivilegeDo> entities, List<Menu> menus) {
        for (AdminSmUserPrivilegeDo privilegeEntity : entities) {
            for (int j = 0; j < menus.size(); ++j) {
                if (!privilegeEntity.getResId().equals(menus.get(j).getMenuCode())) continue;
                menus.remove(j);
            }
        }
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"DataControl"}, key="#sysId+'-'+#clientId+'-'+#userId", unless="#result == null")
    public List<DataContr> getDataandContr(String sysId, String clientId, String userId, String orgId) {
        List<DataContr> dataContr = new ArrayList<DataContr>();
        if (userId == null) {
            if (log.isDebugEnabled()) {
                log.debug("The passed in logincode parameter is null, unable to query user data permission information");
            }
        } else {
            dataContr = this.userCacheDao.selectDataAuthList(userId, sysId, orgId);
        }
        return dataContr;
    }

    public List<Contr> getAllContrs(String loginCode, String sysId, String orgId, String accessToken) {
        return null;
    }

    @CacheEvict(value={"contrurl"}, key="'getAllContrUrl'", beforeInvocation=true)
    public void cleanAllContrUrlCache() {
    }

    @CacheEvict(value={"sessionInfo"}, key="#accessToken", beforeInvocation=true)
    public void cleanUserInfoCache(String accessToken) {
    }

    @CacheEvict(value={"sessionInfo"}, key="'menuandContr_'+#accessToken", beforeInvocation=true)
    public void cleanMenuAndContrCache(String accessToken) {
    }

    @CacheEvict(value={"sessionInfo"}, key="'dataContr_'+#accessToken", beforeInvocation=true)
    public void cleanDataContrCache(String accessToken) {
    }

    public void logOut(String accessToken) {
        this.cleanAllContrUrlCache();
        this.cleanUserInfoCache(accessToken);
        this.cleanMenuAndContrCache(accessToken);
        this.cleanDataContrCache(accessToken);
    }

    private void fullUserDto(User user, List<Map<String, Object>> userT, String orgId, boolean userIsSub, List<Map<String, Object>> subUsers) {
        BeanMap beanMap = BeanMap.create((Object)user);
        beanMap.putAll(userT.get(0));
        Org org = new Org();
        BeanMap beanMap1 = BeanMap.create((Object)org);
        beanMap1.putAll(userT.get(0));
        user.setOwnOrg(org);
        Org currentOrg = new Org();
        this.ifOrg(orgId, currentOrg, user, userT);
        Org upOrg = new Org();
        this.ifUserT(userT, upOrg, user);
        if (userIsSub) {
            userT = subUsers;
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        user.setRoles(roles);
        ArrayList<String> ut = new ArrayList<String>();
        for (Map<String, Object> userTT : userT) {
            if (userTT.get(ROLE_ID) == null || ut.contains((String)userTT.get(ROLE_ID))) continue;
            Role role = new Role();
            role.setRoleId((String)userTT.get(ROLE_ID));
            role.setRoleCode((String)userTT.get("roleCode"));
            role.setRoleName((String)userTT.get("roleName"));
            role.setRoleLevel((String)userTT.get("roleLevel"));
            role.setRoleSts((String)userTT.get("roleSts"));
            roles.add(role);
            ut.add((String)userTT.get(ROLE_ID));
        }
        ArrayList<Duty> dutys = new ArrayList<Duty>();
        user.setDutys(dutys);
        ArrayList<String> du = new ArrayList<String>();
        for (Map<String, Object> userTT : userT) {
            if (userTT.get(DUTY_ID) == null || du.contains((String)userTT.get(DUTY_ID))) continue;
            Duty duty = new Duty();
            duty.setDutyId((String)userTT.get(DUTY_ID));
            duty.setDutyCode((String)userTT.get("dutyCode"));
            duty.setDutyName((String)userTT.get("dutyName"));
            duty.setDutyRemark((String)userTT.get("dutyRemark"));
            duty.setDutySts((String)userTT.get("dutySts"));
            dutys.add(duty);
            du.add((String)userTT.get(DUTY_ID));
        }
    }

    private void ifOrg(String orgId, Org currentOrg, User user, List<Map<String, Object>> userT) {
        if (!"".equals(orgId) && orgId != null) {
            QueryModel model = new QueryModel();
            AdminSmOrgEntity adminSmOrgEntity = new AdminSmOrgEntity();
            adminSmOrgEntity.setOrgId(orgId);
            model.setCondition((Object)adminSmOrgEntity);
            List<AdminSmOrgDo> cOrg = this.adminSmOrgDao.selectByModel(model);
            if (cOrg.size() > 0) {
                BeanUtils.copyProperties((Object)cOrg.get(0), (Object)currentOrg);
                user.setCurrentOrg(currentOrg);
            }
            log.info(userT.get(0).get("userId") + "\u5728" + DateUtils.formatDateTimeByDef() + "\u6dfb\u52a0currentOrg\u6210\u529f, currentOrgId: " + orgId);
        } else {
            log.info(userT.get(0).get("userId") + "\u5728" + DateUtils.formatDateTimeByDef() + "\u6dfb\u52a0currentOrg\u5931\u8d25,\u672a\u83b7\u53d6\u5230orgId");
        }
    }

    private void ifUserT(List<Map<String, Object>> userT, Org upOrg, User user) {
        if (!"".equals((String)userT.get(0).get(UP_ORG_ID)) && (String)userT.get(0).get(UP_ORG_ID) != null) {
            QueryModel model = new QueryModel();
            AdminSmOrgEntity adminSmOrgEntity = new AdminSmOrgEntity();
            adminSmOrgEntity.setOrgId((String)userT.get(0).get(UP_ORG_ID));
            model.setCondition((Object)adminSmOrgEntity);
            List<AdminSmOrgDo> upAdminSmOrg = this.adminSmOrgDao.selectByModel(model);
            if (upAdminSmOrg.size() > 0) {
                BeanUtils.copyProperties((Object)upAdminSmOrg.get(0), (Object)upOrg);
                user.setUpOrg(upOrg);
            }
        }
    }
}

