/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.service.impl;

import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.oca.annotation.LoginStrategy;
import cn.com.yusys.yusp.oca.constant.AvailableStateEnum;
import cn.com.yusys.yusp.oca.constant.ResponseAndMessageEnum;
import cn.com.yusys.yusp.oca.dto.AdminSmUserDto;
import cn.com.yusys.yusp.oca.dto.UserEntityVo;
import cn.com.yusys.yusp.oca.service.AdminSmUserService;
import cn.com.yusys.yusp.oca.service.LoginCheckSecretService;
import cn.com.yusys.yusp.oca.util.PasswordUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class LoginCheckSecretServiceImpl
implements LoginCheckSecretService {
    private static final Logger log = LoggerFactory.getLogger(LoginCheckSecretServiceImpl.class);
    private static final String ACCESS = "access:";
    @Autowired
    AdminSmUserService adminSmUserService;
    @Autowired
    PasswordUtils passwordUtils;

    @LoginStrategy
    public ResultDto<UserEntityVo> queryUserAndCheckSecret(String loginCode, String password) throws Exception {
        AdminSmUserDto AdminSmUserDto2 = new AdminSmUserDto();
        AdminSmUserDto2.setLoginCode(loginCode);
        AdminSmUserDto adminSmUserDto = this.adminSmUserService.show(AdminSmUserDto2);
        if (Objects.nonNull(adminSmUserDto)) {
            if (StringUtils.nonEmpty((CharSequence)adminSmUserDto.getUserSts()) && !StringUtils.equals((CharSequence)AvailableStateEnum.ENABLED.getCode(), (CharSequence)adminSmUserDto.getUserSts())) {
                return ResultDto.error((String)ResponseAndMessageEnum.USER_INVALID.getCode(), (String)ResponseAndMessageEnum.USER_INVALID.getCode());
            }
            if (!ObjectUtils.isEmpty((Object)adminSmUserDto.getDeadline())) {
                // empty if block
            }
            UserEntityVo userEntityVoDb = new UserEntityVo();
            org.springframework.beans.BeanUtils.copyProperties((Object)adminSmUserDto, (Object)userEntityVoDb);
            boolean isValid = this.passwordUtils.checkSecret(adminSmUserDto.getUserPassword(), password);
            if (isValid) {
                return ResultDto.success().code(ResponseAndMessageEnum.SUCCESS.getCode()).message(ResponseAndMessageEnum.SUCCESS.getMessage()).data((Object)userEntityVoDb);
            }
            return ResultDto.error((String)ResponseAndMessageEnum.BAD_CREDENTIALS.getCode(), (String)ResponseAndMessageEnum.BAD_CREDENTIALS.getMessage()).extParam((Object)"loginCode", (Object)loginCode);
        }
        return ResultDto.error((String)ResponseAndMessageEnum.NON_USER.getCode(), (String)ResponseAndMessageEnum.NON_USER.getMessage());
    }

    public ResultDto<UserEntityVo> getUserInfoWithLoginCode(String loginCode) throws Exception {
        AdminSmUserDto adminSmUserDto = new AdminSmUserDto();
        adminSmUserDto.setLoginCode(loginCode);
        adminSmUserDto = this.adminSmUserService.show(adminSmUserDto);
        if (Objects.nonNull(adminSmUserDto)) {
            if (StringUtils.nonEmpty((CharSequence)adminSmUserDto.getUserSts()) && !StringUtils.equals((CharSequence)AvailableStateEnum.ENABLED.getCode(), (CharSequence)adminSmUserDto.getUserSts())) {
                return ResultDto.error((String)ResponseAndMessageEnum.USER_INVALID.getCode(), (String)ResponseAndMessageEnum.USER_INVALID.getCode());
            }
            if (!ObjectUtils.isEmpty((Object)adminSmUserDto.getDeadline())) {
                // empty if block
            }
            UserEntityVo userEntityVo = new UserEntityVo();
            userEntityVo.setUserPassword(adminSmUserDto.getUserPassword());
            BeanUtils.beanCopy((Object)adminSmUserDto, (Object)userEntityVo);
            return ResultDto.success().code(ResponseAndMessageEnum.SUCCESS.getCode()).message(ResponseAndMessageEnum.SUCCESS.getMessage()).data((Object)userEntityVo);
        }
        return ResultDto.error((String)ResponseAndMessageEnum.NON_USER.getCode(), (String)ResponseAndMessageEnum.NON_USER.getMessage());
    }
}

