/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.service.impl;

import cn.com.yusys.yusp.oca.aggregation.AdminSmMenuAggregation;
import cn.com.yusys.yusp.oca.assembler.AdminSmMenuAssembler;
import cn.com.yusys.yusp.oca.dto.AdminSmMenuDto;
import cn.com.yusys.yusp.oca.dto.MenuTransDto;
import cn.com.yusys.yusp.oca.dto.query.AdminSmMenuQueryDto;
import cn.com.yusys.yusp.oca.entity.AdminSmMenuEntity;
import cn.com.yusys.yusp.oca.entity.MenuTransEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmMenuRepository;
import cn.com.yusys.yusp.oca.service.AdminSmMenuService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="adminSmMenuService")
@Transactional
public class AdminSmMenuServiceImpl
implements AdminSmMenuService {
    private static final Logger logger = LoggerFactory.getLogger(AdminSmMenuServiceImpl.class);
    @Autowired
    private AdminSmMenuRepository adminSmMenuRepository;
    @Autowired
    private AdminSmMenuAggregation adminSmMenuAggregation;

    @Transactional(readOnly=true)
    public List<AdminSmMenuDto> getMenuTree(AdminSmMenuQueryDto adminSmMenuQueryDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuQueryDto);
        return this.adminSmMenuAggregation.getMenuTree(entity);
    }

    public Map<String, Object> getMenuInfo(AdminSmMenuQueryDto adminSmMenuQueryDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuQueryDto);
        return this.adminSmMenuRepository.getMenuInfo(entity);
    }

    public int create(AdminSmMenuDto adminSmMenuDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuDto);
        return this.adminSmMenuRepository.insert(entity);
    }

    public int update(AdminSmMenuDto adminSmMenuDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuDto);
        return this.adminSmMenuRepository.updateByPrimaryKey(entity);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int delete(AdminSmMenuQueryDto adminSmMenuDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuDto);
        return this.adminSmMenuAggregation.delete(entity);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> getFuncInfo(AdminSmMenuQueryDto adminSmMenuQueryDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuQueryDto);
        return this.adminSmMenuRepository.getFuncInfo(entity);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> queryMenu(AdminSmMenuQueryDto adminSmMenuQueryDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuQueryDto);
        return this.adminSmMenuRepository.queryMenu(entity);
    }

    @Transactional(readOnly=true)
    public List<Map<String, Object>> queryTradeMenu(AdminSmMenuQueryDto adminSmMenuQueryDto) {
        AdminSmMenuEntity entity = AdminSmMenuAssembler.toEntity(adminSmMenuQueryDto);
        return this.adminSmMenuRepository.queryTradeMenu(entity);
    }

    public void orderTransform(MenuTransDto menuTransDto) {
        MenuTransEntity menuTransEntity = AdminSmMenuAssembler.toMenuTransEntity(menuTransDto);
        this.adminSmMenuAggregation.orderTransform(menuTransEntity);
    }
}

