/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.service.impl;

import cn.com.yusys.yusp.common.mybatis.IcspPage;
import cn.com.yusys.yusp.oca.aggregation.AdminSmDutyAggregation;
import cn.com.yusys.yusp.oca.assembler.AdminSmDutyAssembler;
import cn.com.yusys.yusp.oca.assembler.AdminSmDutyRoleRelAssembler;
import cn.com.yusys.yusp.oca.assembler.AdminSmUserAssembler;
import cn.com.yusys.yusp.oca.assembler.AdminSmUserDutyRelAssembler;
import cn.com.yusys.yusp.oca.bp.DutyId;
import cn.com.yusys.yusp.oca.dataobj.AdminSmDutyDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSsoSystemConfigDo;
import cn.com.yusys.yusp.oca.dto.AdminDutyRoleDto;
import cn.com.yusys.yusp.oca.dto.AdminSmDutyDto;
import cn.com.yusys.yusp.oca.dto.AdminSmDutyRoleRelDto;
import cn.com.yusys.yusp.oca.dto.AdminSmUserDto;
import cn.com.yusys.yusp.oca.dto.AdminUserDutyDto;
import cn.com.yusys.yusp.oca.entity.AdminSmDutyEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmDutyRoleRelEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserDutyRelEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmDutyRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUpdateLogRepository;
import cn.com.yusys.yusp.oca.service.AdminSmDutyService;
import cn.com.yusys.yusp.oca.specification.AdminSmDutySpecification;
import cn.com.yusys.yusp.sequence.service.SequenceTemplateService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AdminSmDutyServiceImpl
implements AdminSmDutyService {
    @Autowired
    @Lazy
    private SequenceTemplateService sequenceTemplateService;
    @Autowired
    private AdminSmDutyRepository adminSmDutyRepository;
    @Autowired
    private AdminSmUpdateLogRepository adminSmUpdateLogRepository;
    @Autowired
    private AdminSmDutySpecification adminSmDutySpecification;
    @Autowired
    private AdminSmDutyAggregation adminSmDutyAggregation;

    public int create(AdminSmDutyDto adminSmDutyDto) {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.toAdminSmDuty(adminSmDutyDto, "D1");
        this.adminSmDutySpecification.isSatisfiedBy(adminSmDutyEntity);
        return this.adminSmDutyAggregation.store(adminSmDutyEntity);
    }

    public AdminSmDutyDo show(AdminSmDutyDto adminSmDutyDto) throws Exception {
        return this.adminSmDutyRepository.show(adminSmDutyDto);
    }

    public IcspPage<AdminSmDutyDto> index(AdminSmDutyDto adminSmDutyDto) throws Exception {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.dtoToEntity(adminSmDutyDto);
        IcspPage index = this.adminSmDutyRepository.index(adminSmDutyEntity);
        return AdminSmDutyAssembler.toPageDto((IcspPage<AdminSmDutyEntity>)index);
    }

    public IcspPage<AdminSmDutyDto> list(AdminSmDutyDto adminSmDutyDto) throws Exception {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.dtoToEntity(adminSmDutyDto);
        IcspPage list = this.adminSmDutyRepository.list(adminSmDutyEntity);
        return AdminSmDutyAssembler.toPageDto((IcspPage<AdminSmDutyEntity>)list);
    }

    public int update(AdminSmDutyDto adminSmDutyDto) throws Exception {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.toAdminSmDuty(adminSmDutyDto, "D2");
        this.adminSmDutySpecification.isSatisfiedByUpdate(adminSmDutyEntity);
        return this.adminSmDutyAggregation.update(adminSmDutyEntity);
    }

    public int delete(AdminSmDutyDto adminSmDutyDto) throws Exception {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.toAdminSmDuty(new DutyId(adminSmDutyDto.getDutyId()), "D3");
        this.adminSmDutySpecification.isSatisfiedByUpdate(adminSmDutyEntity);
        return this.adminSmDutyAggregation.delete(adminSmDutyEntity);
    }

    public IcspPage<AdminSmUserDto> queryUserByDuty(AdminSmDutyDto adminSmDutyDto) {
        return AdminSmUserAssembler.toPageDto((IcspPage<AdminSmUserEntity>)this.adminSmDutyRepository.queryUserByDuty(adminSmDutyDto));
    }

    public List<AdminSsoSystemConfigDo> querySsoByDuty() {
        return this.adminSmDutyRepository.querySsoByDuty();
    }

    public int addUserByDuty(AdminUserDutyDto adminUserDutyDto) {
        List<AdminSmUserDutyRelEntity> adminSmUserDutyRelEntities = AdminSmUserDutyRelAssembler.initAddUser(adminUserDutyDto);
        int i = this.adminSmDutyAggregation.addUserByDuty(adminSmUserDutyRelEntities);
        return i;
    }

    public IcspPage<AdminSmDutyRoleRelDto> queryRoleByDuty(AdminSmDutyRoleRelDto adminSmDutyRoleRelDto) {
        AdminSmDutyRoleRelEntity adminSmDutyRoleRelEntity = AdminSmDutyRoleRelAssembler.dtoToEntity(adminSmDutyRoleRelDto);
        return AdminSmDutyRoleRelAssembler.toDtoPage((IcspPage<AdminSmDutyRoleRelEntity>)this.adminSmDutyRepository.queryRoleByDuty(adminSmDutyRoleRelEntity));
    }

    public int addRoleByDuty(AdminDutyRoleDto adminDutyRoleDto) {
        AdminSmDutyEntity adminSmDutyEntity = AdminSmDutyAssembler.toAdminSmDuty(adminDutyRoleDto);
        this.adminSmDutyRepository.deleteOldRel(adminSmDutyEntity);
        return this.adminSmDutyRepository.addNewRel(adminSmDutyEntity);
    }
}

