/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.repository.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.mybatis.IcspPage;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.oca.assembler.AdminSmUserAssembler;
import cn.com.yusys.yusp.oca.assembler.AdminSmUserRoleRelAssembler;
import cn.com.yusys.yusp.oca.bp.LoginOrg;
import cn.com.yusys.yusp.oca.dao.AdminSmUserDao;
import cn.com.yusys.yusp.oca.dataobj.AdminSmUserDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSmUserRoleRelDo;
import cn.com.yusys.yusp.oca.dto.AdminSmUserDto;
import cn.com.yusys.yusp.oca.dto.AdminUserParamDto;
import cn.com.yusys.yusp.oca.dto.query.LoginOrgDto;
import cn.com.yusys.yusp.oca.entity.AdminSmUserEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserRoleRelEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmUserRepository;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminSmUserRepositoryImpl
implements AdminSmUserRepository {
    @Autowired
    private AdminSmUserDao adminSmUserDao;
    private static final String ORG_ID = "orgId";

    public int insert(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = AdminSmUserAssembler.toDo(adminSmUserEntity);
        return this.adminSmUserDao.insert(adminSmUserDo);
    }

    public IcspPage<AdminSmUserEntity> index(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = AdminSmUserAssembler.toDo(adminSmUserEntity);
        QueryModel queryModel = AdminSmUserAssembler.buildQueryModel((Object)adminSmUserDo);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmUserDo> adminSmUserDos = this.adminSmUserDao.selectByModel(queryModel);
        PageHelper.clearPage();
        IcspPage adminSmUserDoIcspPage = AdminSmUserAssembler.buildIcspPage(adminSmUserDos);
        return AdminSmUserAssembler.toPageEntity((IcspPage<AdminSmUserDo>)adminSmUserDoIcspPage);
    }

    public IcspPage<AdminSmUserEntity> list(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = AdminSmUserAssembler.toDo(adminSmUserEntity);
        QueryModel queryModel = AdminSmUserAssembler.buildQueryModel((Object)adminSmUserDo);
        List<AdminSmUserDo> adminSmUserDos = this.adminSmUserDao.selectByModel(queryModel);
        IcspPage adminSmUserDoIcspPage = AdminSmUserAssembler.buildIcspPage(adminSmUserDos);
        return AdminSmUserAssembler.toPageEntity((IcspPage<AdminSmUserDo>)adminSmUserDoIcspPage);
    }

    public AdminSmUserEntity selectByLoginCode(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = this.adminSmUserDao.selectByLoginCode(adminSmUserEntity.getLoginCode());
        return AdminSmUserAssembler.toEntity(adminSmUserDo);
    }

    public AdminSmUserEntity selectByPrimaryKey(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = this.adminSmUserDao.selectByPrimaryKey(adminSmUserEntity.getUserId());
        if (adminSmUserDo == null) {
            throw new IcspException("500", "\u672a\u83b7\u53d6\u5230\u6570\u636e");
        }
        return AdminSmUserAssembler.toEntity(adminSmUserDo);
    }

    public List<AdminSmUserDo> selectByModel(QueryModel model) {
        return this.adminSmUserDao.selectByModel(model);
    }

    public int updateByPrimaryKey(AdminSmUserEntity adminSmUser) {
        AdminSmUserDo adminSmUserDo = AdminSmUserAssembler.toDo(adminSmUser);
        return this.adminSmUserDao.updateByPrimaryKey(adminSmUserDo);
    }

    public int deleteByPrimaryKey(String userId) {
        return 0;
    }

    public List<AdminSmUserEntity> select(AdminSmUserDto adminSmUserDto) {
        QueryModel queryModel = new QueryModel();
        queryModel.setCondition(BeanUtils.beanCopy((Object)adminSmUserDto, (Object)new AdminSmUserDo()));
        List<AdminSmUserDo> adminSmUserDos = this.adminSmUserDao.selectByModel(queryModel);
        return AdminSmUserAssembler.toEntityList(adminSmUserDos);
    }

    public AdminSmUserEntity queryUser(AdminSmUserEntity adminSmUserEntity) {
        List<LoginOrgDto> orgList = this.adminSmUserDao.queryRoleOrg(adminSmUserEntity.getLoginCode());
        List<LoginOrg> loginOrgs = AdminSmUserAssembler.toListLoginOrg(orgList);
        if (loginOrgs == null || loginOrgs.isEmpty()) {
            loginOrgs = new ArrayList<LoginOrg>();
            LoginOrg loginOrg = new LoginOrg();
            loginOrg.setValue(adminSmUserEntity.getOrgId());
            loginOrg.setText(adminSmUserEntity.getOrgName());
            loginOrgs.add(loginOrg);
        }
        adminSmUserEntity.setLoginOrgs(loginOrgs);
        return adminSmUserEntity;
    }

    public int enable(String userId, String userSts) {
        return this.adminSmUserDao.enable(userId, userSts);
    }

    public List<AdminUserParamDto> queryDutyByUser(AdminSmUserEntity adminSmUserEntity) {
        List<Map<String, String>> maps = this.adminSmUserDao.queryDutyByUser(adminSmUserEntity.getUserId(), null, adminSmUserEntity.getModId());
        return this.trimDR(maps);
    }

    public List<AdminUserParamDto> queryRoleByUser(AdminSmUserEntity adminSmUserEntity) {
        List<Map<String, String>> maps = this.adminSmUserDao.queryRoleByUser(adminSmUserEntity.getUserId(), null, adminSmUserEntity.getModId());
        return this.trimDR(maps);
    }

    public AdminSmUserEntity selectHrByCert(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDo adminSmUserDo = this.adminSmUserDao.selectHrByCert(adminSmUserEntity.getCertNo());
        return AdminSmUserAssembler.toEntity(adminSmUserDo);
    }

    public int deleteUserRoleRel(String userId, String modId) {
        return this.adminSmUserDao.deleteUserRoleRel(userId, modId);
    }

    public int deleteUserDutyRel(String userId, String modId) {
        return this.adminSmUserDao.deleteUserDutyRel(userId, modId);
    }

    public int orgTransfer(AdminSmUserEntity adminSmUserEntity) {
        return this.adminSmUserDao.orgTransfer(adminSmUserEntity.getUserId(), adminSmUserEntity.getTargetOrg().getOrgId());
    }

    public IcspPage<AdminSmUserEntity> queryUserWithoutRole(AdminSmUserRoleRelEntity adminSmUserRoleRelEntity) {
        AdminSmUserRoleRelDo adminSmUserRoleRelDo = AdminSmUserRoleRelAssembler.entityToDo(adminSmUserRoleRelEntity);
        QueryModel queryModel = AdminSmUserRoleRelAssembler.buildQueryModel((Object)adminSmUserRoleRelDo);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmUserDo> adminSmUserDos = this.adminSmUserDao.queryUserWithoutRole(queryModel);
        PageHelper.clearPage();
        IcspPage adminSmUserDoIcspPage = AdminSmUserAssembler.buildIcspPage(adminSmUserDos);
        return AdminSmUserAssembler.toPageEntity((IcspPage<AdminSmUserDo>)adminSmUserDoIcspPage);
    }

    public IcspPage<AdminSmUserEntity> queryUserByParam(AdminSmUserEntity adminSmUserEntity) {
        AdminSmUserDto adminSmUserDto = AdminSmUserAssembler.toDto(adminSmUserEntity);
        QueryModel queryModel = AdminSmUserAssembler.buildQueryModel((Object)adminSmUserDto);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmUserDo> adminSmUserDos = this.adminSmUserDao.queryUserByParam(queryModel);
        PageHelper.clearPage();
        IcspPage adminSmUserDoIcspPage = AdminSmUserAssembler.buildIcspPage(adminSmUserDos);
        return AdminSmUserAssembler.toPageEntity((IcspPage<AdminSmUserDo>)adminSmUserDoIcspPage);
    }

    private List<AdminUserParamDto> trimDR(List<Map<String, String>> list) {
        ArrayList<AdminUserParamDto> result = new ArrayList<AdminUserParamDto>();
        if (list.size() > 0) {
            for (Map<String, String> map : list) {
                AdminUserParamDto adminUserParamDto = new AdminUserParamDto();
                ArrayList<Map<String, String>> roleList = new ArrayList<Map<String, String>>();
                if (result.size() > 0) {
                    int num = 0;
                    if ((num = this.forResult(result, map, num).intValue()) != 0) continue;
                    adminUserParamDto.setOrgId(map.get(ORG_ID));
                    adminUserParamDto.setOrgName(map.get("orgName"));
                    roleList.add(map);
                    adminUserParamDto.setList(roleList);
                    result.add(adminUserParamDto);
                    continue;
                }
                adminUserParamDto.setOrgId(map.get(ORG_ID));
                adminUserParamDto.setOrgName(map.get("orgName"));
                roleList.add(map);
                adminUserParamDto.setList(roleList);
                result.add(adminUserParamDto);
            }
        }
        return result;
    }

    private Integer forResult(List<AdminUserParamDto> result, Map<String, String> map, int num) {
        for (AdminUserParamDto userRoleDto : result) {
            if (!userRoleDto.getOrgId().equals(map.get(ORG_ID))) continue;
            userRoleDto.getList().add(map);
            ++num;
        }
        return num;
    }
}

