/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.repository.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.mybatis.IcspPage;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.assembler.AdminSmDataAuthAssembler;
import cn.com.yusys.yusp.oca.bp.LastChgDt;
import cn.com.yusys.yusp.oca.bp.LastChgUser;
import cn.com.yusys.yusp.oca.dao.AdminSmDataAuthDao;
import cn.com.yusys.yusp.oca.dataobj.AdminDataAuthMenuDo;
import cn.com.yusys.yusp.oca.dataobj.AdminDateAuthTreeDo;
import cn.com.yusys.yusp.oca.dataobj.AdminSmDataAuthDo;
import cn.com.yusys.yusp.oca.entity.AdminDataAuthMenuEntity;
import cn.com.yusys.yusp.oca.entity.AdminDateAuthTreeEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmDataAuthEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmDataAuthRepository;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminSmDataAuthRepositoryImpl
implements AdminSmDataAuthRepository {
    @Autowired
    private AdminSmDataAuthDao adminSmDataAuthDao;

    public int create(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        adminSmDataAuthEntity.setLastChgUser(new LastChgUser(SessionUtils.getUserId()));
        adminSmDataAuthEntity.setLastChgDt(new LastChgDt(DateUtils.formatDateTimeByDef()));
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        return this.adminSmDataAuthDao.insert(adminSmDataAuthDo);
    }

    public AdminSmDataAuthEntity show(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        QueryModel queryModel = AdminSmDataAuthAssembler.buildQueryModel((Object)adminSmDataAuthDo);
        List<AdminSmDataAuthDo> list = this.adminSmDataAuthDao.selectByModel(queryModel);
        if (list == null || list.size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728[authId=" + adminSmDataAuthEntity.getAuthId() + "]");
        }
        return AdminSmDataAuthAssembler.toEntity(list.get(0));
    }

    public IcspPage<AdminSmDataAuthEntity> index(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        QueryModel queryModel = AdminSmDataAuthAssembler.buildQueryModel((Object)adminSmDataAuthDo);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmDataAuthDo> list = this.adminSmDataAuthDao.selectByModel(queryModel);
        PageHelper.clearPage();
        IcspPage icspPage = AdminSmDataAuthAssembler.buildIcspPage(list);
        return AdminSmDataAuthAssembler.toEntityPage((IcspPage<AdminSmDataAuthDo>)icspPage);
    }

    public List<AdminSmDataAuthEntity> list(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        QueryModel queryModel = AdminSmDataAuthAssembler.buildQueryModel((Object)adminSmDataAuthDo);
        List<AdminSmDataAuthDo> list = this.adminSmDataAuthDao.selectByModel(queryModel);
        return AdminSmDataAuthAssembler.toEntity(list);
    }

    public int update(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        adminSmDataAuthDo.setAuthId(StringUtils.getUUID());
        adminSmDataAuthDo.setContrId(StringUtils.getUUID());
        adminSmDataAuthDo.setLastChgDt(DateUtils.formatDateTimeByDef());
        adminSmDataAuthDo.setLastChgUser(SessionUtils.getUserId());
        return this.adminSmDataAuthDao.updateByPrimaryKey(adminSmDataAuthDo);
    }

    public int delete(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        return this.adminSmDataAuthDao.deleteByPrimaryKey(adminSmDataAuthEntity.getAuthId().getValue());
    }

    public IcspPage<AdminSmDataAuthEntity> queryInfo(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        QueryModel queryModel = AdminSmDataAuthAssembler.buildQueryModel((Object)adminSmDataAuthDo);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmDataAuthDo> list = this.adminSmDataAuthDao.queryInfo(queryModel);
        PageHelper.clearPage();
        IcspPage icspPage = AdminSmDataAuthAssembler.buildIcspPage(list);
        return AdminSmDataAuthAssembler.toEntityPage((IcspPage<AdminSmDataAuthDo>)icspPage);
    }

    public List<AdminSmDataAuthEntity> queryInfoWithout(AdminSmDataAuthEntity adminSmDataAuthEntity) {
        AdminSmDataAuthDo adminSmDataAuthDo = AdminSmDataAuthAssembler.toAdminSmDataAuthDo(adminSmDataAuthEntity);
        List<AdminSmDataAuthDo> list = this.adminSmDataAuthDao.queryInfoWithout(adminSmDataAuthDo);
        return AdminSmDataAuthAssembler.toEntity(list);
    }

    public List<AdminDateAuthTreeEntity> treeQuery(AdminDateAuthTreeEntity adminDateAuthTreeEntity) {
        AdminDateAuthTreeDo adminDateAuthTreeDo = AdminSmDataAuthAssembler.toAdminDateAuthTreeDo(adminDateAuthTreeEntity);
        List<AdminDateAuthTreeDo> list = this.adminSmDataAuthDao.treeQuery(adminDateAuthTreeDo);
        return AdminSmDataAuthAssembler.toTreeEntity(list);
    }

    public List<AdminDataAuthMenuEntity> dataMenuTreeQuery(AdminDataAuthMenuEntity adminDataAuthMenuEntity) {
        List<AdminDataAuthMenuDo> list = this.adminSmDataAuthDao.dataMenuTreeQuery(adminDataAuthMenuEntity.getSysId());
        return AdminSmDataAuthAssembler.toMenuEntity(list);
    }
}

