/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.config;

import cn.com.yusys.yusp.common.utils.Md5PasswordEncoder;
import cn.com.yusys.yusp.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;
import org.springframework.security.crypto.password.StandardPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

@Configuration
public class PasswordEncoderConfig {
    @Value(value="${yusp.user.password-encrypt-type:Bcrypt}")
    private String encryptType;

    @Bean
    public PasswordEncoder passwordEncoder() {
        switch (StringUtils.lowerCase((String)this.encryptType)) {
            case "stand": {
                return new StandardPasswordEncoder();
            }
            case "md5": {
                return new Md5PasswordEncoder();
            }
            case "scrypt": {
                return new SCryptPasswordEncoder();
            }
            case "pbkdf2": {
                return new Pbkdf2PasswordEncoder();
            }
        }
        return new BCryptPasswordEncoder();
    }
}

