/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.aggregation.impl;

import cn.com.yusys.yusp.common.exception.IcspException;
import cn.com.yusys.yusp.common.mapper.QueryModel;
import cn.com.yusys.yusp.common.mybatis.IcspPage;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.oca.aggregation.AdminSmUserAggregation;
import cn.com.yusys.yusp.oca.bp.ApplyScope;
import cn.com.yusys.yusp.oca.bp.DutyId;
import cn.com.yusys.yusp.oca.bp.LastChgDt;
import cn.com.yusys.yusp.oca.bp.LastChgUser;
import cn.com.yusys.yusp.oca.bp.UserPassword;
import cn.com.yusys.yusp.oca.dataobj.AdminSmDutyDo;
import cn.com.yusys.yusp.oca.dataobj.vo.AdminSmUserDutyRelVo;
import cn.com.yusys.yusp.oca.dataobj.vo.AdminSmUserRoleRelVo;
import cn.com.yusys.yusp.oca.dto.AdminUserParamDto;
import cn.com.yusys.yusp.oca.entity.AdminSmModCompatibleEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmOrgEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmRoleEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUpdateLogEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserDutyRelEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserEntity;
import cn.com.yusys.yusp.oca.entity.AdminSmUserRoleRelEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmApplyScopeRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmAuthRecoRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmDutyRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmModCompatibleRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmOrgRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmRoleQualifyRelRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmRoleRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUpdateLogRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUserDutyRelRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUserRepository;
import cn.com.yusys.yusp.oca.repository.AdminSmUserRoleRelRepository;
import cn.com.yusys.yusp.oca.repository.AdminUserCrelStraRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminSmUserAggregationImpl
implements AdminSmUserAggregation {
    private Logger logger = LoggerFactory.getLogger(AdminSmUserAggregationImpl.class);
    private static final String ERROR = "\u7528\u6237\u4fee\u6539\u89d2\u8272\u65e5\u5fd7\u8bb0\u5f55\u62a5\u9519\uff1a";
    private static final String DEPT_ERROR = "\u7528\u6237\u4fee\u6539\u5c97\u4f4d\u65e5\u5fd7\u8bb0\u5f55\u62a5\u9519\uff1a";
    private static final String ORG_ID = "orgId";
    private static final String PARAM = "param";
    @Autowired
    private AdminSmUserRepository adminSmUserRepository;
    @Autowired
    private AdminSmUpdateLogRepository adminSmUpdateLogRepository;
    @Autowired
    private AdminSmUserRoleRelRepository adminSmUserRoleRelRepository;
    @Autowired
    private AdminSmUserDutyRelRepository adminSmUserDutyRelRepository;
    @Autowired
    private AdminSmAuthRecoRepository adminSmAuthRecoRepository;
    @Autowired
    AdminUserCrelStraRepository adminUserCrelStraRepository;
    @Autowired
    AdminSmModCompatibleRepository adminSmModCompatibleRepository;
    @Autowired
    AdminSmOrgRepository adminSmOrgRepository;
    @Autowired
    AdminSmRoleRepository adminSmRoleRepository;
    @Autowired
    AdminSmApplyScopeRepository adminSmApplyScopeRepository;
    @Autowired
    AdminSmRoleQualifyRelRepository adminSmRoleQualifyRelRepository;
    @Autowired
    AdminSmDutyRepository adminSmDutyRepository;

    public int save(AdminSmUserEntity adminSmUserEntity) {
        int insert = this.adminSmUserRepository.insert(adminSmUserEntity);
        if (insert < 1) {
            throw new IcspException("500", "\u65b0\u589e\u5931\u8d25");
        }
        this.adminSmUpdateLogRepository.save(adminSmUserEntity.getSmUpdateLog());
        return insert;
    }

    public int unlock(AdminSmUserEntity adminSmUserEntity) {
        return 0;
    }

    public int enable(AdminSmUserEntity adminSmUserEntity) {
        int enable = this.adminSmUserRepository.enable(adminSmUserEntity.getUserId(), adminSmUserEntity.getUserSts());
        if (enable > 0) {
            this.adminSmUpdateLogRepository.save(adminSmUserEntity.getSmUpdateLog());
            if ("I".equals(adminSmUserEntity.getUserSts())) {
                IcspPage adminSmUserRoleRelVoIcspPage = this.adminSmUserRoleRelRepository.selectRoleInfo(adminSmUserEntity.getAdminSmUserRoleRelEntity());
                IcspPage adminSmUserDutyRelVoIcspPage = this.adminSmUserDutyRelRepository.selectDutyInfo(adminSmUserEntity.getAdminSmUserDutyRelEntity());
                int r = this.adminSmUserRoleRelRepository.deleteByUserId(adminSmUserEntity.getAdminSmUserRoleRelEntity());
                int d = this.adminSmUserDutyRelRepository.deleteByUserId(adminSmUserEntity.getAdminSmUserDutyRelEntity());
                int auth = this.adminSmAuthRecoRepository.deleteByUserId(adminSmUserEntity.getUserId());
                this.logger.info(adminSmUserEntity.getUserId() + "\u7528\u6237\u5220\u9664\u89d2\u8272\u5173\u8054" + r + "\u6761\uff0c\u5220\u9664\u5c97\u4f4d\u5173\u8054" + d + "\u6761\uff0c\u5220\u9664\u7528\u6237\u7ea7\u522b\u6743\u9650" + auth + "\u6761");
                this.ifR(r, adminSmUserEntity, (IcspPage<AdminSmUserRoleRelVo>)adminSmUserRoleRelVoIcspPage);
                if (d > 0) {
                    adminSmUserEntity.initUpdateDuty(adminSmUserDutyRelVoIcspPage.getData());
                    try {
                        this.adminSmUpdateLogRepository.save(adminSmUserEntity.getAdminSmUpdateLogEntityDuty());
                    }
                    catch (Exception e) {
                        this.logger.info(DEPT_ERROR + e.getMessage());
                    }
                }
            }
        }
        return enable;
    }

    public void ifR(int r, AdminSmUserEntity adminSmUserEntity, IcspPage<AdminSmUserRoleRelVo> adminSmUserRoleRelVoIcspPage) {
        if (r > 0) {
            adminSmUserEntity.initUpdateRole(adminSmUserRoleRelVoIcspPage.getData());
            try {
                this.adminSmUpdateLogRepository.save(adminSmUserEntity.getAdminSmUpdateLogEntityRole());
            }
            catch (Exception e) {
                this.logger.info(ERROR + e.getMessage());
            }
        }
    }

    public int update(AdminSmUserEntity adminSmUserEntity) {
        int result;
        if (adminSmUserEntity.getUserPassword() != null && !StringUtils.isEmpty((CharSequence)adminSmUserEntity.getUserPassword().getValue())) {
            UserPassword userPassword = adminSmUserEntity.getUserPassword();
            userPassword.decypt();
            userPassword.encrypt();
        }
        if ((result = this.adminSmUserRepository.updateByPrimaryKey(adminSmUserEntity)) > 0) {
            this.adminSmUpdateLogRepository.save(adminSmUserEntity.getSmUpdateLog());
        }
        return result;
    }

    public AdminSmUserEntity show(AdminSmUserEntity adminSmUserEntity) {
        IcspPage index = this.adminSmUserRepository.index(adminSmUserEntity);
        if (index.getData() == null || index.getData().size() == 0) {
            throw new IcspException("500", "\u6570\u636e\u4e0d\u5b58\u5728" + adminSmUserEntity.getUserId());
        }
        AdminSmUserEntity adminSmUserEntity1 = (AdminSmUserEntity)index.getData().get(0);
        String passwd_change_rule = this.adminUserCrelStraRepository.selectByCrelName("PASSWD_CHANGE_RULE");
        int days = Integer.parseInt(passwd_change_rule);
        if (StringUtils.isEmpty((CharSequence)adminSmUserEntity1.getLastEditPassTime())) {
            adminSmUserEntity1.setLastEditPassTime(DateUtils.formatDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        adminSmUserEntity1.setLastEditPassTime(DateUtils.addDay((String)adminSmUserEntity1.getLastEditPassTime(), (String)"yyyy-MM-dd HH:mm:ss", (int)days));
        return adminSmUserEntity1;
    }

    public AdminSmUserEntity queryUserByCert(AdminSmUserEntity adminSmUserEntity) {
        IcspPage index = this.adminSmUserRepository.index(adminSmUserEntity);
        if (index.getData() != null && index.getData().size() > 0) {
            return (AdminSmUserEntity)index.getData().get(0);
        }
        AdminSmUserEntity userEntity = this.adminSmUserRepository.selectHrByCert(adminSmUserEntity);
        if (userEntity != null) {
            return userEntity;
        }
        return null;
    }

    public int saveUserParam(AdminSmUserEntity adminSmUserEntity) throws Exception {
        AdminUserParamDto adminUserParamDto = adminSmUserEntity.getAdminUserParamDto();
        String type = adminUserParamDto.getType();
        List relatedData = adminUserParamDto.getList();
        int result = 0;
        if ("role".equals(type)) {
            result = this.saveRole(adminSmUserEntity, "");
        } else if ("duty".equals(type)) {
            result = this.saveDuty(adminSmUserEntity, "");
        }
        return result;
    }

    public int orgTransfer(AdminSmUserEntity adminSmUserEntity) {
        int result = this.adminSmUserRepository.orgTransfer(adminSmUserEntity);
        if (result > 0) {
            this.adminSmUpdateLogRepository.save(adminSmUserEntity.getSmUpdateLog());
        }
        return 0;
    }

    private Integer saveRole(AdminSmUserEntity adminSmUserEntity, String workDate) throws Exception {
        int result = 0;
        AdminUserParamDto adminUserParamDto = adminSmUserEntity.getAdminUserParamDto();
        List relatedData = adminUserParamDto.getList();
        StringBuilder oldInfos = new StringBuilder();
        StringBuilder newInfos = new StringBuilder();
        ArrayList<AdminSmUserRoleRelVo> urList = new ArrayList<AdminSmUserRoleRelVo>();
        this.ifNonEmpty(adminUserParamDto, urList, adminSmUserEntity, relatedData, oldInfos);
        String updateLogId = StringUtils.getUUID();
        if (relatedData != null && relatedData.size() > 0) {
            ArrayList<AdminSmUserRoleRelEntity> list = new ArrayList<AdminSmUserRoleRelEntity>();
            result = this.forMap(relatedData, adminUserParamDto, result, newInfos, list);
            AdminSmUpdateLogEntity adminSmUpdateLogEntity = new AdminSmUpdateLogEntity();
            adminSmUpdateLogEntity.setUpdateLogId(updateLogId);
            adminSmUpdateLogEntity.setRecoType("UR2");
            adminSmUpdateLogEntity.setRecoId(adminUserParamDto.getUserId());
            AdminSmUserEntity adminSmUserEntity1 = new AdminSmUserEntity();
            adminSmUserEntity1.setUserId(adminUserParamDto.getUserId());
            AdminSmUserEntity adminSmUserEntity2 = this.adminSmUserRepository.selectByPrimaryKey(adminSmUserEntity1);
            adminSmUpdateLogEntity.setRecoName(adminSmUserEntity.getUserName());
            adminSmUpdateLogEntity.setOperUserId(SessionUtils.getUserId());
            adminSmUpdateLogEntity.setUpdateContent(ObjectMapperUtils.toJson(list));
            adminSmUpdateLogEntity.setRemark("\u3010" + adminUserParamDto.getUserName() + "\u3011\u7528\u6237\u89d2\u8272\u4fee\u6539\r\n" + oldInfos.toString() + newInfos.toString());
            adminSmUpdateLogEntity.setWorkDate(workDate);
            try {
                this.adminSmUpdateLogRepository.save(adminSmUpdateLogEntity);
            }
            catch (Exception e) {
                this.logger.info(ERROR + e.getMessage());
            }
            IcspPage icspPage = this.adminSmUserRoleRelRepository.list(adminSmUserEntity.getAdminSmUserRoleRelEntity());
        } else {
            AdminSmUpdateLogEntity adminSmUpdateLogEntity = new AdminSmUpdateLogEntity();
            adminSmUpdateLogEntity.setUpdateLogId(updateLogId);
            adminSmUpdateLogEntity.setRecoType("UR3");
            adminSmUpdateLogEntity.setRecoId(adminUserParamDto.getUserId());
            adminSmUpdateLogEntity.setRecoName("");
            adminSmUpdateLogEntity.setOperUserId(SessionUtils.getUserId());
            adminSmUpdateLogEntity.setUpdateContent(ObjectMapperUtils.toJson(urList));
            adminSmUpdateLogEntity.setRemark("\u3010" + adminUserParamDto.getUserName() + "\u3011\u7528\u6237\u89d2\u8272\u5220\u9664\r\n" + oldInfos);
            adminSmUpdateLogEntity.setWorkDate(workDate);
            try {
                this.adminSmUpdateLogRepository.save(adminSmUpdateLogEntity);
            }
            catch (Exception e) {
                this.logger.info(ERROR + e.getMessage());
            }
            List list = BeanUtils.beansCopy(urList, AdminSmUserRoleRelEntity.class);
        }
        return result;
    }

    private void ifNonEmpty(AdminUserParamDto adminUserParamDto, List<AdminSmUserRoleRelVo> urList, AdminSmUserEntity adminSmUserEntity, List<Map<String, String>> relatedData, StringBuilder oldInfos) throws Exception {
        if (StringUtils.nonEmpty((CharSequence)adminUserParamDto.getUserId())) {
            IcspPage adminSmUserRoleRelVoIcspPage = this.adminSmUserRoleRelRepository.selectRoleInfo(adminSmUserEntity.getAdminSmUserRoleRelEntity());
            urList = adminSmUserRoleRelVoIcspPage.getData();
            this.delJ0006(urList, relatedData, adminUserParamDto.getUserId());
            this.adminSmUserRepository.deleteUserRoleRel(adminUserParamDto.getUserId(), adminUserParamDto.getModId());
            for (AdminSmUserRoleRelVo ur : urList) {
                oldInfos.append("\u539f\u89d2\u8272: ").append(ur.getRoleName()).append(";").append("\u539f\u673a\u6784: ").append(ur.getOrgName()).append(";").append("\u539f\u7cfb\u7edf: ").append(ur.getSsoName()).append(";  ");
            }
        }
    }

    private Integer forMap(List<Map<String, String>> relatedData, AdminUserParamDto adminUserParamDto, int result, StringBuilder newInfos, List<AdminSmUserRoleRelEntity> list) {
        for (Map<String, String> map : relatedData) {
            String orgId = map.get(ORG_ID);
            if (StringUtils.isEmpty((CharSequence)map.get(PARAM))) {
                return 0;
            }
            String[] params = map.get(PARAM).split(",");
            boolean flag = this.judgeCompatibility(params);
            if (flag) {
                throw new IcspException("500", "\u673a\u6784\u4e0b\u65b0\u589e\u7684\u89d2\u8272\u4e4b\u95f4\u4e0d\u5b58\u5728\u517c\u5bb9\u6027\uff0c\u65e0\u6cd5\u65b0\u589e");
            }
            boolean auth = this.judgeAuth(adminUserParamDto.getCurrentOrgId(), params, "R");
            if (auth) {
                throw new IcspException("500", "\u5f53\u524d\u767b\u9646\u673a\u6784\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u65b0\u589e");
            }
            result = this.forParam(params, newInfos, adminUserParamDto, orgId, list, result);
        }
        return result;
    }

    private Integer forParam(String[] params, StringBuilder newInfos, AdminUserParamDto adminUserParamDto, String orgId, List<AdminSmUserRoleRelEntity> list, int result) {
        for (String param : params) {
            List adminSmRoleQualifyRelEntities = this.adminSmRoleQualifyRelRepository.queryQualifyByUR(param, adminUserParamDto.getUserId());
            if (adminSmRoleQualifyRelEntities.size() > 0) {
                throw new IcspException("500", param + "\u89d2\u8272\u8d44\u8d28\u672a\u6ee1\u8db3\uff0c\u65e0\u6cd5\u6dfb\u52a0\u8be5\u89d2\u8272");
            }
            AdminSmRoleEntity adminSmRoleEntity = new AdminSmRoleEntity();
            adminSmRoleEntity.setRoleId(param);
            AdminSmRoleEntity adminSmRole = this.adminSmRoleRepository.selectByPrimaryKey(adminSmRoleEntity);
            newInfos.append("\u65b0\u89d2\u8272: ").append(adminSmRole.getRoleName()).append(";").append("\u65b0\u673a\u6784: ").append(adminUserParamDto.getOrgName()).append(";").append("\u65b0\u7cfb\u7edf: ").append(adminUserParamDto.getModName()).append(";  ");
            AdminSmUserRoleRelEntity adminSmUserRoleRel = new AdminSmUserRoleRelEntity();
            adminSmUserRoleRel.setUserRoleRelId(StringUtils.getUUID());
            adminSmUserRoleRel.setUserId(adminUserParamDto.getUserId());
            adminSmUserRoleRel.setRoleId(param);
            adminSmUserRoleRel.setRoleCode(adminSmRole.getRoleCode());
            adminSmUserRoleRel.setOrgId(orgId);
            adminSmUserRoleRel.setModId(adminUserParamDto.getModId());
            adminSmUserRoleRel.setRelSts("A");
            adminSmUserRoleRel.setLastChgUser(new LastChgUser());
            adminSmUserRoleRel.setLastChgDt(new LastChgDt());
            this.adminSmUserRoleRelRepository.addUserByRole(adminSmUserRoleRel);
            list.add(adminSmUserRoleRel);
            ++result;
        }
        return result;
    }

    private void delJ0006(List<AdminSmUserRoleRelVo> urList, List<Map<String, String>> relatedData, String userId) throws Exception {
        boolean a = false;
        boolean b = false;
        String orgIdO = "";
        String orgIdN = "";
        for (Map<String, String> map : relatedData) {
            if (!"J0006".equals(map.get(PARAM))) continue;
            b = true;
            orgIdN = map.get(ORG_ID);
            break;
        }
        for (AdminSmUserRoleRelVo rel : urList) {
            if (!"J0006".equals(rel.getRoleId())) continue;
            a = true;
            orgIdO = rel.getOrgId();
            break;
        }
    }

    private boolean judgeCompatibility(String[] objIds) {
        if (objIds.length == 1) {
            return false;
        }
        for (String objId : objIds) {
            List adminSmModCompatibleEntities = this.adminSmModCompatibleRepository.queryExistCompatibleRole(objId);
            if (adminSmModCompatibleEntities == null || adminSmModCompatibleEntities.size() == 0) {
                return true;
            }
            int cnt = 0;
            if ((cnt = this.forObjIds(objIds, adminSmModCompatibleEntities, cnt).intValue()) == objIds.length) continue;
            return true;
        }
        return false;
    }

    private Integer forObjIds(String[] objIds, List<AdminSmModCompatibleEntity> adminSmModCompatibleEntities, int cnt) {
        block0: for (String objId : objIds) {
            for (AdminSmModCompatibleEntity entity : adminSmModCompatibleEntities) {
                if (!objId.equals(entity.getObjId())) continue;
                ++cnt;
                continue block0;
            }
        }
        return cnt;
    }

    private boolean judgeAuth(String orgId, String[] params, String type) {
        AdminSmOrgEntity adminSmOrgEntity = new AdminSmOrgEntity();
        adminSmOrgEntity.setOrgId(orgId);
        AdminSmOrgEntity logInOrg = this.adminSmOrgRepository.selectByPrimaryKey(adminSmOrgEntity);
        if ("R".equals(type)) {
            return this.forRole(params, logInOrg);
        }
        if ("D".equals(type)) {
            return this.forDuty(params, logInOrg);
        }
        return true;
    }

    private boolean forRole(String[] params, AdminSmOrgEntity logInOrg) {
        boolean flag = false;
        for (String role : params) {
            AdminSmRoleEntity adminSmRoleEntity1 = new AdminSmRoleEntity();
            adminSmRoleEntity1.setRoleId(role);
            AdminSmRoleEntity adminSmRoleEntity = this.adminSmRoleRepository.selectByPrimaryKey(adminSmRoleEntity1);
            if ("L".equals(adminSmRoleEntity.getApplyScopeType())) {
                String level = logInOrg.getOrgLevel();
                flag = this.if1(level, flag);
                List applyScope1 = adminSmRoleEntity.getApplyScope();
                String apply = "";
                this.forScope(applyScope1, apply);
                String applyScope = apply.substring(1);
                boolean b2 = level.equals("2") && applyScope.charAt(0) == '1';
                boolean b3 = level.equals("3") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1');
                boolean b4 = level.equals("4") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1' || applyScope.charAt(2) == '1');
                flag = this.ifB(b2, b3, b4, flag);
                continue;
            }
            ApplyScope applyScope = new ApplyScope();
            applyScope.setObjType("R");
            applyScope.setObjId(role);
            String orgs = this.adminSmApplyScopeRepository.selectByApplyRelId(applyScope);
            if (orgs.contains(logInOrg.getOrgCode())) continue;
            flag = true;
        }
        return flag;
    }

    private boolean if1(String level, boolean flag) {
        if ("1".equals(level)) {
            flag = false;
        }
        return flag;
    }

    private void forScope(List<ApplyScope> applyScope1, String apply) {
        for (ApplyScope applyScope : applyScope1) {
            apply = "," + applyScope.getOrgId();
        }
    }

    private boolean ifB(boolean b2, boolean b3, boolean b4, boolean flag) {
        if (b2 || b3 || b4) {
            flag = true;
        }
        return flag;
    }

    private boolean forDuty(String[] params, AdminSmOrgEntity logInOrg) {
        boolean flag = false;
        for (String duty : params) {
            DutyId dutyId = new DutyId(duty);
            AdminSmDutyDo adminSmDutyDo = this.adminSmDutyRepository.showByDutyId(dutyId);
            if ("L".equals(adminSmDutyDo.getApplyScopeType())) {
                String level = logInOrg.getOrgLevel();
                flag = this.if1(level, flag);
                String applyScope = adminSmDutyDo.getApplyScope();
                boolean b2 = level.equals("2") && applyScope.charAt(0) == '1';
                boolean b3 = level.equals("3") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1');
                boolean b4 = level.equals("4") && (applyScope.charAt(0) == '1' || applyScope.charAt(1) == '1' || applyScope.charAt(2) == '1');
                flag = this.ifB(b2, b3, b4, flag);
                continue;
            }
            ApplyScope applyScope = new ApplyScope();
            applyScope.setObjType("D");
            applyScope.setObjId(duty);
            String orgs = this.adminSmApplyScopeRepository.selectByApplyRelId(applyScope);
            if (orgs.contains(logInOrg.getOrgCode())) continue;
            flag = true;
        }
        return flag;
    }

    private Integer saveDuty(AdminSmUserEntity adminSmUserEntity, String workDate) {
        AdminUserParamDto adminUserParamDto = adminSmUserEntity.getAdminUserParamDto();
        List relatedData = adminUserParamDto.getList();
        int result = 0;
        StringBuilder oldInfos = new StringBuilder();
        StringBuilder newInfos = new StringBuilder();
        ArrayList<AdminSmUserDutyRelVo> udList = new ArrayList<AdminSmUserDutyRelVo>();
        this.forRelateDate(adminUserParamDto, adminSmUserEntity, oldInfos, udList);
        String updateLogId = StringUtils.getUUID();
        if (relatedData != null && relatedData.size() > 0 && StringUtils.nonEmpty((CharSequence)((CharSequence)((Map)relatedData.get(0)).get(PARAM)))) {
            ArrayList<AdminSmUserDutyRelEntity> list = new ArrayList<AdminSmUserDutyRelEntity>();
            result = this.forMap1(relatedData, adminUserParamDto, list, newInfos, result);
            AdminSmUpdateLogEntity adminSmUpdateLogEntity = new AdminSmUpdateLogEntity();
            adminSmUpdateLogEntity.setUpdateLogId(updateLogId);
            adminSmUpdateLogEntity.setRecoType("UD2");
            adminSmUpdateLogEntity.setRecoId(adminUserParamDto.getUserId());
            AdminSmUserEntity adminSmUserEntity1 = this.adminSmUserRepository.selectByPrimaryKey(adminSmUserEntity);
            adminSmUpdateLogEntity.setRecoName(adminSmUserEntity1.getUserName());
            adminSmUpdateLogEntity.setOperUserId(SessionUtils.getUserId());
            adminSmUpdateLogEntity.setUpdateContent(ObjectMapperUtils.toJson(list));
            adminSmUpdateLogEntity.setRemark("\u3010" + adminUserParamDto.getUserId() + "\u3011\u7528\u6237\u5c97\u4f4d\u4fee\u6539\r\n" + oldInfos.toString() + newInfos.toString());
            adminSmUpdateLogEntity.setWorkDate(workDate);
            try {
                this.adminSmUpdateLogRepository.save(adminSmUpdateLogEntity);
            }
            catch (Exception e) {
                this.logger.info(DEPT_ERROR + e.getMessage());
            }
            IcspPage adminSmUserDutyRelVoIcspPage = this.adminSmUserDutyRelRepository.selectDutyInfo(adminSmUserEntity.getAdminSmUserDutyRelEntity());
            List list2 = adminSmUserDutyRelVoIcspPage.getData();
        } else {
            AdminSmUpdateLogEntity adminSmUpdateLogEntity = new AdminSmUpdateLogEntity();
            adminSmUpdateLogEntity.setUpdateLogId(updateLogId);
            adminSmUpdateLogEntity.setRecoType("UD3");
            adminSmUpdateLogEntity.setRecoId(adminUserParamDto.getUserId());
            adminSmUpdateLogEntity.setRecoName("");
            adminSmUpdateLogEntity.setOperUserId(SessionUtils.getUserId());
            adminSmUpdateLogEntity.setUpdateContent(ObjectMapperUtils.toJson(udList));
            adminSmUpdateLogEntity.setRemark("\u3010" + adminUserParamDto.getUserId() + "\u3011\u7528\u6237\u5c97\u4f4d\u5220\u9664\r\n" + oldInfos.toString());
            adminSmUpdateLogEntity.setWorkDate(workDate);
            try {
                this.adminSmUpdateLogRepository.save(adminSmUpdateLogEntity);
            }
            catch (Exception e) {
                this.logger.info(DEPT_ERROR + e.getMessage());
            }
            List list = BeanUtils.beansCopy(udList, AdminSmUserDutyRelEntity.class);
        }
        return result;
    }

    private void forRelateDate(AdminUserParamDto adminUserParamDto, AdminSmUserEntity adminSmUserEntity, StringBuilder oldInfos, List<AdminSmUserDutyRelVo> udList) {
        if (StringUtils.nonEmpty((CharSequence)adminUserParamDto.getUserId())) {
            QueryModel queryModel = new QueryModel();
            IcspPage adminSmUserDutyRelVoIcspPage = this.adminSmUserDutyRelRepository.selectDutyInfo(adminSmUserEntity.getAdminSmUserDutyRelEntity());
            udList = adminSmUserDutyRelVoIcspPage.getData();
            this.adminSmUserRepository.deleteUserDutyRel(adminUserParamDto.getUserId(), adminUserParamDto.getModId());
            for (AdminSmUserDutyRelVo ud : udList) {
                oldInfos.append("\u539f\u5c97\u4f4d: ").append(ud.getDutyName()).append(";").append("\u539f\u673a\u6784: ").append(ud.getOrgName()).append(";").append("\u539f\u7cfb\u7edf: ").append(ud.getSsoName()).append(";  ");
            }
        }
    }

    private Integer forMap1(List<Map<String, String>> relatedData, AdminUserParamDto adminUserParamDto, List<AdminSmUserDutyRelEntity> list, StringBuilder newInfos, int result) {
        for (Map<String, String> map : relatedData) {
            String orgId = map.get(ORG_ID);
            String[] params = map.get(PARAM).split(",");
            boolean auth = this.judgeAuth(adminUserParamDto.getCurrentOrgId(), params, "D");
            if (auth) {
                throw new IcspException("500", "\u5f53\u524d\u767b\u9646\u673a\u6784\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u65b0\u589e");
            }
            if (params.length <= 0 || !StringUtils.nonEmpty((CharSequence)params[0])) continue;
            for (String param : params) {
                AdminSmUserDutyRelEntity adminSmUserDutyRel = new AdminSmUserDutyRelEntity();
                adminSmUserDutyRel.setUserDutyRelId(StringUtils.getUUID());
                adminSmUserDutyRel.setUserId(adminUserParamDto.getUserId());
                adminSmUserDutyRel.setDutyId(param);
                AdminSmDutyDo adminSmDutyDo = this.adminSmDutyRepository.showByDutyId(new DutyId(param));
                adminSmUserDutyRel.setDutyCode(adminSmDutyDo.getDutyCode());
                adminSmUserDutyRel.setOrgId(orgId);
                adminSmUserDutyRel.setModId(adminUserParamDto.getModId());
                adminSmUserDutyRel.setRelSts("A");
                adminSmUserDutyRel.setLastChgUser(new LastChgUser());
                adminSmUserDutyRel.setLastChgDt(new LastChgDt());
                this.adminSmUserDutyRelRepository.insert(adminSmUserDutyRel);
                list.add(adminSmUserDutyRel);
                ++result;
                newInfos.append("\u65b0\u5c97\u4f4d: ").append(adminSmDutyDo.getDutyName()).append(";").append("\u65b0\u673a\u6784: ").append(adminUserParamDto.getOrgName()).append(";").append("\u65b0\u7cfb\u7edf: ").append(adminUserParamDto.getModName()).append(";  ");
            }
        }
        return result;
    }
}

