/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.oca.aggregation.impl;

import cn.com.yusys.yusp.oca.aggregation.AdminSmMenuAggregation;
import cn.com.yusys.yusp.oca.dto.AdminSmMenuDto;
import cn.com.yusys.yusp.oca.entity.AdminSmMenuEntity;
import cn.com.yusys.yusp.oca.entity.MenuTransEntity;
import cn.com.yusys.yusp.oca.repository.AdminSmMenuRepository;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminSmMenuAggregationImpl
implements AdminSmMenuAggregation {
    @Autowired
    private AdminSmMenuRepository adminSmMenuRepository;
    private static final String SINGLE = "single";
    private static final String BETWEEN = "between";

    @Transactional(readOnly=false, rollbackFor={Exception.class, RuntimeException.class})
    public int delete(AdminSmMenuEntity adminSmMenuEntity) {
        int n = 0;
        List list = this.adminSmMenuRepository.getDeleteMenuId(adminSmMenuEntity);
        int listLen = list.size();
        for (int i = 0; i < listLen; ++i) {
            AdminSmMenuEntity deletParam = new AdminSmMenuEntity();
            deletParam.setMenuId((String)list.get(i));
            this.adminSmMenuRepository.deleteRecoMenuInfo(deletParam);
            n += this.adminSmMenuRepository.deleteByPrimaryKey(deletParam);
        }
        return n;
    }

    @Transactional(readOnly=true)
    public List<AdminSmMenuDto> getMenuTree(AdminSmMenuEntity adminSmMenuEntity) {
        List<AdminSmMenuDto> list = new ArrayList();
        boolean lazy = adminSmMenuEntity.isLazy();
        if (lazy) {
            list = this.adminSmMenuRepository.getMenuTreeLazy(adminSmMenuEntity);
        } else {
            AdminSmMenuDto root = new AdminSmMenuDto();
            root.setMenuId("0");
            root.setMenuName("\u4ea4\u6613\u83dc\u5355");
            list = this.adminSmMenuRepository.getMenuTree(adminSmMenuEntity);
            list.add(root);
        }
        return list;
    }

    public void orderTransform(MenuTransEntity menuTransEntity) {
        AdminSmMenuEntity source = menuTransEntity.getSource();
        AdminSmMenuEntity target = menuTransEntity.getTarget();
        if ("inner".equalsIgnoreCase(menuTransEntity.getTransType())) {
            int fieldOrderMax = this.adminSmMenuRepository.getMaxMenuOrder(target);
            this.adminSmMenuRepository.updateDownMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), SINGLE, source.getMenuOrder(), null);
            source.setMenuOrder(Integer.valueOf(fieldOrderMax + 1));
            source.setUpMenuId(target.getMenuId());
            this.adminSmMenuRepository.updateByPrimaryKey(source);
        }
        if ("before".equalsIgnoreCase(menuTransEntity.getTransType())) {
            this.ifMenuId(source, target, menuTransEntity);
        }
        if ("after".equalsIgnoreCase(menuTransEntity.getTransType())) {
            if (source.getUpMenuId().equals(target.getUpMenuId())) {
                if (source.getMenuOrder() > target.getMenuOrder()) {
                    this.adminSmMenuRepository.updateUpMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), BETWEEN, target.getMenuOrder(), source.getMenuOrder());
                    source.setMenuOrder(Integer.valueOf(target.getMenuOrder() + 1));
                    this.adminSmMenuRepository.updateByPrimaryKey(source);
                } else {
                    this.adminSmMenuRepository.updateDownMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), BETWEEN, source.getMenuOrder(), target.getMenuOrder());
                    source.setMenuOrder(target.getMenuOrder());
                    this.adminSmMenuRepository.updateByPrimaryKey(source);
                }
            } else {
                this.adminSmMenuRepository.updateUpMenuOrder(target.getUpMenuId(), menuTransEntity.getTransType(), SINGLE, target.getMenuOrder(), null);
                this.adminSmMenuRepository.updateDownMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), SINGLE, source.getMenuOrder(), null);
                source.setMenuOrder(Integer.valueOf(target.getMenuOrder() + 1));
                source.setUpMenuId(target.getUpMenuId());
                this.adminSmMenuRepository.updateByPrimaryKey(source);
            }
        }
    }

    public void ifMenuId(AdminSmMenuEntity source, AdminSmMenuEntity target, MenuTransEntity menuTransEntity) {
        if (source.getUpMenuId().equals(target.getUpMenuId())) {
            if (source.getMenuOrder() > target.getMenuOrder()) {
                this.adminSmMenuRepository.updateUpMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), BETWEEN, target.getMenuOrder(), source.getMenuOrder());
                source.setMenuOrder(target.getMenuOrder());
                this.adminSmMenuRepository.updateByPrimaryKey(source);
            } else {
                this.adminSmMenuRepository.updateDownMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), BETWEEN, source.getMenuOrder(), target.getMenuOrder());
                source.setMenuOrder(Integer.valueOf(target.getMenuOrder() - 1));
                this.adminSmMenuRepository.updateByPrimaryKey(source);
            }
        } else {
            this.adminSmMenuRepository.updateUpMenuOrder(target.getUpMenuId(), menuTransEntity.getTransType(), SINGLE, target.getMenuOrder(), null);
            this.adminSmMenuRepository.updateDownMenuOrder(source.getUpMenuId(), menuTransEntity.getTransType(), SINGLE, source.getMenuOrder(), null);
            source.setMenuOrder(target.getMenuOrder());
            source.setUpMenuId(target.getUpMenuId());
            this.adminSmMenuRepository.updateByPrimaryKey(source);
        }
    }
}

