/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.common;

import cn.com.yusys.yusp.bsp.toolkit.common.BCCPCRCTools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BCCPTools {
    public static final int VERSION_0X01 = 1;
    public static final int DATA_OPTION = System.getProperty("crcSwitch", "false").equals("true") ? 1 : 0;
    public static final int DATA_OPTION_VALIDATE = 1;
    public static final int DATA_OPTION_COMPRESS = 2;
    private static final String TOOL_NAME = "Protocol Tool Class";
    public static final int PACKAGE_DATA = 0;
    public static final int PACKAGE_UPLOAD = 1;
    public static final int PACKAGE_DOWNLOAD_REQUEST = 2;
    public static final int PACKAGE_DOWNLOAD_REPLY = 3;
    private int version = 1;
    private static final int APPENDIX_SIZE = 0x100000;
    public static final String HEAD_ENCODING = "utf-8";
    private int currentIndex;
    private static final int[] DIGITS = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128};

    public BCCPTools() {
    }

    public BCCPTools(int version) {
        this.version = version;
    }

    public void processSend(OutputStream os, String applicationCode, String tradeCode, String reserveField, String fileName, String relativeDir, Map<String, Object> data, String encode) throws Exception {
        byte[] bodyData = this.packData(data, encode);
        boolean sendFile = false;
        String simpleFilename = "";
        if (fileName != null && fileName.trim().length() != 0) {
            File file = new File(fileName);
            if (file.exists()) {
                sendFile = true;
                simpleFilename = file.getName();
            } else {
                throw new Exception(" File does not exist" + fileName);
            }
        }
        this.sendProtocol(os, applicationCode.getBytes(), tradeCode.getBytes(), reserveField.getBytes(encode), simpleFilename.getBytes(encode), relativeDir.getBytes(encode), bodyData, DATA_OPTION, encode.getBytes());
        if (sendFile) {
            this.sendFile(os, fileName);
        }
    }

    public BCCPProtocol processRecv(InputStream is, String localDir) throws Exception {
        BCCPProtocol bccp = this.receiveProtocol(is);
        if (bccp.getPackageType() != 0) {
            this.receiveFile(is, bccp.getFilePath(), bccp.getRelativeDir(), localDir);
        }
        Map<String, Object> mapData = this.unpackData(bccp.getData(), true, bccp.getEncode());
        bccp.setMapData(mapData);
        return bccp;
    }

    public BCCPProtocol bytesToBCCPProtocol(byte[] data) throws Exception {
        BCCPProtocol pro = new BCCPProtocol();
        byte[] headerlen = new byte[2];
        System.arraycopy(data, 0, headerlen, 0, 2);
        int lenHeader = ByteTools.byte2int(headerlen);
        byte[] header = new byte[lenHeader];
        System.arraycopy(data, 2, header, 0, lenHeader);
        this.unpackProtocolHeader(header, pro);
        byte[] bodylen = new byte[4];
        System.arraycopy(data, 2 + lenHeader, bodylen, 0, 4);
        int lenBody = ByteTools.byte2int(bodylen);
        byte[] body = new byte[lenBody];
        System.arraycopy(data, 2 + lenHeader + 4, body, 0, lenBody);
        if ((pro.getOption() & DIGITS[1]) == DIGITS[1]) {
            byte[] crcLen = new byte[1];
            System.arraycopy(data, 2 + lenHeader + body.length, crcLen, 0, 1);
            int lenCrc = ByteTools.bytes2num(crcLen).intValue();
            byte[] crcData = new byte[lenCrc];
            System.arraycopy(data, 2 + lenHeader + body.length + 1, crcData, 0, lenCrc);
            pro.setCrcData(crcData);
        }
        this.unpackProtocolData(body, pro);
        Map<String, Object> mapData = this.unpackData(pro.getData(), true, pro.getEncode());
        pro.setMapData(mapData);
        return pro;
    }

    public BCCPProtocol unpackBody(byte[] data) throws Exception {
        BCCPProtocol pro = new BCCPProtocol();
        byte[] lenEncodingBytes = new byte[1];
        System.arraycopy(data, 0, lenEncodingBytes, 0, 1);
        int lenEncoding = ByteTools.byte2int(lenEncodingBytes);
        byte[] encoding = new byte[lenEncoding];
        System.arraycopy(data, 1, encoding, 0, lenEncoding);
        pro.setEncode(new String(encoding));
        byte[] body = new byte[data.length - 1 - lenEncoding];
        System.arraycopy(data, 1 + lenEncoding, body, 0, body.length);
        pro.setData(body);
        Map<String, Object> mapData = this.unpackData(pro.getData(), true, pro.getEncode());
        pro.setMapData(mapData);
        return pro;
    }

    public byte[] packBody(Map<String, Object> data, String encode) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bodyData = this.packData(data, encode);
        byte[] dataEncode = encode.getBytes();
        out.write(dataEncode.length);
        out.write(dataEncode);
        out.write(bodyData);
        out.flush();
        return out.toByteArray();
    }

    public byte[] packData(Map<String, Object> data, String encoding) throws Exception {
        byte[] value;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (String key : data.keySet()) {
            byte[] name = key.getBytes(encoding);
            int len = name.length;
            if (len > 250) {
                throw new Exception("Protocol Tool Class @  Field name [" + key + "] is longer than 250");
            }
            Object tempObj = data.get(key);
            if (tempObj instanceof byte[] || tempObj instanceof String) {
                os.write(len);
                os.write(name);
                value = ByteTools.getBytes(tempObj, encoding);
                this.cutOperation(value, os);
                continue;
            }
            if (tempObj instanceof Map) {
                os.write(254);
                os.write(len);
                os.write(name);
                value = this.packData((Map)tempObj, encoding);
                os.write(ByteTools.int2byte(value.length));
                os.write(value);
                continue;
            }
            if (tempObj instanceof List) {
                os.write(255);
                os.write(len);
                os.write(name);
                List list = (List)tempObj;
                os.write(ByteTools.int2byte(list.size()));
                for (Map map : list) {
                    value = this.packData(map, encoding);
                    os.write(ByteTools.int2byte(value.length));
                    os.write(value);
                }
                continue;
            }
            os.write(len);
            os.write(name);
            value = ByteTools.getBytes(tempObj, encoding);
            this.cutOperation(value, os);
        }
        value = os.toByteArray();
        os.close();
        return value;
    }

    public Map<String, Object> unpackData(byte[] data, boolean stringValue, String encoding) throws Exception {
        if (encoding == null || encoding.trim().equals("")) {
            encoding = HEAD_ENCODING;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int index = 0;
        int dataLen = data.length;
        while (index < dataLen) {
            int valueLen;
            byte[] value;
            byte[] name;
            int nameLen;
            if ((nameLen = 0xFF & data[index++]) <= 250) {
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = this.linkOpreation(data, index += nameLen);
                index = this.currentIndex;
                if (stringValue) {
                    map.put(new String(name, encoding), new String(value, encoding));
                    continue;
                }
                map.put(new String(name, encoding), value);
                continue;
            }
            if (nameLen == 254) {
                nameLen = 0xFF & data[index++];
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = new byte[4];
                System.arraycopy(data, index += nameLen, value, 0, 4);
                valueLen = ByteTools.byte2int(value);
                value = new byte[valueLen];
                System.arraycopy(data, index += 4, value, 0, valueLen);
                index += valueLen;
                map.put(new String(name, encoding), this.unpackData(value, stringValue, encoding));
                continue;
            }
            if (nameLen == 255) {
                nameLen = 0xFF & data[index++];
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = new byte[4];
                System.arraycopy(data, index += nameLen, value, 0, 4);
                index += 4;
                int loopCount = ByteTools.byte2int(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < loopCount; ++i) {
                    value = new byte[4];
                    System.arraycopy(data, index, value, 0, 4);
                    valueLen = ByteTools.byte2int(value);
                    value = new byte[valueLen];
                    System.arraycopy(data, index += 4, value, 0, valueLen);
                    index += valueLen;
                    list.add(this.unpackData(value, stringValue, encoding));
                }
                map.put(new String(name, encoding), list);
                continue;
            }
            throw new Exception("Field name length is not supported: " + nameLen);
        }
        return map;
    }

    private byte[] packProtocol(int packageType, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] data, int option, byte[] localFilePath, byte[] relativeDir, byte[] encode) throws Exception {
        if (data == null) {
            data = new byte[]{};
        }
        byte[] crc = new byte[]{};
        if (option != DIGITS[0] && (option & DIGITS[1]) == DIGITS[1]) {
            crc = BCCPCRCTools.genCrcCode(data);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.version);
        os.write(packageType);
        os.write(option);
        this.packPackageHead(packageType, applicationCode, tradeCode, reserveField, localFilePath, relativeDir, os, encode);
        os.write(data);
        os.write(crc);
        data = os.toByteArray();
        os.close();
        return data;
    }

    private BCCPProtocol packProtocol(OutputStream os, int packageType, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] data, int option, byte[] localFilePath, byte[] relativeDir, byte[] encode) throws Exception {
        if (data == null) {
            data = new byte[]{};
        }
        byte[] crc = new byte[]{};
        if (option != DIGITS[0] && (option & DIGITS[1]) == DIGITS[1]) {
            crc = BCCPCRCTools.genCrcCode(data);
        }
        BCCPProtocol pro = new BCCPProtocol();
        ByteArrayOutputStream osHeader = new ByteArrayOutputStream();
        osHeader.write(this.version);
        osHeader.write(packageType);
        osHeader.write(option);
        this.packPackageHead(packageType, applicationCode, tradeCode, reserveField, localFilePath, relativeDir, osHeader, encode);
        DataOutputStream out = new DataOutputStream(os);
        byte[] dataHeader = osHeader.toByteArray();
        pro.setHeadData(dataHeader);
        out.writeShort(dataHeader.length);
        out.write(dataHeader);
        osHeader.close();
        out.writeInt(data.length);
        out.write(data);
        if (crc.length > 0) {
            out.writeByte(crc.length);
            out.write(crc);
        }
        out.flush();
        pro.setCrcData(crc);
        return pro;
    }

    public byte[] packProtocol(int packType, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] localFilePath, byte[] relativeDir, byte[] data, int option, byte[] encode) throws Exception {
        ByteArrayOutputStream bytearrays = new ByteArrayOutputStream();
        if (data == null) {
            data = new byte[]{};
        }
        byte[] crc = new byte[]{};
        if (option != DIGITS[0] && (option & DIGITS[1]) == DIGITS[1]) {
            crc = BCCPCRCTools.genCrcCode(data);
        }
        ByteArrayOutputStream osHeader = new ByteArrayOutputStream();
        osHeader.write(this.version);
        osHeader.write(packType);
        osHeader.write(option);
        this.packPackageHead(packType, applicationCode, tradeCode, reserveField, localFilePath, relativeDir, osHeader, encode);
        DataOutputStream out = new DataOutputStream(bytearrays);
        byte[] dataHeader = osHeader.toByteArray();
        out.writeShort(dataHeader.length);
        out.write(dataHeader);
        osHeader.close();
        out.writeInt(data.length + crc.length);
        out.write(data);
        out.write(crc);
        out.flush();
        return bytearrays.toByteArray();
    }

    public byte[] parseStrToBCCP(String applicationCode, String tradeCode, String reserveField, String fileName, String relativeDir, Map<String, Object> data, String encode) throws Exception {
        byte[] bodyData = this.packData(data, encode);
        int packType = 0;
        String simpleFilename = "";
        if (fileName != null && fileName.trim().length() != 0) {
            File file = new File(fileName);
            if (file.exists()) {
                simpleFilename = file.getName();
                packType = 1;
            } else {
                throw new Exception("The file does not exist:" + fileName);
            }
        }
        return this.packProtocol(packType, applicationCode.getBytes(), tradeCode.getBytes(), reserveField.getBytes(encode), simpleFilename.getBytes(encode), relativeDir.getBytes(encode), bodyData, DATA_OPTION, encode.getBytes());
    }

    private BCCPProtocol unpackProtocol(byte[] inputData) throws Exception {
        boolean verify;
        byte[] data;
        int dataLen;
        int index = 0;
        byte version = inputData[index++];
        byte packageType = inputData[index++];
        byte option = inputData[index++];
        byte[] applicationCode = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] tradeCode = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] reserveField = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] filePath = new byte[]{};
        byte[] relativeDir = new byte[]{};
        if (packageType != 0) {
            filePath = this.linkOpreation(inputData, index);
            index = this.currentIndex;
            relativeDir = this.linkOpreation(inputData, index);
            index = this.currentIndex;
        }
        byte[] encode = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] crc = new byte[]{};
        boolean booCrc = false;
        if ((option & DIGITS[1]) == DIGITS[1]) {
            booCrc = true;
            crc = new byte[4];
            System.arraycopy(inputData, inputData.length - 4, crc, 0, 4);
            dataLen = inputData.length - index - 4;
            data = new byte[dataLen];
            System.arraycopy(inputData, index, data, 0, dataLen);
        } else {
            dataLen = inputData.length - index;
            data = new byte[dataLen];
            System.arraycopy(inputData, index, data, 0, dataLen);
        }
        if (booCrc && !(verify = BCCPCRCTools.verifyCrcCode(data, crc))) {
            throw new Exception("BCCP message verification failed");
        }
        BCCPProtocol pro = new BCCPProtocol();
        pro.setVersion(version);
        pro.setPackageType(packageType);
        pro.setApplicationCode(applicationCode);
        pro.setTradeCode(tradeCode);
        pro.setReserveField(reserveField);
        pro.setData(data);
        pro.setFilePath(new String(filePath, HEAD_ENCODING));
        pro.setRelativeDir(new String(relativeDir, HEAD_ENCODING));
        pro.setProtocol(inputData);
        pro.setEncode(new String(encode, HEAD_ENCODING));
        return pro;
    }

    private void unpackProtocolHeader(byte[] inputData, BCCPProtocol pro) throws Exception {
        pro.setHeadData(inputData);
        int index = 0;
        byte version = inputData[index++];
        byte packageType = inputData[index++];
        byte option = inputData[index++];
        byte[] applicationCode = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] tradeCode = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] reserveField = this.linkOpreation(inputData, index);
        index = this.currentIndex;
        byte[] filePath = new byte[]{};
        byte[] relativeDir = new byte[]{};
        if (packageType != 0) {
            filePath = this.linkOpreation(inputData, index);
            index = this.currentIndex;
            relativeDir = this.linkOpreation(inputData, index);
            index = this.currentIndex;
        }
        byte[] encode = this.linkOpreation(inputData, index);
        pro.setVersion(version);
        pro.setOption(option);
        pro.setPackageType(packageType);
        pro.setApplicationCode(applicationCode);
        pro.setTradeCode(tradeCode);
        pro.setReserveField(reserveField);
        String strEncode = new String(encode);
        pro.setFilePath(new String(filePath, strEncode.length() == 0 ? HEAD_ENCODING : strEncode));
        pro.setRelativeDir(new String(relativeDir, strEncode.length() == 0 ? HEAD_ENCODING : strEncode));
        pro.setEncode(strEncode);
    }

    private void unpackProtocolData(byte[] inputData, BCCPProtocol pro) throws Exception {
        boolean verify;
        int option = pro.getOption();
        byte[] crc = new byte[]{};
        boolean booCrc = false;
        if ((option & DIGITS[1]) == DIGITS[1]) {
            booCrc = true;
            crc = pro.getCrcData();
        }
        byte[] data = inputData;
        if (booCrc && !(verify = BCCPCRCTools.verifyCrcCode(data, crc))) {
            throw new Exception("BCCP message verification failed");
        }
        pro.setData(data);
    }

    public BCCPProtocol receiveProtocol(InputStream is) throws Exception {
        DataInputStream input = new DataInputStream(is);
        List<byte[]> protocol = this.receiveProtocolHeaderAndBody(input);
        BCCPProtocol pro = new BCCPProtocol();
        this.unpackProtocolHeader(protocol.get(0), pro);
        if ((pro.getOption() & DIGITS[1]) == DIGITS[1]) {
            int crcLen = input.readByte() & 0xFF;
            byte[] crc = new byte[crcLen];
            input.readFully(crc);
            pro.setCrcData(crc);
        }
        this.unpackProtocolData(protocol.get(1), pro);
        return pro;
    }

    public String receiveFile(InputStream is, String fileName, String relativeDir, String localDir) throws Exception {
        File file;
        DataInputStream dis = new DataInputStream(is);
        int fileLen = dis.readInt();
        String filePath = localDir + "/";
        if (!"".equals(relativeDir.trim())) {
            filePath = filePath + relativeDir + "/";
        }
        if (!(file = new File(filePath = filePath + fileName)).exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("The local directory create failed");
        }
        if (file.isDirectory()) {
            throw new Exception("Duplicate file name and local directory");
        }
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            while (true) {
                int recvLen;
                byte[] data;
                int len;
                if ((len = dis.read(data = new byte[recvLen = Math.min(fileLen, 8192)])) == -1) {
                    throw new Exception("Receive file exception, connection closed");
                }
                fos.write(data, 0, len);
                if (fileLen == len) {
                    break;
                }
                fileLen -= len;
            }
        }
        return file.getAbsolutePath();
    }

    public void sendFile(OutputStream os, String localFile) throws Exception {
        File file = new File(localFile);
        try (FileInputStream fis = new FileInputStream(file);){
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt((int)file.length());
            do {
                byte[] data;
                int len;
                if ((len = fis.read(data = new byte[8192])) != -1) {
                    dos.write(data, 0, len);
                }
                dos.flush();
            } while (fis.available() > 0);
        }
    }

    private List<byte[]> receiveProtocolHeaderAndBody(DataInputStream input) throws Exception {
        ArrayList<byte[]> datas = new ArrayList<byte[]>();
        short lenHeader = input.readShort();
        byte[] dataHeader = new byte[lenHeader];
        input.readFully(dataHeader);
        datas.add(dataHeader);
        int lenData = input.readInt();
        byte[] data = new byte[lenData];
        input.readFully(data);
        datas.add(data);
        return datas;
    }

    private byte[] receiveProtocol(DataInputStream input) throws Exception {
        int len = input.readInt();
        byte[] data = new byte[len];
        input.readFully(data);
        return data;
    }

    public BCCPProtocol sendProtocol(OutputStream os, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] fileName, byte[] relativeDir, byte[] data, int option, byte[] encode) throws Exception {
        int packType = 0;
        if (fileName != null && fileName.length != 0) {
            packType = 1;
        }
        return this.packProtocol(os, packType, applicationCode, tradeCode, reserveField, data, option, fileName, relativeDir, encode);
    }

    private void sendProtocol(DataOutputStream output, byte[] protocol) throws Exception {
        output.writeShort(protocol.length);
        output.write(protocol);
        output.flush();
    }

    public void uploadFile(InputStream is, OutputStream os, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] data, int option, String localFilePath, String relativeDir, String encode) throws Exception {
        byte[] protocol = this.packProtocol(1, applicationCode, tradeCode, reserveField, data, option, localFilePath.getBytes(HEAD_ENCODING), relativeDir.getBytes(HEAD_ENCODING), encode.getBytes(HEAD_ENCODING));
        DataOutputStream output = new DataOutputStream(os);
        DataInputStream input = new DataInputStream(is);
        this.sendProtocol(output, protocol);
        try (FileInputStream fileInput = new FileInputStream(localFilePath);){
            byte[] appendixId = this.generateAppendixID();
            short index = 1;
            while (true) {
                short s = index;
                index = (short)(index + 1);
                if (this.sendAppendix(output, fileInput, appendixId, s)) {
                    this.receiveAppendixReply(input);
                    continue;
                }
                break;
            }
        }
    }

    public void downloadFile(InputStream is, OutputStream os, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] data, int option, String localFilePath, String relativeDir, String encode) throws Exception {
        byte[] protocol = this.packProtocol(2, applicationCode, tradeCode, reserveField, data, option, localFilePath.getBytes(HEAD_ENCODING), relativeDir.getBytes(HEAD_ENCODING), encode.getBytes(HEAD_ENCODING));
        DataOutputStream output = new DataOutputStream(os);
        DataInputStream input = new DataInputStream(is);
        this.sendProtocol(output, protocol);
        protocol = this.receiveProtocol(input);
        BCCPProtocol head = this.unpackProtocol(protocol);
        File file = new File(localFilePath);
        File parentDir = file.getParentFile();
        if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
            throw new Exception("Create parent directory failed for local file");
        }
        String path = file.getPath();
        try {
            if (!file.createNewFile()) {
                throw new Exception("Create file [" + path + "] failed ");
            }
        }
        catch (Exception e) {
            throw new Exception("Protocol Tool ClassException creating file [" + path + "]: ", e);
        }
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            short appendixCount = head.getAppendixCount();
            Appendix appendix = this.receiveAppendix(input);
            while (true) {
                fileOutput.write(appendix.getData());
                this.sendAppendixReply(output, appendix.getID(), appendix.getNumber());
                if (appendix.getNumber() >= appendixCount) {
                    break;
                }
                appendix = this.receiveAppendix(input);
            }
        }
    }

    public BCCPProtocol fileServer(InputStream is, OutputStream os, String encode) throws Exception {
        DataOutputStream output = new DataOutputStream(os);
        DataInputStream input = new DataInputStream(is);
        byte[] protocol = this.receiveProtocol(input);
        BCCPProtocol pro = this.unpackProtocol(protocol);
        if (pro.getPackageType() == 0) {
            return pro;
        }
        if (pro.getPackageType() == 1) {
            this.receiveUploadFile(output, input, pro.getFilePath(), (int)pro.getAppendixCount());
        } else if (pro.getPackageType() == 2) {
            this.sendDownloadFile(output, input, pro.getFilePath(), pro.getRelativeDir(), encode);
        }
        return pro;
    }

    public void receiveUploadFile(InputStream is, OutputStream os, String filePath, int appendixCount) throws Exception {
        DataOutputStream output = new DataOutputStream(os);
        DataInputStream input = new DataInputStream(is);
        this.receiveUploadFile(output, input, filePath, appendixCount);
    }

    public void sendDownloadFile(InputStream is, OutputStream os, String filePath, String relativeDir, String encode) throws Exception {
        DataOutputStream output = new DataOutputStream(os);
        DataInputStream input = new DataInputStream(is);
        this.sendDownloadFile(output, input, filePath, relativeDir, encode);
    }

    private void receiveUploadFile(DataOutputStream output, DataInputStream input, String filePath, int appendixCount) throws Exception {
        File file = new File(filePath);
        File parentDir = file.getParentFile();
        if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
            throw new Exception("Create parent directory failed for file");
        }
        String path = file.getPath();
        try {
            if (!file.createNewFile()) {
                throw new Exception("Create file [" + path + "] failed ");
            }
        }
        catch (Exception e) {
            throw new Exception("Protocol Tool ClassException creating file [" + path + "]:", e);
        }
        try (FileOutputStream fileOutput = new FileOutputStream(file);){
            Appendix appendix;
            do {
                appendix = this.receiveAppendix(input);
                fileOutput.write(appendix.getData());
                this.sendAppendixReply(output, appendix.getID(), appendix.getNumber());
            } while (appendix.getNumber() < appendixCount);
        }
    }

    private void sendDownloadFile(DataOutputStream output, DataInputStream input, String filePath, String relativeDir, String encode) throws Exception {
        byte[] protocol = this.packProtocol(3, null, null, null, null, DATA_OPTION, filePath.getBytes(HEAD_ENCODING), relativeDir.getBytes(HEAD_ENCODING), encode.getBytes(HEAD_ENCODING));
        this.sendProtocol(output, protocol);
        try (FileInputStream fileInput = new FileInputStream(filePath);){
            byte[] appendixId = this.generateAppendixID();
            short index = 1;
            while (true) {
                short s = index;
                index = (short)(index + 1);
                if (this.sendAppendix(output, fileInput, appendixId, s)) {
                    this.receiveAppendixReply(input);
                    continue;
                }
                break;
            }
        }
    }

    private boolean sendAppendix(DataOutputStream os, FileInputStream input, byte[] appendIxId, short appendixNumber) throws Exception {
        int avail = input.available();
        if (avail < 1) {
            return false;
        }
        if (avail > 0x100000) {
            avail = 0x100000;
        }
        byte[] part = new byte[avail];
        try {
            if (input.read(part) <= 0) {
                part = new byte[]{};
            }
        }
        catch (Exception e) {
            throw new Exception("Protocol Tool Class @  Reading file exception while sending attachment:", e);
        }
        os.write(appendIxId);
        os.writeShort(appendixNumber);
        os.write(0);
        os.writeInt(avail);
        os.write(part);
        os.flush();
        return true;
    }

    private Appendix receiveAppendix(DataInputStream input) throws Exception {
        byte[] id = new byte[24];
        input.readFully(id);
        short number = input.readShort();
        int flag = input.read();
        int len = input.readInt();
        byte[] data = new byte[len];
        input.readFully(data);
        Appendix appendix = new Appendix();
        appendix.setID(id);
        appendix.setNumber(number);
        appendix.setFlag(flag);
        appendix.setData(data);
        return appendix;
    }

    private void sendAppendixReply(DataOutputStream output, byte[] appendixId, short number) throws Exception {
        output.write(appendixId);
        output.writeShort(number);
        output.write(1);
        output.flush();
    }

    private void receiveAppendixReply(DataInputStream dis) throws Exception {
        byte[] appendixId = new byte[24];
        dis.readFully(appendixId);
        short number = dis.readShort();
        int flag = dis.read();
        Appendix appendix = new Appendix();
        appendix.setFlag(flag);
        appendix.setNumber(number);
    }

    private byte[] generateAppendixID() {
        return new byte[24];
    }

    private void packPackageHead(int packageType, byte[] applicationCode, byte[] tradeCode, byte[] reserveField, byte[] fileName, byte[] relativeDir, ByteArrayOutputStream os, byte[] encode) {
        if (applicationCode == null) {
            applicationCode = new byte[]{};
        }
        if (tradeCode == null) {
            tradeCode = new byte[]{};
        }
        if (reserveField == null) {
            reserveField = new byte[]{};
        }
        this.cutOperation(applicationCode, os);
        this.cutOperation(tradeCode, os);
        this.cutOperation(reserveField, os);
        if (packageType != 0) {
            this.cutOperation(fileName, os);
            if (relativeDir == null) {
                relativeDir = new byte[]{};
            }
            this.cutOperation(relativeDir, os);
        }
        this.cutOperation(encode, os);
    }

    public void cutOperation(byte[] data, ByteArrayOutputStream os) {
        int len;
        int index = 0;
        int base250Num = 250;
        int base0Num = 255;
        for (len = data.length; len > base250Num; len -= base250Num) {
            os.write(base0Num);
            os.write(data, index, base250Num);
            index += base250Num;
        }
        os.write(len);
        os.write(data, index, len);
    }

    private byte[] linkOpreation(byte[] data, int index) throws Exception {
        int valueLen;
        int base0Num = 255;
        if ((valueLen = base0Num & data[index++]) != base0Num) {
            byte[] value = new byte[valueLen];
            System.arraycopy(data, index, value, 0, valueLen);
            this.currentIndex = index + valueLen;
            return value;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (valueLen == base0Num) {
            os.write(data, index, 250);
            index += 250;
            valueLen = 0xFF & data[index++];
        }
        os.write(data, index, valueLen);
        os.close();
        this.currentIndex = index + valueLen;
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropFile(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new Exception("The file does not exist:" + fileName);
        }
        Properties config = new Properties();
        FileInputStream in = new FileInputStream(new File(fileName));
        try {
            config.load(in);
            Properties properties = config;
            return properties;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static class Appendix {
        private byte[] ID;
        private short number;
        private byte[] data;
        private int flag;

        public byte[] getID() {
            return this.ID;
        }

        public void setID(byte[] iD) {
            this.ID = iD;
        }

        public short getNumber() {
            return this.number;
        }

        public void setNumber(short number) {
            this.number = number;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }
    }

    public static class BCCPProtocol {
        private int version;
        private int option;
        private byte[] applicationCode;
        private byte[] tradeCode;
        private byte[] reserveField;
        private String encode;
        private int packageType;
        private String filePath;
        private String relativeDir;
        private Map<String, Object> mapData;
        private byte[] crcData;
        private short appendixCount;
        private byte[] data;
        private byte[] headData;
        private byte[] protocol;

        public int getOption() {
            return this.option;
        }

        public void setMapData(Map<String, Object> mapData) {
            this.mapData = mapData;
        }

        public Map<String, Object> getMapData() {
            return this.mapData;
        }

        public void setOption(int option) {
            this.option = option;
        }

        public String getRelativeDir() {
            return this.relativeDir;
        }

        public void setRelativeDir(String relativeDir) {
            this.relativeDir = relativeDir;
        }

        public String getEncode() {
            return this.encode;
        }

        public void setEncode(String encode) {
            this.encode = encode;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public byte[] getApplicationCode() {
            return this.applicationCode;
        }

        public void setApplicationCode(byte[] applicationCode) {
            this.applicationCode = applicationCode;
        }

        public byte[] getTradeCode() {
            return this.tradeCode;
        }

        public void setTradeCode(byte[] tradeCode) {
            this.tradeCode = tradeCode;
        }

        public byte[] getReserveField() {
            return this.reserveField;
        }

        public void setReserveField(byte[] reserveField) {
            this.reserveField = reserveField;
        }

        public int getPackageType() {
            return this.packageType;
        }

        public void setPackageType(int packageType) {
            this.packageType = packageType;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public short getAppendixCount() {
            return this.appendixCount;
        }

        public void setAppendixCount(short appendixCount) {
            this.appendixCount = appendixCount;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getHeadData() {
            return this.headData;
        }

        public void setHeadData(byte[] headData) {
            this.headData = headData;
        }

        public byte[] getProtocol() {
            return this.protocol;
        }

        public void setProtocol(byte[] protocol) {
            this.protocol = protocol;
        }

        public byte[] getCrcData() {
            return this.crcData;
        }

        public void setCrcData(byte[] crcData) {
            this.crcData = crcData;
        }
    }
}

