/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.Attribute;
import cn.com.yusys.yusp.bsp.toolkit.xml.Namespace;
import cn.com.yusys.yusp.bsp.toolkit.xml.StaxTools;
import cn.com.yusys.yusp.bsp.toolkit.xml.XMLNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XMLExecutor
extends AbstractExecutor<byte[]> {
    protected static final String DATA_FORMAT_NAME = "\u6241\u5e73XML";
    protected static final String DATA_FORMAT_SUPPORT_UNICODE = "supportUnicode";
    protected static final String DATA_FORMAT_PACK_XML = "packXml";
    protected static final String DATA_FORMAT_VALUEVARIABLE = "valueVariable";
    protected static final String DATA_FORMAT_CDATAVARIABLE = "cdataVariable";
    protected static final String DATA_FORMAT_LOOPNODES = "loopNodes";
    protected static final String DATA_FORMAT_SIGN = "sign";
    protected static final String ITEM_ATRRIBUTE_TYPE = "type";
    protected static final String ITEM_ATRRIBUTE_PATH = "path";
    protected static final String ITEM_ATRRIBUTE_PREFIX = "prefix";
    protected static final String ITEM_TYPE_VALUE = "value";
    protected static final String ITEM_TYPE_NAMESPACES = "namespace";
    protected static final String ITEM_TYPE_DEFAULT_NAMESPACES = "defNamespace";
    protected static final String ITEM_TYPE_PROPERTY = "property";
    protected static final String ITEM_TYPE_CDATA = "cdata";
    protected static final String ITEM_TYPE_XML = "xml";
    protected static final String SOAP_DEFAULT_SIGN = "_";
    protected final String defNamespace = "xmlns";
    protected String valueVariable = "value";
    protected String cdataVariable = "cdata";
    protected static final String ITEM_ATRRIBUTE_VARNAME = "varName";
    protected boolean supportUnicode = true;
    protected Map<String, Object> soapMap;
    protected List<List<String>> loopNodes;
    protected List<String> signList;
    protected XMLNode soapRoot;
    protected StaxTools staxTools;
    protected LinkedList<String> nodeList;
    protected static final String V_REGEX_SLASH = "[////]";

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public void init(Map<String, String> property) throws Exception {
        Object[] temp;
        String str = property.get(DATA_FORMAT_VALUEVARIABLE);
        if (!StringTools.isEmpty(str)) {
            this.valueVariable = str;
        }
        if (!StringTools.isEmpty(str = property.get(DATA_FORMAT_CDATAVARIABLE))) {
            this.cdataVariable = str;
        }
        if (!StringTools.isEmpty(str = property.get(DATA_FORMAT_SUPPORT_UNICODE))) {
            this.supportUnicode = Boolean.parseBoolean(str);
        }
        if (StringTools.isEmpty(str = property.get(DATA_FORMAT_LOOPNODES))) {
            this.loopNodes = null;
        } else {
            this.loopNodes = new ArrayList<List<String>>();
            for (String string : temp = str.split("[,]")) {
                this.loopNodes.add(this.convertPathToList(string));
            }
        }
        str = property.get(DATA_FORMAT_SIGN);
        if (StringTools.isEmpty(str)) {
            this.signList = null;
        } else {
            this.signList = new ArrayList<String>();
            for (String c : temp = (Object[])str.toCharArray()) {
                this.signList.add(String.valueOf((char)c));
            }
        }
        str = property.get(DATA_FORMAT_PACK_XML);
        boolean packHead = true;
        if ("false".equals(str)) {
            packHead = false;
        }
        this.soapMap = new HashMap<String, Object>();
        this.staxTools = new StaxTools(this.getEncoding());
        this.staxTools.setPackXml(packHead);
        if (this.getPackType() == DATAFORMAT_UNPACK) {
            this.nodeList = new LinkedList();
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            XMLNode xml = this.staxTools.readerXML(inputData);
            this.xmlNode2Map(xml, this.soapMap);
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u89e3\u6790\u62c6\u5305\u65f6\u5f02\u5e38", e);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = null;
        try {
            data = this.staxTools.writeXML(this.soapRoot);
            if (!"UTF-8".equals(this.getEncoding().toUpperCase()) && !this.supportUnicode) {
                data = ByteTools.unicode2Asc(data, this.getEncoding());
            }
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\u5f02\u5e38", e);
        }
        return data;
    }

    protected void xmlNode2Map(XMLNode xml, Object root) throws Exception {
        String tempName;
        String name = xml.getName();
        this.nodeList.add(name);
        String value = xml.getValue().trim();
        Map<String, Object> children = xml.getChildren();
        List<Namespace> namespaces = xml.getNamespaces();
        List<Attribute> attributes = xml.getAttrs();
        String cdata = xml.getCDATA();
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        if (!StringTools.isEmpty(cdata)) {
            nodeMap.put(this.cdataVariable, cdata);
        }
        if (!StringTools.isEmpty(value)) {
            value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), value, 1));
            nodeMap.put(this.valueVariable, value);
        }
        if (!namespaces.isEmpty()) {
            String prefix = null;
            for (Namespace namespace : namespaces) {
                prefix = StringTools.isEmpty(namespace.getPrefix()) ? "xmlns" : namespace.getPrefix();
                prefix = this.convertSign(prefix);
                nodeMap.put(prefix, namespace.getUri());
            }
        }
        if (!attributes.isEmpty()) {
            tempName = null;
            for (Attribute attr : attributes) {
                tempName = this.convertSign(attr.getName());
                value = StringTools.getString(this.invokeMethods(this.getGlobalParseMethod(), attr.getValue(), 1));
                nodeMap.put(tempName, value);
            }
        }
        tempName = this.convertSign(name);
        if (root instanceof List) {
            ((List)root).add(nodeMap);
        } else if (root instanceof Map) {
            ((Map)root).put(tempName, nodeMap);
        }
        Object obj = null;
        for (String key : children.keySet()) {
            LinkedList childrenList;
            obj = children.get(key);
            if (obj instanceof XMLNode) {
                if (this.validateLoop(this.nodeList, key)) {
                    childrenList = new LinkedList();
                    nodeMap.put(key, childrenList);
                    this.xmlNode2Map((XMLNode)obj, childrenList);
                    continue;
                }
                this.xmlNode2Map((XMLNode)obj, nodeMap);
                continue;
            }
            if (!(obj instanceof List)) continue;
            childrenList = new LinkedList();
            nodeMap.put(key, childrenList);
            for (XMLNode tempNode : (List)obj) {
                this.xmlNode2Map(tempNode, childrenList);
            }
        }
        this.nodeList.removeLast();
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        if (StringTools.isEmpty(path)) {
            throw new Exception("\u6241\u5e73XML\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u7f3a\u5c11\u8def\u5f84\u53c2\u6570\uff01");
        }
        this.logger.info("xml\u8def\u5f84:{},{}", (Object)path, (Object)new String(data));
        path = OgnlTools.parseXmlPath(path, this.getRootContext());
        List<String> list = this.convertPathToList(path);
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        if (ITEM_TYPE_VALUE.equals(type) || ITEM_TYPE_CDATA.equals(type) || ITEM_TYPE_DEFAULT_NAMESPACES.equals(type) || ITEM_TYPE_XML.equals(type)) {
            list.add("");
        }
        if (this.soapRoot == null) {
            this.soapRoot = new XMLNode(list.get(0));
        }
        XMLNode node = this.createNode(this.soapRoot, list);
        String prefix = paras.get(ITEM_ATRRIBUTE_PREFIX);
        if (prefix == null) {
            prefix = "";
        }
        if (ITEM_TYPE_VALUE.equals(type)) {
            node.setValue(data, this.getEncoding());
            node.setPrefix(prefix);
        } else if (ITEM_TYPE_PROPERTY.equals(type)) {
            String attrName = list.get(list.size() - 1);
            node.addAttrs(prefix, attrName, new String(data, this.getEncoding()));
        } else if (ITEM_TYPE_NAMESPACES.equals(type)) {
            String str = list.get(list.size() - 1);
            node.addNamespace(str, new String(data, this.getEncoding()));
        } else if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            node.addNamespace("", new String(data, this.getEncoding()));
        } else if (ITEM_TYPE_CDATA.equals(type)) {
            node.setCDATA(new String(data, this.getEncoding()));
        } else if (ITEM_TYPE_XML.equals(type)) {
            XMLNode xmlNode = this.staxTools.readerXML(data);
            node.addChild(xmlNode);
        }
    }

    @Override
    public Map<String, Object> autoUnpack() throws Exception {
        return this.soapMap;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String path = paras.get(ITEM_ATRRIBUTE_PATH);
        if (StringTools.isEmpty(path)) {
            throw new Exception("\u6241\u5e73XML\u4e2d[" + item.getName() + "]\u5b57\u6bb5\u7f3a\u5c11\u8def\u5f84\u53c2\u6570\uff01");
        }
        path = OgnlTools.parseXmlPath(path, this.getRootContext());
        path = this.convertSign(path);
        path = this.convertPathToPoint(path);
        String type = paras.get(ITEM_ATRRIBUTE_TYPE);
        if (ITEM_TYPE_VALUE.equals(type)) {
            path = path + "." + this.valueVariable;
        } else if (ITEM_TYPE_CDATA.equals(type)) {
            path = path + "." + this.cdataVariable;
        } else if (ITEM_TYPE_DEFAULT_NAMESPACES.equals(type)) {
            path = path + ".xmlns";
        }
        Object obj = OgnlTools.getValue(path, this.soapMap);
        if (ITEM_TYPE_XML.equals(type)) {
            // empty if block
        }
        return ByteTools.getBytes(obj, this.getEncoding());
    }

    @Override
    public int getSearchIndex() {
        return 0;
    }

    protected String convertSign(String str) {
        if (this.signList == null || StringTools.isEmpty(str)) {
            return str;
        }
        for (String temp : this.signList) {
            if (!str.contains(temp)) continue;
            return str.replace(temp, SOAP_DEFAULT_SIGN);
        }
        return str;
    }

    protected List<String> convertPathToList(String path) {
        String[] loopNode;
        ArrayList<String> loop = new ArrayList<String>();
        for (String s : loopNode = path.split(V_REGEX_SLASH)) {
            if (StringTools.isEmpty(s)) continue;
            loop.add(s);
        }
        return loop;
    }

    protected String convertPathToPoint(String path) {
        StringBuffer sb = new StringBuffer();
        String[] loopNode = path.split(V_REGEX_SLASH);
        String str = null;
        for (int i = 0; i < loopNode.length; ++i) {
            if (i > 1) {
                sb.append(".");
            }
            if (StringTools.isEmpty(str = loopNode[i])) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    protected XMLNode createNode(XMLNode xml, List<String> nodes) throws Exception {
        LinkedList<String> listNode = new LinkedList<String>();
        listNode.add(nodes.get(0));
        String tempName = null;
        int start = -1;
        int index = -1;
        int end = -1;
        Object obj = null;
        XMLNode root = xml;
        for (int i = 1; i < nodes.size() - 1; ++i) {
            XMLNode node;
            List<XMLNode> list;
            index = -1;
            tempName = nodes.get(i);
            start = tempName.indexOf("[");
            end = tempName.indexOf("]");
            if (start != -1 && end != -1) {
                index = Integer.parseInt(tempName.substring(start + 1, end));
                tempName = tempName.substring(0, start);
            }
            if ((obj = root.getChildren().get(tempName)) == null) {
                if (index != -1) {
                    list = new LinkedList();
                    node = new XMLNode(tempName);
                    list.add(node);
                    root.getChildren().put(tempName, list);
                    root = node;
                    continue;
                }
                XMLNode node2 = new XMLNode(tempName);
                root.getChildren().put(tempName, node2);
                root = node2;
                continue;
            }
            if (obj instanceof XMLNode) {
                root = (XMLNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            list = (List)obj;
            if (index > list.size()) {
                throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\u65f6\uff0c\u6570\u7ec4\u8d8a\u754c\uff0cindex[" + index + "] > \u6570\u7ec4\u957f\u5ea6[" + list.size() + "]");
            }
            if (index == list.size()) {
                node = new XMLNode(tempName);
                list.add(node);
                root = node;
                continue;
            }
            if (index == -1) {
                throw new Exception("[" + this.getExecutorName() + "]\u62fc\u5305\uff0c\u8282\u70b9[" + this.getPath(nodes, i) + "]\u4e3a\u5faa\u73af\u8282\u70b9");
            }
            root = (XMLNode)list.get(index);
        }
        return root;
    }

    protected boolean validateLoop(LinkedList<String> nodeList, String key) {
        if (this.loopNodes == null) {
            return false;
        }
        boolean res = false;
        nodeList.add(key);
        for (List<String> list : this.loopNodes) {
            if (list.size() != nodeList.size() || !list.equals(nodeList)) continue;
            res = true;
            break;
        }
        nodeList.removeLast();
        return res;
    }

    protected String getPath(List<String> list, int index) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i <= index; ++i) {
            sb.append("/");
            sb.append(list.get(i));
        }
        return sb.toString();
    }
}

